/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ann;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.unitarou.lang.UEnum;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.FileFormat;
import org.unitarou.sgf.type.GameMode;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.Style;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.swt.EnumCombo;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.ControllerStatusViewer;
import org.unitarou.yukinoshita.view.GameViewer;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.NodeViewer;
import org.unitarou.yukinoshita.view.jface.ann.AnnotationPanel;
import org.unitarou.yukinoshita.view.jface.ann.CharsetEditor;
import org.unitarou.yukinoshita.view.jface.ann.Editor;
import org.unitarou.yukinoshita.view.jface.ann.SizeEditor;
import org.unitarou.yukinoshita.view.jface.util.UEnumCombo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootAnnotationPanel
extends AnnotationPanel
implements WidgetContainer {
    private static final MessageResource CLB_EDIT_ADVANCED_TYPE = new MessageResource(RootAnnotationPanel.class, "clbEditAdvancedType");
    private static final SgfId[] TYPE_ENUM = new SgfId[]{SgfId.GAME_MODE, SgfId.STYLE};
    private final Map<SgfId, Object> widgetMap_ = new HashMap<SgfId, Object>();
    private GameMediator gameMediator_ = null;
    private Button chAdvancedEditMode_;
    private final Adapter adapter_ = new Adapter();
    private boolean isEditMode_ = false;
    private final ComboFocusLost comboFocusLost_ = new ComboFocusLost();
    private final TextFocusLost textFocusLost_ = new TextFocusLost();
    private final ModifyListened modifyListened_ = new ModifyListened();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        Object ret = super.getAdapter(adapter);
        if (ret != null) {
            return ret;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout(new GridLayout(2, false));
        this.createCbEditAdvancedType(composite);
        this.createApplicationEdit(composite);
        this.createCharset(composite);
        this.createEnumCombo2(composite, SgfId.FILE_FORMAT, EnumSet.allOf(FileFormat.class));
        this.createEnumCombo(composite, SgfId.GAME_MODE, GameMode.class);
        this.createEnumCombo2(composite, SgfId.GAME_TYPE, EnumSet.allOf(GameType.class));
        this.createEnumCombo(composite, SgfId.STYLE, Style.class);
        this.createSizeEditor(composite);
        this.adapter_.setEditMode(this.isEditMode_);
        composite.pack();
        return composite;
    }

    private void createCbEditAdvancedType(Composite parent) {
        this.chAdvancedEditMode_ = new Button(parent, 0x800020);
        this.chAdvancedEditMode_.setSelection(false);
        this.chAdvancedEditMode_.setText(CLB_EDIT_ADVANCED_TYPE.get());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.chAdvancedEditMode_.setLayoutData(gridData);
        this.chAdvancedEditMode_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RootAnnotationPanel.this.setEnableAdvanced(((Button)e.widget).getSelection());
            }
        });
    }

    private void setEnableAdvanced(boolean enable) {
        Text text = (Text)this.widgetMap_.get(SgfId.APPLICATION);
        text.setEditable(enable && this.isEditMode_);
        EnumCombo ec = (EnumCombo)this.widgetMap_.get(SgfId.FILE_FORMAT);
        ec.getCombo().setEnabled(enable && this.isEditMode_);
        UEnumCombo uec = (UEnumCombo)this.widgetMap_.get(SgfId.GAME_MODE);
        uec.getCombo().setEnabled(enable && this.isEditMode_);
        SizeEditor sizeCombos = (SizeEditor)this.widgetMap_.get(SgfId.SIZE);
        sizeCombos.setAdvanced(enable);
    }

    private void createApplicationEdit(Composite parent) {
        Label label = new Label(parent, 131072);
        label.setText(SgfId.APPLICATION.displayName());
        label.setLayoutData(new GridData(128));
        Text text = new Text(parent, 2052);
        text.setLayoutData(new GridData(768));
        text.addFocusListener(this.textFocusLost_);
        text.setData(SgfId.APPLICATION);
        this.widgetMap_.put(SgfId.APPLICATION, text);
    }

    private void createCharset(Composite parent) {
        Label label = new Label(parent, 131072);
        label.setText(SgfId.CHARSET.displayName());
        label.setLayoutData(new GridData(128));
        CharsetEditor charsetEditor = new CharsetEditor();
        charsetEditor.createContents(parent);
        charsetEditor.addModifyListener(this.modifyListened_);
        this.widgetMap_.put(SgfId.CHARSET, charsetEditor);
    }

    private <T extends UEnum> Combo createEnumCombo(Composite parent, SgfId sgfType, Class<T> enumClass) {
        Label label = new Label(parent, 131072);
        label.setText(sgfType.displayName());
        label.setLayoutData(new GridData(128));
        UEnumCombo<T> uenumCombo = new UEnumCombo<T>(enumClass);
        Combo combo = (Combo)uenumCombo.createContents(parent);
        combo.setLayoutData(new GridData(768));
        combo.addFocusListener(this.comboFocusLost_);
        combo.setData(sgfType);
        this.widgetMap_.put(sgfType, uenumCombo);
        return combo;
    }

    private <T extends Enum<T>> Combo createEnumCombo2(Composite parent, SgfId sgfType, EnumSet<T> values) {
        Label label = new Label(parent, 131072);
        label.setText(sgfType.displayName());
        label.setLayoutData(new GridData(128));
        EnumCombo<T> enumCombo = new EnumCombo<T>(values);
        Combo combo = (Combo)enumCombo.createContents(parent);
        combo.setLayoutData(new GridData(768));
        combo.addFocusListener(this.comboFocusLost_);
        combo.setData(sgfType);
        this.widgetMap_.put(sgfType, enumCombo);
        return combo;
    }

    private void createSizeEditor(Composite parent) {
        Label label = new Label(parent, 131072);
        label.setText(SgfId.SIZE.displayName());
        label.setLayoutData(new GridData(128));
        Composite panel = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        panel.setLayoutData(gridData);
        SizeEditor sizeEditor = new SizeEditor();
        sizeEditor.createContents(panel);
        sizeEditor.addModifyListener(this.modifyListened_);
        this.widgetMap_.put(SgfId.SIZE, sizeEditor);
    }

    @Override
    public void dispose() {
    }

    private NodeView getRootNodeView() {
        if (this.gameMediator_ == null) {
            throw new IllegalStateException();
        }
        return this.gameMediator_.getNodeList().getNodeView(0);
    }

    private class Adapter
    implements GameViewer,
    NodeViewer,
    ControllerStatusViewer {
        Adapter() {
        }

        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            RootAnnotationPanel.this.gameMediator_ = gameMediator;
            this.updateImpl();
        }

        public void update(NodeView nodeView) {
            ArgumentChecker.throwIfNull((Object)nodeView);
            this.updateImpl();
        }

        private void updateImpl() {
            NodeView rootNodeView = RootAnnotationPanel.this.getRootNodeView();
            Property property = rootNodeView.getProperty(SgfId.APPLICATION);
            Text text = (Text)RootAnnotationPanel.this.widgetMap_.get(SgfId.APPLICATION);
            text.setText(property != null ? property.value().getString() : "");
            property = rootNodeView.getProperty(SgfId.CHARSET);
            CharsetEditor charsetEditor = (CharsetEditor)RootAnnotationPanel.this.widgetMap_.get(SgfId.CHARSET);
            charsetEditor.setText(property != null ? property.value().getString() : "");
            property = rootNodeView.getProperty(SgfId.FILE_FORMAT);
            EnumCombo ecff = (EnumCombo)RootAnnotationPanel.this.widgetMap_.get(SgfId.FILE_FORMAT);
            FileFormat fileFormat = null;
            if (property != null) {
                try {
                    fileFormat = FileFormat.parse(property.value().getString());
                }
                catch (TypeParseException e) {
                    e.printStackTrace();
                }
            }
            ecff.select(fileFormat);
            property = rootNodeView.getProperty(SgfId.GAME_MODE);
            UEnumCombo uec = (UEnumCombo)RootAnnotationPanel.this.widgetMap_.get(SgfId.GAME_MODE);
            uec = (UEnumCombo)RootAnnotationPanel.this.widgetMap_.get(SgfId.GAME_MODE);
            GameMode gameMode = null;
            if (property != null) {
                gameMode = GameMode.parse(property.value().getString());
            }
            uec.select(gameMode);
            property = rootNodeView.getProperty(SgfId.GAME_TYPE);
            EnumCombo ec = (EnumCombo)RootAnnotationPanel.this.widgetMap_.get(SgfId.GAME_TYPE);
            GameType gameType = null;
            if (property != null) {
                try {
                    gameType = GameType.parse(property.value().getString());
                }
                catch (TypeParseException e) {
                    e.printStackTrace();
                }
            }
            ec.select(gameType);
            property = rootNodeView.getProperty(SgfId.STYLE);
            uec = (UEnumCombo)RootAnnotationPanel.this.widgetMap_.get(SgfId.STYLE);
            Style style = null;
            if (property != null) {
                style = Style.parse(property.value().getString());
            }
            uec.select(style);
            property = rootNodeView.getProperty(SgfId.SIZE);
            SizeEditor sizeEditor = (SizeEditor)RootAnnotationPanel.this.widgetMap_.get(SgfId.SIZE);
            SgfSize sgfSize = SgfSize.DEFAULT;
            if (property != null) {
                try {
                    sgfSize = SgfSize.parse(property.value().getString());
                }
                catch (TypeParseException e) {
                    e.printStackTrace();
                }
            }
            sizeEditor.select(sgfSize);
        }

        public void setEditMode(boolean isEditMode) {
            RootAnnotationPanel.this.isEditMode_ = isEditMode;
            int i = 0;
            while (i < TYPE_ENUM.length) {
                UEnumCombo enumCombo = (UEnumCombo)RootAnnotationPanel.this.widgetMap_.get(TYPE_ENUM[i]);
                enumCombo.setEditable(isEditMode);
                ++i;
            }
            EnumCombo ec = (EnumCombo)RootAnnotationPanel.this.widgetMap_.get(SgfId.FILE_FORMAT);
            ec.getCombo().setEnabled(isEditMode);
            ec = (EnumCombo)RootAnnotationPanel.this.widgetMap_.get(SgfId.GAME_TYPE);
            ec.getCombo().setEnabled(isEditMode);
            Text text = (Text)RootAnnotationPanel.this.widgetMap_.get(SgfId.APPLICATION);
            text.setEditable(isEditMode);
            SizeEditor sizeEditor = (SizeEditor)RootAnnotationPanel.this.widgetMap_.get(SgfId.SIZE);
            sizeEditor.setEditable(isEditMode);
            CharsetEditor charsetEditor = (CharsetEditor)RootAnnotationPanel.this.widgetMap_.get(SgfId.CHARSET);
            charsetEditor.setEditable(isEditMode);
            RootAnnotationPanel.this.setEnableAdvanced(RootAnnotationPanel.this.chAdvancedEditMode_.getSelection());
        }

        public void changeHandlerPhase(HandlerPhase status) {
        }
    }

    private class ComboFocusLost
    extends FocusAdapter {
        ComboFocusLost() {
        }

        public void focusLost(FocusEvent e) {
            if (!RootAnnotationPanel.this.isEditMode_) {
                return;
            }
            Combo combo = (Combo)e.widget;
            SgfId sgfType = (SgfId)combo.getData();
            Object obj = RootAnnotationPanel.this.widgetMap_.get(sgfType);
            String newDatum = null;
            if (obj instanceof UEnumCombo) {
                UEnumCombo enumCombo = (UEnumCombo)RootAnnotationPanel.this.widgetMap_.get(sgfType);
                newDatum = enumCombo.getSelectedDatum();
            } else if (obj instanceof EnumCombo) {
                EnumCombo enumCombo = (EnumCombo)RootAnnotationPanel.this.widgetMap_.get(sgfType);
                Object selected = enumCombo.getSelected();
                TypedString typedString = (TypedString)selected;
                newDatum = typedString != null ? typedString.getString() : "";
            }
            RootAnnotationPanel.this.updateProperty(newDatum, sgfType, RootAnnotationPanel.this.getRootNodeView());
        }
    }

    private class TextFocusLost
    extends FocusAdapter {
        TextFocusLost() {
        }

        public void focusLost(FocusEvent e) {
            if (!RootAnnotationPanel.this.isEditMode_) {
                return;
            }
            Text text = (Text)e.widget;
            SgfId sgfType = (SgfId)text.getData();
            String newDatum = text.getText();
            RootAnnotationPanel.this.updateProperty(newDatum, sgfType, RootAnnotationPanel.this.getRootNodeView());
        }
    }

    private class ModifyListened
    implements ModifyListener {
        ModifyListened() {
        }

        public void modifyText(ModifyEvent e) {
            SgfId sgfType = (SgfId)e.widget.getData();
            String newDatum = ((Editor)RootAnnotationPanel.this.widgetMap_.get(sgfType)).getDatum();
            RootAnnotationPanel.this.updateProperty(newDatum, sgfType, RootAnnotationPanel.this.getRootNodeView());
        }
    }
}

