/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.unitarou.jface.ColorResource;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.Label;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfLine;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.sgf.util.Stone;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.board.BlockedBoardDesigner;
import org.unitarou.yukinoshita.model.board.IgoBoard;
import org.unitarou.yukinoshita.view.ContextViewer;
import org.unitarou.yukinoshita.view.GameViewer;
import org.unitarou.yukinoshita.view.NodeViewer;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.BoardPainter;
import org.unitarou.yukinoshita.view.jface.board.CoordinatesPainter;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.MarkPainter;
import org.unitarou.yukinoshita.view.jface.board.RuledLinePainter;
import org.unitarou.yukinoshita.view.jface.board.SimpleBoardPainter;
import org.unitarou.yukinoshita.view.jface.board.SimpleCoordinatesPainter;
import org.unitarou.yukinoshita.view.jface.board.SimpleRuledLinePainter;
import org.unitarou.yukinoshita.view.jface.board.mp.SimpleMarkerPainter;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainter;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainterParameter;
import org.unitarou.yukinoshita.view.provider.blklp.BlockLabelProvider;
import org.unitarou.yukinoshita.view.provider.vlp.VariationLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgoGraphicalBoardPanel
implements IgoBoardPanel {
    private static final Log log_s_ = LogFactory.getLog(IgoGraphicalBoardPanel.class);
    private static final int MINIMUM_BLOCK_SIZE = 2;
    private static final ColorResource FOREGROUND_CANT_PAINT = new ColorResource(255, 0, 0);
    private static final SgfId[] IDS_STONE = new SgfId[]{SgfId.WHITE, SgfId.BLACK, SgfId.ADD_WHITE, SgfId.ADD_BLACK, SgfId.ADD_EMPTY};
    private Canvas canvas_ = null;
    private SgfRectangle view_ = new SgfRectangle();
    private BoardPainter boardPainter_ = new SimpleBoardPainter();
    private RuledLinePainter ruledLinePainter_ = new SimpleRuledLinePainter();
    private CoordinatesPainter coordinatesPainter_ = new SimpleCoordinatesPainter();
    private StonePainter stonePainter_ = StonePainter.CONTEXT.defaultProvider();
    private MarkPainter markPainter_ = new SimpleMarkerPainter();
    private int blockSize_;
    private Point labelSize_ = new Point(1, 1);
    private Point offsetSize_ = new Point(0, 0);
    private EventBroker eventBroker_ = null;
    private NodeView nodeView_;
    private final BlockedBoardDesigner blockedBoardDesigner_ = new BlockedBoardDesigner(new IgoBoard(SgfSize.DEFAULT));
    private CurrentContext context_;
    private final HashMap<SgfPoint, BlockStatus> blockStatusMap_ = new HashMap();
    private boolean usesDoubleBuffer_ = true;
    private Property transientProperty_ = null;
    private Adapter adapter_ = new Adapter();
    private BlockLabelProvider blockLabelProvider_ = BlockLabelProvider.CONTEXT.defaultProvider();
    private VariationLabelProvider variationLabelProvider_ = VariationLabelProvider.CONTEXT.defaultProvider();
    private boolean showLastMoveMark_ = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public IgoGraphicalBoardPanel() {
        this.context_ = CurrentContext.nullContext;
        this.blockedBoardDesigner_.addBlockPainter(this.boardPainter_);
        this.blockedBoardDesigner_.addBlockPainter(this.ruledLinePainter_);
        this.blockedBoardDesigner_.addBlockPainter(this.stonePainter_);
        this.blockedBoardDesigner_.addBlockPainter(this.markPainter_);
        this.blockedBoardDesigner_.addBlockPainter(this.blockLabelProvider_);
    }

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite parent) {
        ArgumentChecker.throwIfNull((Object)parent);
        this.canvas_ = new Canvas(parent, 262144);
        this.canvas_.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle paintArea = new Rectangle(e.x, e.y, e.width, e.height);
                if (IgoGraphicalBoardPanel.this.usesDoubleBuffer_) {
                    IgoGraphicalBoardPanel.this.paintByDoubleBuffer(e.gc, paintArea);
                } else {
                    IgoGraphicalBoardPanel.this.paint(e.gc, paintArea);
                }
            }
        });
        this.canvas_.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                IgoGraphicalBoardPanel.this.blockStatusMap_.clear();
            }
        });
        return this.canvas_;
    }

    @Override
    public void dispose() {
        this.canvas_.dispose();
        this.eventBroker_ = EventBroker.NULL_BROKER;
        this.nodeView_ = null;
    }

    @Override
    public Canvas getCanvas() {
        return this.canvas_;
    }

    private void paintByDoubleBuffer(GC gc, Rectangle paintArea) {
        Image image = null;
        GC imageGc = null;
        try {
            image = new Image((Device)this.canvas_.getDisplay(), this.canvas_.getBounds());
            imageGc = new GC(image);
            this.paint(imageGc, paintArea);
            gc.drawImage(image, 0, 0);
        }
        finally {
            if (imageGc != null) {
                imageGc.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
    }

    private void paint(GC gc, Rectangle paintArea) {
        if (this.nodeView_ == null) {
            log_s_.info("Call paint(GC gc, Rectangle paintArea) before init model.");
            return;
        }
        SgfSize size = this.nodeView_.getSize();
        this.view_ = this.blockedBoardDesigner_.calcView();
        this.calcDrawParameters();
        if (this.blockSize_ < 2) {
            this.paintCantDraw(gc);
            return;
        }
        Rectangle boardRect = this.calcDrawArea(this.view_);
        this.paintBackground(gc, boardRect);
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        this.coordinatesPainter_.paint(gc, boardRect, this.view_, blArray);
        int y = this.view_.getStart().y();
        while (y <= this.view_.getEnd().y()) {
            int x = this.view_.getStart().x();
            while (x <= this.view_.getEnd().x()) {
                SgfPoint point = SgfPoint.create(size, x, y);
                if (this.blockedBoardDesigner_.isDrawArea(point)) {
                    this.paintImpl(gc, paintArea, point);
                } else {
                    this.paintBackground(gc, point);
                }
                ++x;
            }
            ++y;
        }
        this.paintLabel(gc);
        this.paintLine(gc);
        this.paintVariation(gc);
        this.paintTransientStone(gc, boardRect);
        this.paintTransientMarkers(gc);
    }

    private void paintCantDraw(GC gc) {
        Point point = this.canvas_.getSize();
        int size = Math.min(point.x, point.y);
        gc.setForeground(FOREGROUND_CANT_PAINT.get());
        gc.setBackground(Display.getCurrent().getSystemColor(22));
        gc.fillRectangle(0, 0, point.x, point.y);
        gc.drawRectangle(0, 0, size - 1, size - 1);
        gc.drawLine(0, 0, size, size);
        gc.drawLine(0, size, size, 0);
    }

    private void paintBackground(GC gc, Rectangle boardRect) {
        gc.setBackground(this.canvas_.getDisplay().getSystemColor(22));
        Rectangle rect = this.canvas_.getBounds();
        gc.fillRectangle(0, 0, boardRect.x, rect.height);
        gc.fillRectangle(boardRect.x, 0, rect.width, boardRect.y);
        gc.fillRectangle(boardRect.x + boardRect.width, boardRect.y, rect.width, rect.height);
        gc.fillRectangle(boardRect.x, boardRect.y + boardRect.height, rect.width, rect.height);
    }

    private void paintBackground(GC gc, SgfPoint blockPoint) {
        gc.setBackground(this.canvas_.getDisplay().getSystemColor(22));
        Rectangle rectangle = this.calcBlockArea(blockPoint);
        ++rectangle.width;
        ++rectangle.height;
        gc.fillRectangle(rectangle);
    }

    private void paintImpl(GC gc, Rectangle paintArea, SgfPoint point) {
        Rectangle rectangle = this.calcBlockArea(point);
        if (rectangle.x + rectangle.width < paintArea.x || paintArea.x + paintArea.width < rectangle.x || rectangle.y + rectangle.height < paintArea.y || paintArea.y + paintArea.height < rectangle.y) {
            return;
        }
        this.boardPainter_.paint(gc, point, rectangle);
        this.ruledLinePainter_.paint(gc, point, rectangle);
        this.paintStone(gc, point, rectangle);
        this.paintMarks(gc, point, rectangle);
        this.paintStatus(gc, this.blockStatusMap_.get(point));
    }

    private void calcDrawParameters() {
        Rectangle canvasSize = this.canvas_.getBounds();
        this.labelSize_ = this.coordinatesPainter_.calcLabelSize(this.view_);
        this.blockSize_ = Math.min((canvasSize.width - this.labelSize_.x) / this.view_.width(), (canvasSize.height - this.labelSize_.y) / this.view_.height());
        this.blockSize_ = Math.min(this.blockSize_, this.context_.getInteger(Context.MAX_STONE_SIZE));
        this.offsetSize_.x = (canvasSize.width - (this.blockSize_ * this.view_.width() + this.labelSize_.x)) / 2;
        this.offsetSize_.y = (canvasSize.height - (this.blockSize_ * this.view_.height() + this.labelSize_.y)) / 2;
    }

    private Rectangle calcBlockArea(SgfPoint point) {
        return new Rectangle(this.labelSize_.x + (point.x() - this.view_.getStart().x()) * this.blockSize_ + this.offsetSize_.x, this.labelSize_.y + (point.y() - this.view_.getStart().y()) * this.blockSize_ + this.offsetSize_.y, this.blockSize_, this.blockSize_);
    }

    private Rectangle calcDrawArea(SgfRectangle area) {
        return new Rectangle(this.labelSize_.x + (area.getStart().x() - this.view_.getStart().x()) * this.blockSize_ + this.offsetSize_.x, this.labelSize_.y + (area.getStart().y() - this.view_.getStart().y()) * this.blockSize_ + this.offsetSize_.y, area.width() * this.blockSize_, area.height() * this.blockSize_);
    }

    private void paintStone(GC gc, SgfPoint point, Rectangle rectangle) {
        StonePainterParameter parameter;
        EnumSet<SgfPointType> pointTypes = this.getBlockStatusImpl(point).getPointTypes();
        if (pointTypes.contains((Object)SgfPointType.WHITE)) {
            parameter = new StonePainterParameter();
            parameter.setSgfColor(SgfColor.WHITE);
        } else if (pointTypes.contains((Object)SgfPointType.BLACK)) {
            parameter = new StonePainterParameter();
            parameter.setSgfColor(SgfColor.BLACK);
        } else {
            return;
        }
        if (this.transientProperty_ != null) {
            SgfId[] sgfIdArray = IDS_STONE;
            int n = 0;
            int n2 = sgfIdArray.length;
            while (n < n2) {
                SgfId id = sgfIdArray[n];
                if (this.transientProperty_.contains(id, point.getString())) {
                    parameter.setTransient(true);
                    break;
                }
                ++n;
            }
        }
        Stone move = this.nodeView_.getMove();
        String label = this.blockLabelProvider_.getLabel(this.nodeView_, point);
        parameter.setLastMove(this.showLastMoveMark_ && point.equals(move.getPoint()));
        parameter.setLabel(label);
        this.stonePainter_.paintStone(gc, rectangle, parameter);
    }

    private void paintMarks(GC gc, SgfPoint point, Rectangle rectangle) {
        SgfId[] sgfIdArray = this.blockedBoardDesigner_.getMarkers(point);
        int n = 0;
        int n2 = sgfIdArray.length;
        while (n < n2) {
            SgfId sgfId = sgfIdArray[n];
            if (this.transientProperty_ != null && this.transientProperty_.contains(sgfId, point.getString())) break;
            this.markPainter_.paintMark(gc, rectangle, sgfId, false);
            ++n;
        }
    }

    private void paintStatus(GC gc, BlockStatus status) {
        this.markPainter_.paintStatus(gc, status);
    }

    private void paintTransientStone(GC gc, Rectangle boardRect) {
        if (this.transientProperty_ == null) {
            return;
        }
        SgfColor sgfColor = SgfColor.getStoneColor(this.transientProperty_.sgfId());
        if (sgfColor == null) {
            return;
        }
        StonePainterParameter parameter = new StonePainterParameter();
        parameter.setLabel(null);
        parameter.setLastMove(false);
        parameter.setTransient(true);
        parameter.setSgfColor(sgfColor);
        String[] stringArray = this.transientProperty_.value().getStrings();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            Rectangle block;
            String string = stringArray[n];
            SgfPoint point = SgfPoint.parseMoveQuietly(this.nodeView_.getSize(), string);
            if (point != null && Geometry.getRelativePosition(boardRect, Geometry.centerPoint(block = this.calcBlockArea(point))) == 0) {
                this.stonePainter_.paintStone(gc, block, parameter);
            }
            ++n;
        }
    }

    private void paintTransientMarkers(GC gc) {
        if (this.transientProperty_ == null) {
            return;
        }
        SgfId[] sgfTypes = this.markPainter_.markerScope();
        int i = 0;
        while (i < sgfTypes.length) {
            if (sgfTypes[i].equals(this.transientProperty_.sgfId())) {
                String[] stringArray = this.transientProperty_.value().getStrings();
                int n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    String datum = stringArray[n];
                    SgfPoint point = SgfPoint.parseMoveQuietly(this.nodeView_.getSize(), datum);
                    if (point != null) {
                        Rectangle block = this.calcBlockArea(point);
                        this.markPainter_.paintMark(gc, block, sgfTypes[i], true);
                    }
                    ++n;
                }
            }
            ++i;
        }
    }

    private void paintLabel(GC gc) {
        Rectangle rectangle;
        Label[] labels = this.blockedBoardDesigner_.getLabels();
        int i = 0;
        while (i < labels.length) {
            rectangle = this.calcBlockArea(labels[i].getPoint());
            this.markPainter_.paintLabel(gc, rectangle, labels[i], false);
            ++i;
        }
        if (this.transientProperty_ == null || !this.transientProperty_.sgfId().equals(SgfId.LABEL)) {
            return;
        }
        Label label = Label.parseQuietly(this.nodeView_.getSize(), this.transientProperty_.value().getStrings()[0]);
        rectangle = this.calcBlockArea(label.getPoint());
        this.markPainter_.paintLabel(gc, rectangle, label, true);
    }

    private void paintLine(GC gc) {
        SgfId[] sgfIdArray = new SgfId[]{SgfId.LINE, SgfId.ARROW};
        int n = 0;
        int n2 = sgfIdArray.length;
        while (n < n2) {
            SgfId id = sgfIdArray[n];
            String string = "";
            if (this.transientProperty_ != null && id.equals(this.transientProperty_.sgfId())) {
                string = this.transientProperty_.value().getStrings()[0];
            }
            this.paintLineImpl(gc, id, string);
            ++n;
        }
    }

    private void paintLineImpl(GC gc, SgfId sgfType, String string) {
        SgfLine[] sgfLineArray = this.blockedBoardDesigner_.getLine(sgfType);
        int n = 0;
        int n2 = sgfLineArray.length;
        while (n < n2) {
            SgfLine line = sgfLineArray[n];
            Rectangle start = this.calcBlockArea(line.getStart());
            Rectangle end = this.calcBlockArea(line.getEnd());
            this.markPainter_.paintLine(gc, start, end, sgfType, line.getString().equals(string));
            ++n;
        }
        if (this.transientProperty_ == null || !sgfType.equals(this.transientProperty_.sgfId())) {
            return;
        }
        String[] data = this.transientProperty_.value().getStrings();
        int i = 0;
        while (i < data.length) {
            try {
                SgfLine line = SgfLine.parse(this.nodeView_.getSize(), data[i]);
                Rectangle start = this.calcBlockArea(line.getStart());
                Rectangle end = this.calcBlockArea(line.getEnd());
                this.markPainter_.paintLine(gc, start, end, sgfType, true);
            }
            catch (TypeParseException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private void paintVariation(GC gc) {
        NodeView[] nodeViews = this.nodeView_.getVariations();
        if (nodeViews.length == 0) {
            return;
        }
        HashMap<SgfPoint, ArrayList<String>> variationMap = new HashMap<SgfPoint, ArrayList<String>>(nodeViews.length);
        int i = 0;
        while (i < nodeViews.length) {
            SgfPoint point;
            if ((this.nodeView_.isChildrenStyle() || i != this.nodeView_.getSelectedVariationIndex()) && (point = nodeViews[i].getMove().getPoint()) != null && !SgfPointType.PASS.equals((Object)point.condition())) {
                ArrayList<String> strings = (ArrayList<String>)variationMap.get(point);
                if (strings == null) {
                    strings = new ArrayList<String>(nodeViews.length);
                    variationMap.put(point, strings);
                }
                strings.add(this.variationLabelProvider_.getVariationLabel(i));
            }
            ++i;
        }
        for (Map.Entry entry : variationMap.entrySet()) {
            Rectangle rectangle = this.calcBlockArea((SgfPoint)entry.getKey());
            List list = (List)entry.getValue();
            String[] strings = list.toArray(new String[list.size()]);
            this.markPainter_.paintVariation(gc, rectangle, strings);
        }
    }

    private void redraw() {
        SgfRectangle[] redraws;
        SgfRectangle lastView = this.view_;
        this.view_ = this.blockedBoardDesigner_.calcView();
        if (!lastView.equals(this.view_)) {
            this.refresh();
            return;
        }
        this.calcDrawParameters();
        Set<SgfPoint> redrawBlocks = this.blockedBoardDesigner_.getRedrawBlocks();
        SgfRectangle[] sgfRectangleArray = redraws = SgfRectangle.createRegularRectangles(redrawBlocks.toArray(new SgfPoint[redrawBlocks.size()]));
        int n = 0;
        int n2 = sgfRectangleArray.length;
        while (n < n2) {
            SgfRectangle rectangle = sgfRectangleArray[n];
            this.redrawImpl(rectangle);
            ++n;
        }
    }

    private void redrawImpl(SgfRectangle redraw) {
        if (redraw.width() < 1 || redraw.height() < 1) {
            log_s_.warn("Invalid redraw area, use max area /" + redraw);
            SgfSize size = this.nodeView_.getSize();
            redraw.set(SgfPoint.create(size, size.width(), size.height()), SgfPoint.create(size, 1, 1));
        }
        redraw.union(this.view_);
        Rectangle rectangle = this.calcDrawArea(redraw);
        if (log_s_.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Redraw rectangle is [").append(redraw.getStart().x() - this.view_.getStart().x() + 1).append(",").append(redraw.getStart().y() - this.view_.getStart().y() + 1).append("]-[").append(redraw.getStart().x() - this.view_.getStart().x() + redraw.width()).append(",").append(redraw.getStart().y() - this.view_.getStart().y() + redraw.height()).append("]");
            log_s_.trace(sb);
        }
        this.canvas_.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
    }

    private void refresh() {
        this.canvas_.redraw(0, 0, this.canvas_.getBounds().width, this.canvas_.getBounds().height, true);
    }

    public boolean isUsesDoubleBuffer() {
        return this.usesDoubleBuffer_;
    }

    public void setUsesDoubleBuffer(boolean usesDoubleBuffer) {
        this.usesDoubleBuffer_ = usesDoubleBuffer;
    }

    @Override
    public void paintInTransient(Property property) {
        boolean needsRedraw;
        if (property != null) {
            needsRedraw = !property.equals(this.transientProperty_);
        } else {
            boolean bl = needsRedraw = property != this.transientProperty_;
        }
        if (!needsRedraw) {
            this.transientProperty_ = property;
        } else {
            this.addRedrawPoint(property);
            this.addRedrawPoint(this.transientProperty_);
            this.transientProperty_ = property;
            this.redraw();
        }
    }

    private void addRedrawPoint(Property property) {
        if (property == null) {
            return;
        }
        if (this.addDdRedrawPoint(property)) {
            return;
        }
        switch (property.sgfId().valueType()) {
            case POINT: 
            case CPOINT: 
            case MOVE: {
                SgfPoint[] points = SgfPoint.parse(this.nodeView_.getSize(), property.value().getStrings());
                int i = 0;
                while (i < points.length) {
                    this.blockedBoardDesigner_.addRedrawPoint(points[i]);
                    ++i;
                }
                break;
            }
        }
    }

    private boolean addDdRedrawPoint(Property property) {
        if (!SgfId.DIM_POINTS.equals(property.sgfId())) {
            return false;
        }
        SgfPoint[] points = SgfPoint.parse(this.nodeView_.getSize(), property.value().getStrings());
        if (points.length != 1 || !points[0].condition().equals((Object)SgfPointType.PASS)) {
            int i = 0;
            while (i < points.length) {
                this.blockedBoardDesigner_.addRedrawPoint(points[i]);
                ++i;
            }
            return true;
        }
        int x = this.view_.getStart().x();
        while (x < this.view_.getEnd().x()) {
            int y = this.view_.getStart().y();
            while (y < this.view_.getEnd().y()) {
                this.blockedBoardDesigner_.addRedrawPoint(SgfPoint.create(points[0].size(), x, y));
                ++y;
            }
            ++x;
        }
        return true;
    }

    @Override
    public NodeView getNodeView() {
        return this.nodeView_;
    }

    @Override
    public BlockStatus getBlockStatus(Point canvasPoint) {
        ArgumentChecker.throwIfNull((Object)canvasPoint);
        int x = (int)Math.floor((double)(canvasPoint.x - this.labelSize_.x - this.offsetSize_.x) / (double)this.blockSize_) + this.view_.getStart().x();
        int y = (int)Math.floor((double)(canvasPoint.y - this.labelSize_.y - this.offsetSize_.y) / (double)this.blockSize_) + this.view_.getStart().y();
        SgfSize size = this.nodeView_.getSize();
        if (!size.check(x, y).equals((Object)SgfPointType.IN)) {
            return this.getBlockStatusImpl(null);
        }
        SgfPoint point = SgfPoint.create(size, x, y);
        if (!this.blockedBoardDesigner_.isDrawArea(point)) {
            return this.getBlockStatusImpl(null);
        }
        return this.getBlockStatusImpl(point);
    }

    private BlockStatus getBlockStatusImpl(SgfPoint point) {
        BlockStatus ret = this.blockStatusMap_.get(point);
        if (ret != null) {
            return ret;
        }
        ret = this.createBlockStatus(point);
        this.blockStatusMap_.put(point, ret);
        return ret;
    }

    private BlockStatus createBlockStatus(SgfPoint point) {
        BlockStatus ret = new BlockStatus();
        if (point == null) {
            return ret;
        }
        ret.setPoint(point);
        ret.setPointTypes(this.nodeView_.getPointTypes(point));
        ret.setRectangle(this.calcBlockArea(point));
        return ret;
    }

    @Override
    public void setContext(CurrentContext context) {
        ArgumentChecker.throwIfNull((Object)context);
        this.context_ = context;
        boolean needsRefresh = false;
        needsRefresh |= this.updateBlockLabelProvider();
        needsRefresh |= this.updateCoordinatesLabelProvider();
        needsRefresh |= this.updateVariationLabelProvider();
        if (this.showLastMoveMark_ != this.context_.getBoolean(Context.SHOW_LAST_MOVE_MARK.id())) {
            this.showLastMoveMark_ = !this.showLastMoveMark_;
            needsRefresh = true;
        }
        if (needsRefresh) {
            this.refresh();
        }
    }

    @Override
    public void update(NodeView nodeView) {
        ArgumentChecker.throwIfNull((Object)nodeView);
        this.nodeView_ = nodeView;
        this.blockedBoardDesigner_.update(nodeView);
        this.blockStatusMap_.clear();
        for (SgfPoint invalid : nodeView.getIgoBoard().validate()) {
            BlockStatus blockStatus = this.createBlockStatus(invalid);
            EnumSet<SgfPointType> set = blockStatus.getPointTypes();
            set.add(SgfPointType.OVERLAP);
            blockStatus.setPointTypes(set);
            this.blockStatusMap_.put(invalid, blockStatus);
            this.blockedBoardDesigner_.addRedrawPoint(invalid);
        }
        this.redraw();
    }

    private boolean updateStonePainter() {
        StonePainter newProvider = this.context_.getProvider(StonePainter.class);
        if (!this.stonePainter_.equals(newProvider)) {
            this.blockedBoardDesigner_.removeBlockPainter(this.stonePainter_);
            this.stonePainter_ = newProvider;
            this.blockedBoardDesigner_.addBlockPainter(this.stonePainter_);
            return true;
        }
        return false;
    }

    private boolean updateBlockLabelProvider() {
        BlockLabelProvider newProvider = this.context_.getProvider(BlockLabelProvider.class);
        if (!this.blockLabelProvider_.equals(newProvider)) {
            this.blockedBoardDesigner_.removeBlockPainter(this.blockLabelProvider_);
            this.blockLabelProvider_ = newProvider;
            this.blockedBoardDesigner_.addBlockPainter(this.blockLabelProvider_);
            return true;
        }
        return false;
    }

    private boolean updateCoordinatesLabelProvider() {
        CoordinatesLabelProvider newProvider = this.context_.getProvider(CoordinatesLabelProvider.class);
        this.coordinatesPainter_.setLabelProvider(newProvider);
        return true;
    }

    private boolean updateVariationLabelProvider() {
        VariationLabelProvider newProvider = this.context_.getProvider(VariationLabelProvider.class);
        if (!this.variationLabelProvider_.equals(newProvider)) {
            this.variationLabelProvider_ = newProvider;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Adapter
    implements GameViewer,
    NodeViewer,
    ModelEventNotifier,
    ContextViewer {
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;
        static /* synthetic */ Class class$3;

        Adapter() {
        }

        @Override
        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            IgoGraphicalBoardPanel.this.context_ = gameMediator.getContext();
            IgoGraphicalBoardPanel.this.updateStonePainter();
            IgoGraphicalBoardPanel.this.updateBlockLabelProvider();
            IgoGraphicalBoardPanel.this.updateCoordinatesLabelProvider();
            IgoGraphicalBoardPanel.this.updateVariationLabelProvider();
            IgoGraphicalBoardPanel.this.showLastMoveMark_ = IgoGraphicalBoardPanel.this.context_.getBoolean(Context.SHOW_LAST_MOVE_MARK.id());
            IgoGraphicalBoardPanel.this.refresh();
        }

        @Override
        public void update(NodeView nodeView) {
            IgoGraphicalBoardPanel.this.update(nodeView);
        }

        @Override
        public void setEventBroker(EventBroker broker) {
            ArgumentChecker.throwIfNull((Object)broker);
            if (IgoGraphicalBoardPanel.this.eventBroker_ != null) {
                IgoGraphicalBoardPanel.this.eventBroker_.removeView(IgoGraphicalBoardPanel.this);
                IgoGraphicalBoardPanel.this.eventBroker_.disconnect();
            }
            IgoGraphicalBoardPanel.this.eventBroker_ = broker;
            IgoGraphicalBoardPanel.this.eventBroker_.addView(IgoGraphicalBoardPanel.this);
        }

        @Override
        public void attributeChanged(Set<String> keySet) {
            ArgumentChecker.throwIfNull(keySet);
            boolean needsRefresh = false;
            if (keySet.contains(StonePainter.class.getName())) {
                needsRefresh |= IgoGraphicalBoardPanel.this.updateStonePainter();
            }
            if (keySet.contains(BlockLabelProvider.class.getName())) {
                needsRefresh |= IgoGraphicalBoardPanel.this.updateBlockLabelProvider();
            }
            if (keySet.contains(CoordinatesLabelProvider.class.getName())) {
                needsRefresh |= IgoGraphicalBoardPanel.this.updateCoordinatesLabelProvider();
            }
            if (keySet.contains(VariationLabelProvider.class.getName())) {
                needsRefresh |= IgoGraphicalBoardPanel.this.updateVariationLabelProvider();
            }
            if (keySet.contains(Context.SHOW_LAST_MOVE_MARK.id())) {
                IgoGraphicalBoardPanel.this.showLastMoveMark_ = IgoGraphicalBoardPanel.this.context_.getBoolean(Context.SHOW_LAST_MOVE_MARK.id());
                needsRefresh = true;
            }
            if (keySet.contains(Context.MAX_STONE_SIZE.id())) {
                needsRefresh = true;
            }
            if (needsRefresh) {
                IgoGraphicalBoardPanel.this.refresh();
            }
        }
    }
}

