/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.StateHandler;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;

public abstract class CanvasHookedStateHandler
implements Adaptable,
StateHandler {
    private final IgoBoardPanel igoBoardPanel_;
    private EventBroker eventBroker_;
    private final ListenerForCanvas listenerForCanvas_;
    private final Map<HandlerPhase, EventDelegator> eventDelegatorMap_;
    private EventDelegator eventDelegator_;
    private BlockStatus blockStatus_;

    protected CanvasHookedStateHandler(IgoBoardPanel igoBoardPanel) {
        ArgumentChecker.throwIfNull((Object)igoBoardPanel);
        this.igoBoardPanel_ = igoBoardPanel;
        this.eventBroker_ = EventBroker.NULL_BROKER;
        this.listenerForCanvas_ = new ListenerForCanvas();
        this.eventDelegatorMap_ = new LinkedHashMap<HandlerPhase, EventDelegator>();
        this.eventDelegator_ = null;
        this.blockStatus_ = new BlockStatus();
    }

    protected final IgoBoardPanel getIgoBoardPanel() {
        return this.igoBoardPanel_;
    }

    protected final EventBroker getEventBroker() {
        return this.eventBroker_;
    }

    protected final void registerDelegator(HandlerPhase phase, EventDelegator delegator) {
        ArgumentChecker.throwIfNull((Object)phase, (Object)delegator);
        this.eventDelegatorMap_.put(phase, delegator);
    }

    protected final EventDelegator findDelegator(HandlerPhase phase) {
        ArgumentChecker.throwIfNull((Object)phase);
        return this.eventDelegatorMap_.get(phase);
    }

    protected final EventDelegator getEventDelegator() {
        return this.eventDelegator_;
    }

    protected final void setEventDelegator(HandlerPhase phase) {
        ArgumentChecker.throwIfNull((Object)phase);
        this.eventDelegator_ = this.findDelegator(phase);
    }

    protected final BlockStatus getBlockStatus() {
        return this.blockStatus_;
    }

    protected final MouseEvent getMouseEvent() {
        return this.listenerForCanvas_.lastMouseEvent_;
    }

    public HandlerPhase[] getHandlerPhases() {
        return this.eventDelegatorMap_.keySet().toArray(new HandlerPhase[this.eventDelegatorMap_.size()]);
    }

    public final void setEventBroker(EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)eventBroker);
        this.eventBroker_ = eventBroker;
    }

    public final void connect() {
        Canvas canvas = this.igoBoardPanel_.getCanvas();
        if (canvas == null) {
            throw new IllegalStateException("IgoBoardPanel#createContents() didn't executed.");
        }
        canvas.addMouseListener(this.listenerForCanvas_);
        canvas.addMouseMoveListener(this.listenerForCanvas_);
        canvas.addMouseTrackListener(this.listenerForCanvas_);
        canvas.addKeyListener(this.listenerForCanvas_);
        canvas.addFocusListener(this.listenerForCanvas_);
        canvas.addListener(37, this.listenerForCanvas_);
        this.eventBroker_.addView(this);
    }

    public final void disconnect() {
        Canvas canvas = this.igoBoardPanel_.getCanvas();
        if (canvas == null) {
            throw new IllegalStateException("IgoBoardPanel#createContents() didn't executed.");
        }
        canvas.removeMouseListener(this.listenerForCanvas_);
        canvas.removeMouseMoveListener(this.listenerForCanvas_);
        canvas.removeMouseTrackListener(this.listenerForCanvas_);
        canvas.removeKeyListener(this.listenerForCanvas_);
        canvas.removeListener(37, this.listenerForCanvas_);
        this.eventBroker_.removeView(this);
    }

    private void updateBlockStatus(MouseEvent e) {
        ArgumentChecker.throwIfNull((Object)e);
        this.blockStatus_ = this.getIgoBoardPanel().getBlockStatus(new Point(e.x, e.y));
        this.updateBlockSituation(e);
    }

    protected final void updateBlockSituation(MouseEvent e) {
        if (this.eventDelegator_ == null) {
            throw new IllegalStateException("eventDelegator is null. You need call registerDelegator before.");
        }
        BlockSituation situation = this.eventDelegator_.getBlockSituation(this.getIgoBoardPanel().getNodeView(), this.blockStatus_, e);
        this.getIgoBoardPanel().getCanvas().setCursor(situation.getCursor());
        this.getIgoBoardPanel().paintInTransient(situation.getTransientProperty());
    }

    protected final void mouseButtonUp(MouseEvent e) {
        ArgumentChecker.throwIfNull((Object)e);
        if (this.eventDelegator_ == null) {
            throw new IllegalStateException("eventDelegator is null. You need call registerDelegator before.");
        }
        if (this.eventDelegator_.executeEvent(this.getIgoBoardPanel().getNodeView(), this.blockStatus_, e, this.getEventBroker())) {
            this.updateBlockStatus(e);
        }
    }

    protected void updateKey(int code) {
    }

    protected void mouseWheel(int delta) {
    }

    private class ListenerForCanvas
    extends MouseAdapter
    implements MouseMoveListener,
    MouseTrackListener,
    KeyListener,
    FocusListener,
    Listener {
        private Control lastFocused_ = null;
        private MouseEvent lastMouseEvent_ = null;

        ListenerForCanvas() {
        }

        public void mouseUp(MouseEvent e) {
            this.lastMouseEvent_ = e;
            CanvasHookedStateHandler.this.mouseButtonUp(e);
        }

        public void mouseMove(MouseEvent e) {
            this.lastMouseEvent_ = e;
            CanvasHookedStateHandler.this.updateBlockStatus(e);
        }

        public void keyPressed(KeyEvent e) {
            CanvasHookedStateHandler.this.updateKey(e.stateMask | e.keyCode);
        }

        public void keyReleased(KeyEvent e) {
            CanvasHookedStateHandler.this.updateKey(e.stateMask ^ e.keyCode);
        }

        public void mouseEnter(MouseEvent e) {
            this.lastMouseEvent_ = e;
            Canvas canvas = (Canvas)e.widget;
            if (canvas.getShell() == Display.getCurrent().getActiveShell()) {
                this.lastFocused_ = Display.getCurrent().getFocusControl();
                canvas.forceFocus();
            } else {
                this.lastFocused_ = null;
            }
        }

        public void mouseExit(MouseEvent e) {
            this.lastMouseEvent_ = e;
            if (this.lastFocused_ != null) {
                this.lastFocused_.forceFocus();
                this.lastFocused_ = null;
            }
        }

        public void mouseHover(MouseEvent e) {
            this.lastMouseEvent_ = e;
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            BlockSituation situation = new BlockSituation();
            CanvasHookedStateHandler.this.igoBoardPanel_.getCanvas().setCursor(situation.getCursor());
            CanvasHookedStateHandler.this.igoBoardPanel_.paintInTransient(situation.getTransientProperty());
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 37: {
                    CanvasHookedStateHandler.this.mouseWheel(-event.count);
                }
            }
        }
    }
}

