/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.StateHandler;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.cmd.NodeJumpCommand;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.SelectEventDelegator;

public class GameViewStateHandler
implements StateHandler {
    private final IgoBoardPanel igoBoardPanel_;
    private final MouseListened mouseListened_;
    private EventBroker eventBroker_;
    private BlockStatus blockStatus_;
    private EventDelegator eventDelegator_;

    public GameViewStateHandler(IgoBoardPanel igoBoardPanel) {
        ArgumentChecker.throwIfNull((Object)igoBoardPanel);
        this.igoBoardPanel_ = igoBoardPanel;
        this.mouseListened_ = new MouseListened();
        this.blockStatus_ = new BlockStatus();
        this.eventBroker_ = EventBroker.NULL_BROKER;
        this.eventDelegator_ = new SelectEventDelegator();
    }

    public HandlerPhase[] getHandlerPhases() {
        return new HandlerPhase[]{HandlerPhase.SELECT};
    }

    public void setEventBroker(EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)eventBroker);
        this.eventBroker_ = eventBroker;
    }

    public void connect() {
        Canvas canvas = this.igoBoardPanel_.getCanvas();
        if (canvas == null) {
            throw new IllegalStateException("IgoBoardPanel#createContents() didn't executed.");
        }
        canvas.addMouseListener(this.mouseListened_);
        canvas.addListener(5, this.mouseListened_);
        canvas.addListener(6, this.mouseListened_);
        canvas.addListener(37, this.mouseListened_);
    }

    public void disconnect() {
        Canvas canvas = this.igoBoardPanel_.getCanvas();
        if (canvas == null) {
            throw new IllegalStateException("IgoBoardPanel#createContents() didn't executed.");
        }
        canvas.removeMouseListener(this.mouseListened_);
        canvas.removeListener(5, this.mouseListened_);
        canvas.removeListener(6, this.mouseListened_);
        canvas.removeListener(37, this.mouseListened_);
    }

    private class MouseListened
    extends MouseAdapter
    implements Listener {
        MouseListened() {
        }

        public void mouseUp(MouseEvent e) {
            GameViewStateHandler.this.eventDelegator_.executeEvent(GameViewStateHandler.this.igoBoardPanel_.getNodeView(), GameViewStateHandler.this.blockStatus_, e, GameViewStateHandler.this.eventBroker_);
        }

        public void handleEvent(Event event) {
            MouseEvent mouseEvent_ = new MouseEvent(event);
            switch (event.type) {
                case 37: {
                    int delta = -event.count / 3;
                    if (delta == 0) break;
                    NodeJumpCommand command = new NodeJumpCommand(delta);
                    GameViewStateHandler.this.eventBroker_.executeCommand(command);
                    break;
                }
                case 5: {
                    GameViewStateHandler.this.blockStatus_ = GameViewStateHandler.this.igoBoardPanel_.getBlockStatus(new Point(event.x, event.y));
                    BlockSituation situation = GameViewStateHandler.this.eventDelegator_.getBlockSituation(GameViewStateHandler.this.igoBoardPanel_.getNodeView(), GameViewStateHandler.this.blockStatus_, mouseEvent_);
                    GameViewStateHandler.this.igoBoardPanel_.getCanvas().setCursor(situation.getCursor());
                }
            }
        }
    }
}

