/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import org.eclipse.swt.events.MouseEvent;
import org.unitarou.lang.Objects;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.SelectVariation;
import org.unitarou.yukinoshita.view.cmd.NodeJumpCommand;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;

public class SelectEventDelegator
implements EventDelegator {
    public void resetStatus() {
    }

    public BlockSituation getBlockSituation(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus);
        BlockSituation ret = new BlockSituation();
        return ret;
    }

    public boolean executeEvent(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent, EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)mouseEvent, (Object)eventBroker);
        switch (mouseEvent.button) {
            case 3: {
                eventBroker.executeCommand(new NodeJumpCommand(-1));
                return true;
            }
            case 1: {
                int variationIndex = this.findVariationIndex(nodeView, blockStatus.getPoint());
                if (variationIndex == -1) {
                    eventBroker.executeCommand(new NodeJumpCommand(1));
                    return true;
                }
                eventBroker.executeCommand(new SelectVariation(variationIndex));
                if (nodeView.isChildrenStyle()) {
                    eventBroker.executeCommand(new NodeJumpCommand(1));
                }
                return true;
            }
        }
        return false;
    }

    private int findVariationIndex(NodeView nodeView, SgfPoint sgfPoint) {
        int currentIndex = nodeView.getSelectedVariationIndex();
        if (currentIndex == -1) {
            return -1;
        }
        NodeView[] variations = nodeView.getVariations();
        int i = currentIndex + 1;
        while (i < variations.length) {
            if (this.isMatchMove(sgfPoint, variations[i].getMove().getPoint())) {
                return i;
            }
            ++i;
        }
        i = 0;
        while (i <= currentIndex) {
            if (this.isMatchMove(sgfPoint, variations[i].getMove().getPoint())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean isMatchMove(SgfPoint mousePoint, SgfPoint variationPoint) {
        return Objects.equalsIncludeNull(mousePoint, variationPoint) || mousePoint == null && variationPoint.condition().equals((Object)SgfPointType.PASS);
    }

    public void updateKey(int keyCode) {
    }
}

