/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh.ver1;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.Objects;
import org.unitarou.sgf.PropertyType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.ControllerStatusViewer;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.NodeViewer;
import org.unitarou.yukinoshita.view.cmd.ChangeHandlerPhaseCommand;
import org.unitarou.yukinoshita.view.cmd.NodeJumpCommand;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.CanvasHookedStateHandler;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.LineEventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.MarkupEventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.SelectEventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.SetupEventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.ver1.HandlerPhaseVer1;
import org.unitarou.yukinoshita.view.jface.board.eh.ver1.MoveEventDelegatorVer1;
import org.unitarou.yukinoshita.view.jface.board.eh.ver1.VariationEventDelegatorVer1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorStateHandlerVer1
extends CanvasHookedStateHandler {
    private static final Log log_s_ = LogFactory.getLog(EditorStateHandlerVer1.class);
    private int lastKeyCode_;
    private final Adapter adapter_;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public EditorStateHandlerVer1(IgoBoardPanel igoBoardPanel) {
        super(igoBoardPanel);
        this.registerDelegator(HandlerPhase.SELECT, new SelectEventDelegator());
        this.registerDelegator(HandlerPhaseVer1.MOVE, new MoveEventDelegatorVer1());
        this.registerDelegator(HandlerPhaseVer1.VARIATION, new VariationEventDelegatorVer1());
        this.registerDelegator(HandlerPhase.SETUP, new SetupEventDelegator());
        this.registerDelegator(HandlerPhase.MARKUP, new MarkupEventDelegator());
        this.registerDelegator(HandlerPhase.LINE, new LineEventDelegator());
        this.setEventDelegator(HandlerPhase.SELECT);
        this.lastKeyCode_ = 0;
        this.adapter_ = new Adapter();
    }

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    protected void updateKey(int code) {
        if (this.lastKeyCode_ == code) {
            return;
        }
        EventBroker eventBroker = this.getEventBroker();
        this.lastKeyCode_ = code;
        EventDelegator delegator = this.getEventDelegator();
        if (MarkupEventDelegator.class.equals(delegator.getClass())) {
            switch (code) {
                case 65636: {
                    eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SELECT));
                }
            }
        } else if (LineEventDelegator.class.equals(delegator.getClass())) {
            switch (code) {
                case 65651: {
                    eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SELECT));
                }
            }
        } else if (SetupEventDelegator.class.equals(delegator.getClass())) {
            switch (code) {
                case 65651: {
                    eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SELECT));
                }
            }
        } else {
            switch (code) {
                case 131072: {
                    eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhaseVer1.MOVE));
                    break;
                }
                case 393216: {
                    eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhaseVer1.VARIATION));
                    break;
                }
                case 65651: {
                    eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SETUP));
                    break;
                }
                case 65636: {
                    eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.MARKUP));
                    break;
                }
                case 65644: {
                    eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.LINE));
                    break;
                }
            }
        }
        delegator.updateKey(code);
        BlockSituation situation = delegator.getBlockSituation(this.getIgoBoardPanel().getNodeView(), this.getBlockStatus(), this.getMouseEvent());
        this.getIgoBoardPanel().getCanvas().setCursor(situation.getCursor());
        this.getIgoBoardPanel().paintInTransient(situation.getTransientProperty());
    }

    @Override
    protected void mouseWheel(int delta) {
        if ((delta /= 3) != 0) {
            NodeJumpCommand command = new NodeJumpCommand(delta);
            this.getEventBroker().executeCommand(command);
        }
    }

    private class Adapter
    implements ControllerStatusViewer,
    NodeViewer {
        private HandlerPhase currentHandlerPhase_;

        Adapter() {
        }

        public void setEditMode(boolean isEditMode) {
        }

        public void changeHandlerPhase(HandlerPhase status) {
            ArgumentChecker.throwIfNull((Object)status);
            if (status.equals(this.currentHandlerPhase_)) {
                return;
            }
            if (EditorStateHandlerVer1.this.findDelegator(status) == null) {
                log_s_.warn("Unknown HandlerStatus, use " + HandlerPhase.SELECT + " insted. status=" + status);
                status = HandlerPhase.SELECT;
            }
            EditorStateHandlerVer1.this.setEventDelegator(status);
            EditorStateHandlerVer1.this.getEventDelegator().resetStatus();
            BlockSituation situation = EditorStateHandlerVer1.this.getEventDelegator().getBlockSituation(EditorStateHandlerVer1.this.getIgoBoardPanel().getNodeView(), EditorStateHandlerVer1.this.getBlockStatus(), EditorStateHandlerVer1.this.getMouseEvent());
            EditorStateHandlerVer1.this.getIgoBoardPanel().getCanvas().setCursor(situation.getCursor());
            this.currentHandlerPhase_ = status;
        }

        public void update(NodeView nodeView) {
            ArgumentChecker.throwIfNull((Object)nodeView);
            if (HandlerPhase.SELECT.equals(this.currentHandlerPhase_)) {
                return;
            }
            EventBroker broker = EditorStateHandlerVer1.this.getEventBroker();
            HandlerPhase newPhase = this.currentHandlerPhase_;
            if (HandlerPhase.LINE.equals(this.currentHandlerPhase_)) {
                newPhase = this.currentHandlerPhase_;
            } else if (HandlerPhase.MARKUP.equals(this.currentHandlerPhase_)) {
                newPhase = this.currentHandlerPhase_;
            } else if (nodeView.containsPropertyType(PropertyType.SETUP)) {
                newPhase = HandlerPhase.SETUP;
            } else if (nodeView.containsPropertyType(PropertyType.MOVE) && nodeView.isLast()) {
                newPhase = HandlerPhaseVer1.MOVE;
            } else if (nodeView.containsPropertyType(PropertyType.MOVE) && !nodeView.isLast()) {
                newPhase = HandlerPhaseVer1.VARIATION;
            }
            if (!Objects.equalsIncludeNull(newPhase, this.currentHandlerPhase_)) {
                this.changeHandlerPhase(newPhase);
                broker.executeCommand(new ChangeHandlerPhaseCommand(newPhase));
            }
        }
    }
}

