/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh.ver1;

import java.util.EnumSet;
import org.eclipse.swt.events.MouseEvent;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.AddMove;
import org.unitarou.yukinoshita.model.cmd.RemoveLastNode;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;

class MoveEventDelegatorVer1
implements EventDelegator {
    private SgfColor selectedColor_ = SgfColor.BLACK;

    public void resetStatus() {
        this.selectedColor_ = SgfColor.BLACK;
    }

    public BlockSituation getBlockSituation(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus);
        BlockSituation ret = new BlockSituation();
        EnumSet<SgfPointType> set = blockStatus.getPointTypes();
        if (set.contains((Object)SgfPointType.FORBIDDEN) || !set.contains((Object)SgfPointType.EMPTY) || !nodeView.isLast()) {
            return ret;
        }
        SgfColor nextColor = nodeView.getNextMoveColor();
        if (blockStatus.getPoint() == null) {
            ret.setCursor(CanvasCursor.PASS.get(nextColor));
        } else {
            ret.setCursor(CanvasCursor.MOVE.get(nextColor));
            if (nextColor == null) {
                nextColor = this.selectedColor_;
            }
            ret.setTransientProperty(nextColor.moveType().makeProperty(blockStatus.getPoint()));
        }
        return ret;
    }

    public boolean executeEvent(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent, EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)mouseEvent, (Object)eventBroker);
        if (mouseEvent.button == 3 && nodeView.isLast() && !nodeView.isFirst()) {
            RemoveLastNode command = new RemoveLastNode();
            eventBroker.executeCommand(command);
            return true;
        }
        EnumSet<SgfPointType> set = blockStatus.getPointTypes();
        if (set.contains((Object)SgfPointType.FORBIDDEN) || !set.contains((Object)SgfPointType.EMPTY)) {
            return false;
        }
        SgfColor next = nodeView.getNextMoveColor();
        if (mouseEvent.button == 1 && nodeView.isLast()) {
            SgfPoint point = blockStatus.getPoint();
            if (point == null) {
                point = SgfPoint.createPass(nodeView.getSize());
            }
            if (next == null) {
                next = this.selectedColor_;
                Property pl = new Property();
                pl.setId(SgfId.PLAYER_TO_PLAY.id());
                pl.value().setValue(new Value(next.getString()));
                eventBroker.executeCommand(new UpdateProperty(new Property[0], pl, null));
            }
            AddMove command = new AddMove(next, point);
            eventBroker.executeCommand(command);
            return true;
        }
        return false;
    }

    public void updateKey(int keyCode) {
        switch (keyCode) {
            case 131072: {
                this.selectedColor_ = this.selectedColor_.opposite();
                break;
            }
            case 262144: {
                this.selectedColor_ = this.selectedColor_.opposite();
            }
        }
    }
}

