/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh.ver1;

import org.eclipse.swt.events.MouseEvent;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.AddVariation;
import org.unitarou.yukinoshita.view.cmd.NodeJumpCommand;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;

class VariationEventDelegatorVer1
implements EventDelegator {
    private SgfColor selectedColor_ = SgfColor.BLACK;

    public void resetStatus() {
        this.selectedColor_ = SgfColor.BLACK;
    }

    public BlockSituation getBlockSituation(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus);
        BlockSituation ret = new BlockSituation();
        if (nodeView.isLast()) {
            return ret;
        }
        SgfPoint sgfPoint = blockStatus.getPoint();
        if (sgfPoint == null) {
            sgfPoint = SgfPoint.createPass(nodeView.getSize());
        } else {
            SgfPointType type = nodeView.getPointTypes4Variation(blockStatus.getPoint());
            if (type.equals((Object)SgfPointType.FORBIDDEN)) {
                return ret;
            }
        }
        SgfColor sgfColor = nodeView.getOppositeColor();
        ret.setCursor(CanvasCursor.VARIATION.get(sgfColor));
        if (sgfColor == null) {
            sgfColor = this.selectedColor_;
        }
        Property property = sgfColor.moveType().makeProperty(sgfPoint);
        ret.setTransientProperty(property);
        return ret;
    }

    public boolean executeEvent(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent, EventBroker eventBroker) {
        SgfPointType type;
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)mouseEvent, (Object)eventBroker);
        if (nodeView.isLast() || mouseEvent.button != 1) {
            return false;
        }
        if (blockStatus.getPoint() != null && (type = nodeView.getPointTypes4Variation(blockStatus.getPoint())).equals((Object)SgfPointType.FORBIDDEN)) {
            return false;
        }
        SgfPoint point = blockStatus.getPoint();
        if (point == null) {
            point = SgfPoint.createPass(nodeView.getSize());
        }
        if (nodeView.isChildrenStyle()) {
            SgfColor sgfColor = nodeView.getNextMoveColor();
            if (sgfColor == null) {
                sgfColor = this.selectedColor_;
            }
            eventBroker.executeCommand(new AddVariation(sgfColor, point));
        } else {
            SgfColor sgfColor = nodeView.getMove().getColor();
            if (sgfColor == null) {
                sgfColor = this.selectedColor_;
            }
            eventBroker.executeCommand(new NodeJumpCommand(-1));
            eventBroker.executeCommand(new AddVariation(sgfColor, point));
        }
        eventBroker.executeCommand(new NodeJumpCommand(1));
        return true;
    }

    public void updateKey(int keyCode) {
        switch (keyCode) {
            case 131072: {
                this.selectedColor_ = this.selectedColor_.opposite();
                break;
            }
            case 262144: {
                this.selectedColor_ = this.selectedColor_.opposite();
            }
        }
    }
}

