/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.mp;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.unitarou.swt.AlphaBlender;
import org.unitarou.swt.Rectangles;
import org.unitarou.swt.Swts;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.view.jface.board.mp.Painter;

abstract class AbstractPainter
implements Painter {
    private Point size_ = null;
    private ImageData mark_ = null;
    private ImageData transientMark_ = null;

    AbstractPainter() {
    }

    public void paint(GC gc, Rectangle block, boolean isTransient) {
        ArgumentChecker.throwIfNull((Object)gc, (Object)block);
        Point newSize = Geometry.getSize(block);
        if (!newSize.equals(this.size_)) {
            this.size_ = newSize;
            this.mark_ = this.createImageData();
            this.transientMark_ = AlphaBlender.createTransparent(this.mark_, 128);
        }
        Image img = null;
        Rectangle drawBlock = Rectangles.createScaled(block, 0.95);
        try {
            img = isTransient ? new Image(null, this.transientMark_) : new Image(null, this.mark_);
            gc.drawImage(img, drawBlock.x, drawBlock.y);
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(img);
            throw throwable;
        }
        Swts.disposeQuietly(img);
    }

    protected Point getSize() {
        return this.size_;
    }

    protected abstract ImageData createImageData();
}

