/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.mp;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.unitarou.jface.ColorResource;
import org.unitarou.swt.Rectangles;
import org.unitarou.yukinoshita.view.jface.board.mp.AbstractPainter;

class CirclePainter
extends AbstractPainter {
    private static final ColorResource BODY = new ColorResource(0, 153, 0);
    private static final ColorResource BORDER = new ColorResource(0, 102, 0);
    private static final ColorResource TRANSPARENT = new ColorResource(0, 255, 0);
    private static double sizeRatio_s_ = 0.5;

    public static void setSizeRatio(double newSizeRatio) {
        sizeRatio_s_ = newSizeRatio;
    }

    public static double getSizeRatio() {
        return sizeRatio_s_;
    }

    CirclePainter() {
    }

    protected ImageData createImageData() {
        Image img = null;
        GC imgGc = null;
        try {
            Point size = this.getSize();
            img = new Image(null, size.x, size.y);
            imgGc = new GC(img);
            Rectangle area = Geometry.createRectangle(new Point(0, 0), size);
            area = Rectangles.createScaled(area, sizeRatio_s_);
            imgGc.setBackground(TRANSPARENT.get());
            imgGc.fillRectangle(img.getBounds());
            imgGc.setBackground(BODY.get());
            imgGc.fillOval(area.x, area.y, area.width, area.height);
            imgGc.setLineWidth(1);
            imgGc.setLineStyle(1);
            imgGc.setForeground(BORDER.get());
            imgGc.drawOval(area.x, area.y, area.width - 1, area.height - 1);
            ImageData ret = img.getImageData();
            ret.transparentPixel = ret.getPixel(0, 0);
            ImageData imageData = ret;
            return imageData;
        }
        finally {
            if (imgGc != null) {
                imgGc.dispose();
            }
            if (img != null) {
                img.dispose();
            }
        }
    }
}

