/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.mp;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.unitarou.lang.Classes;
import org.unitarou.swt.Swts;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.view.jface.board.mp.Painter;

class DimPointsPainter
implements Painter {
    private static ColorRegistry colorRegistry_s_;
    public static final String CKEY_DIM;
    private static int alpha_s_;
    private ImageData dimData_ = null;
    private ImageData transientDimData_ = null;
    private Point boxSize_ = new Point(0, 0);
    static /* synthetic */ Class class$0;

    static {
        CKEY_DIM = Classes.uniqueKey(DimPointsPainter.class, "CKEY_DIM");
        alpha_s_ = 128;
        colorRegistry_s_ = JFaceResources.getColorRegistry();
        colorRegistry_s_.put(CKEY_DIM, new RGB(102, 51, 0));
    }

    public static int getAlpha() {
        return alpha_s_;
    }

    public static void setAlpha(int alpha) {
        alpha_s_ = alpha;
    }

    public void paint(GC gc, Rectangle blockArea, boolean isTransient) {
        ArgumentChecker.throwIfNull((Object)gc, (Object)blockArea);
        Point newBoxSize_ = Geometry.getSize(blockArea);
        if (!this.boxSize_.equals(newBoxSize_)) {
            this.boxSize_ = newBoxSize_;
            this.create();
        }
        Image img = null;
        try {
            img = isTransient ? new Image(null, this.transientDimData_) : new Image(null, this.dimData_);
            gc.drawImage(img, blockArea.x, blockArea.y);
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(img);
            throw throwable;
        }
        Swts.disposeQuietly(img);
    }

    private void create() {
        Image dim = null;
        GC dimGc = null;
        try {
            dim = new Image(null, this.boxSize_.x, this.boxSize_.y);
            dimGc = new GC(dim);
            dimGc.setBackground(colorRegistry_s_.get(CKEY_DIM));
            dimGc.fillRectangle(dim.getBounds());
            this.dimData_ = dim.getImageData();
            this.dimData_.alpha = alpha_s_;
            this.transientDimData_ = dim.getImageData();
            this.transientDimData_.alpha = alpha_s_ / 2;
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(dimGc);
            Swts.disposeQuietly(dim);
            throw throwable;
        }
        Swts.disposeQuietly(dimGc);
        Swts.disposeQuietly(dim);
    }
}

