/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.mp;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.unitarou.jface.ColorResource;
import org.unitarou.swt.Rectangles;
import org.unitarou.yukinoshita.view.jface.board.mp.AbstractPainter;

class TrianglePainter
extends AbstractPainter {
    private static final ColorResource BODY = new ColorResource(0, 153, 0);
    private static final ColorResource BORDER = new ColorResource(0, 102, 0);
    private static final ColorResource TRANSPARENT = new ColorResource(0, 255, 0);
    private static double sizeRatio_s_ = 0.6;

    public static void setSizeRatio(double newSizeRatio) {
        sizeRatio_s_ = newSizeRatio;
    }

    public static double getSizeRatio() {
        return sizeRatio_s_;
    }

    protected ImageData createImageData() {
        Image img = null;
        GC imgGc = null;
        try {
            Point size = this.getSize();
            img = new Image(null, size.x, size.y);
            imgGc = new GC(img);
            Rectangle area = Geometry.createRectangle(new Point(0, 0), size);
            area = Rectangles.createScaled(area, sizeRatio_s_);
            imgGc.setBackground(TRANSPARENT.get());
            imgGc.fillRectangle(img.getBounds());
            int length = area.height / 2;
            Point center = new Point(area.x + length, area.y + length);
            Point offset = new Point((int)(Math.cos(0.5235987755982988) * (double)length), (int)(Math.sin(0.5235987755982988) * (double)length));
            Point p1 = new Point(center.x - offset.x, center.y + offset.y);
            Point p2 = new Point(center.x + offset.x, center.y + offset.y);
            int[] pos = new int[]{area.x + length, area.y, p1.x, p1.y, p2.x, p2.y};
            imgGc.setBackground(BODY.get());
            imgGc.fillPolygon(pos);
            imgGc.setLineWidth(1);
            imgGc.setLineStyle(1);
            imgGc.setForeground(BORDER.get());
            imgGc.drawPolygon(pos);
            ImageData ret = img.getImageData();
            ret.transparentPixel = ret.getPixel(0, 0);
            ImageData imageData = ret;
            return imageData;
        }
        finally {
            if (imgGc != null) {
                imgGc.dispose();
            }
            if (img != null) {
                img.dispose();
            }
        }
    }
}

