/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.sp;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.unitarou.jface.ColorResource;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.Stone;
import org.unitarou.swt.AlphaBlender;
import org.unitarou.swt.Rectangles;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainter;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainterParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStonePainter
implements StonePainter {
    protected static final ColorResource COLOR_TRANSPARENT = new ColorResource(0, 255, 255);
    private Point boxSize_ = new Point(0, 0);
    private ImageData blackStone_ = null;
    private ImageData blackTransitStone_ = null;
    private ImageData whiteStone_ = null;
    private ImageData whiteTransitStone_ = null;
    private final Set<SgfPoint> lastBlacks_ = new HashSet<SgfPoint>();
    private final Set<SgfPoint> lastWhites_ = new HashSet<SgfPoint>();
    private final Set<SgfPoint> lastCaptured_ = new HashSet<SgfPoint>();

    @Override
    public final void paintStone(GC gc, Rectangle r, StonePainterParameter parameter) {
        ImageData stone;
        ImageData transit;
        ArgumentChecker.throwIfNull((Object)gc, (Object)r, (Object)parameter);
        r = Rectangles.createScaled(r, 0.95);
        this.checkAndCreateStones(Geometry.getSize(r));
        Image img = null;
        if (SgfColor.WHITE.equals(parameter.getSgfColor())) {
            transit = this.whiteTransitStone_;
            stone = this.whiteStone_;
        } else if (SgfColor.BLACK.equals(parameter.getSgfColor())) {
            transit = this.blackTransitStone_;
            stone = this.blackStone_;
        } else {
            return;
        }
        try {
            img = parameter.isTransient() ? new Image(null, transit) : new Image(null, stone);
            gc.drawImage(img, r.x, r.y);
        }
        finally {
            if (img != null) {
                img.dispose();
            }
        }
        String mn = parameter.getLabel();
        if (mn != null && !"".equals(mn)) {
            this.paintLabel(gc, r, parameter.getLabel(), parameter.getSgfColor(), parameter.isLastMove());
        } else if (parameter.isLastMove()) {
            this.paintLastMoveMark(gc, r, parameter.getSgfColor());
        }
    }

    private void checkAndCreateStones(Point newBoxSize) {
        if (!newBoxSize.equals(this.boxSize_)) {
            this.boxSize_ = newBoxSize;
            this.whiteStone_ = this.createWhiteStone(this.boxSize_);
            this.whiteTransitStone_ = AlphaBlender.createTransparent(this.whiteStone_, 128);
            this.blackStone_ = this.createBlackStone(this.boxSize_);
            this.blackTransitStone_ = AlphaBlender.createTransparent(this.blackStone_, 128);
        }
    }

    protected abstract ImageData createWhiteStone(Point var1);

    protected abstract ImageData createBlackStone(Point var1);

    protected abstract void paintLabel(GC var1, Rectangle var2, String var3, SgfColor var4, boolean var5);

    protected abstract void paintLastMoveMark(GC var1, Rectangle var2, SgfColor var3);

    @Override
    public Set<SgfPoint> getDurablePaintings(NodeView now) {
        ArgumentChecker.throwIfNull((Object)now);
        HashSet<SgfPoint> ret = new HashSet<SgfPoint>();
        SortedSet<SgfPoint> nowBlacks = now.getIgoBoard().position(SgfColor.BLACK);
        SortedSet<SgfPoint> nowWhites = now.getIgoBoard().position(SgfColor.WHITE);
        TreeSet<SgfPoint> nowCaptured = new TreeSet<SgfPoint>();
        for (Stone stone : now.getIgoBoard().getCaptured()) {
            if (!stone.isValid()) continue;
            nowCaptured.add(stone.getPoint());
        }
        HashSet<SgfPoint> tmp = new HashSet<SgfPoint>();
        this.addUpdateSet(ret, this.lastCaptured_, nowCaptured, tmp);
        this.addUpdateSet(ret, this.lastBlacks_, nowBlacks, tmp);
        this.addUpdateSet(ret, this.lastWhites_, nowWhites, tmp);
        return ret;
    }

    private void addUpdateSet(Set<SgfPoint> target, Set<SgfPoint> last, Set<SgfPoint> now, Set<SgfPoint> tmp) {
        tmp.clear();
        tmp.addAll(last);
        tmp.addAll(now);
        last.retainAll(now);
        tmp.removeAll(last);
        last.clear();
        last.addAll(now);
        target.addAll(tmp);
    }

    @Override
    public Set<SgfPoint> getTransientPaintings(NodeView nodeView) {
        HashSet<SgfPoint> ret = new HashSet<SgfPoint>(1);
        if (nodeView.getMove().getPoint() != null) {
            ret.add(nodeView.getMove().getPoint());
        }
        return ret;
    }
}

