/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.jface.FontResource;
import org.unitarou.jface.ImageResource;
import org.unitarou.lang.Runtimes;
import org.unitarou.ml.MessageResource;
import org.unitarou.yukinoshita.Yukinoshita;

public class AboutDialog {
    private static final MessageResource NT_ABOUT_YUKINOSHITA = new MessageResource(AboutDialog.class, "ntAboutYukinoshita");
    private static final MessageResource LB_YUKI_VERSION = new MessageResource(AboutDialog.class, "lbYukiVersion");
    private static final MessageResource LB_YUKI_UPDATE = new MessageResource(AboutDialog.class, "lbYukiUpdate");
    private static final MessageResource LB_SWT_VERSION = new MessageResource(AboutDialog.class, "lbSwtVersion");
    private static final MessageResource LB_AVAILABLE_MEMORY = new MessageResource(AboutDialog.class, "lbAvailableMemory");
    private static final ImageResource BANNER = new ImageResource(AboutDialog.class, "banner.png");
    private static final FontResource FONT_VERSION = new FontResource("Helvetica", 10, 1);
    private final List<Status> statusList_ = new ArrayList<Status>();
    static /* synthetic */ Class class$0;

    public void open() {
        this.setStatus();
        Shell shell = new Shell(Display.getCurrent().getActiveShell(), 67680);
        try {
            this.createShell(shell);
            shell.open();
            while (!shell.isDisposed()) {
                shell.getDisplay().sleep();
                shell.getDisplay().readAndDispatch();
            }
        }
        finally {
            if (shell != null) {
                shell.dispose();
            }
        }
    }

    private void setStatus() {
        this.statusList_.clear();
        this.statusList_.add(new Status(LB_YUKI_VERSION.get(), Yukinoshita.instance().getVersion()));
        this.statusList_.add(new Status(LB_YUKI_UPDATE.get(), Yukinoshita.instance().getLastUpdate()));
        this.statusList_.add(new Status(LB_SWT_VERSION.get(), String.valueOf(SWT.getVersion())));
        this.statusList_.add(new Status(LB_AVAILABLE_MEMORY.get(), String.valueOf(String.valueOf(Runtimes.byteToMegabyte(Runtimes.availableMemory()))) + "MB [" + String.valueOf(Runtimes.byteToMegabyte(Runtime.getRuntime().totalMemory())) + "MB used]"));
    }

    private void createShell(Shell shell) {
        shell.setText(NT_ABOUT_YUKINOSHITA.get());
        Label image = new Label(shell, 0);
        image.setImage(BANNER.get());
        image.setBounds(image.getImage().getBounds());
        image.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                AboutDialog.this.paintLabel(e.gc);
            }
        });
        shell.pack();
        this.setLocation(shell);
    }

    private void setLocation(Shell shell) {
        Point pSize = shell.getParent().getSize();
        Point pLocation = shell.getParent().getLocation();
        Point size = shell.getSize();
        Point location = new Point((pSize.x - size.x) / 2 + pLocation.x, (pSize.y - size.y) / 2 + pLocation.y);
        Rectangle displayBounds = Display.getCurrent().getBounds();
        location.x = Math.min(Math.max(location.x, 0), displayBounds.width - size.x);
        location.y = Math.min(Math.max(location.y, 0), displayBounds.height - size.y);
        shell.setLocation(location);
    }

    private void paintLabel(GC gc) {
        gc.setFont(FONT_VERSION.get());
        Point size = new Point(0, 0);
        for (Status status : this.statusList_) {
            status.labelSize_ = gc.stringExtent(status.label_);
            size.x = Math.max(size.x, ((Status)status).labelSize_.x);
            size.y = Math.max(size.y, ((Status)status).labelSize_.y);
        }
        int y = 80;
        for (Status status : this.statusList_) {
            gc.drawString(status.label_, 5 + size.x - ((Status)status).labelSize_.x, y, true);
            gc.drawString(status.value_, 5 + size.x + 4, y, true);
            y += size.y;
        }
    }

    private static class Status {
        private final String label_;
        private final String value_;
        private Point labelSize_;

        Status(String label, String value) {
            this.label_ = label;
            this.value_ = value;
        }
    }
}

