/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.unitarou.jface.FileFolderListener;
import org.unitarou.jface.FilesTableViewer;
import org.unitarou.jface.FolderListener;
import org.unitarou.jface.FolderTreeViewer;
import org.unitarou.ml.MessageResource;
import org.unitarou.swt.USashForm;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.view.jface.dlg.FilesOutlinePanel;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser;
import org.unitarou.yukinoshita.view.jface.dlg.NamedFileFilter;
import org.unitarou.yukinoshita.view.jface.util.WidgetFactory;

class ExplorerLikeFileChooser
extends Dialog
implements IgoFileChooser {
    private static final Log log_s_ = LogFactory.getLog(ExplorerLikeFileChooser.class);
    private static final MessageResource CLB_FILENAME = new MessageResource(ExplorerLikeFileChooser.class, "clbFilename");
    private static final MessageResource CLB_FILETYPE = new MessageResource(ExplorerLikeFileChooser.class, "clbFiletype");
    private static final MessageResource CLB_OPEN = new MessageResource(ExplorerLikeFileChooser.class, "clbOpen");
    private static final MessageResource CLB_SAVE = new MessageResource(ExplorerLikeFileChooser.class, "clbSave");
    private static final MessageResource LB_CANCEL = new MessageResource(ExplorerLikeFileChooser.class, "lbCancel");
    private static final int OPEN_ID = 1024;
    private static final int SAVE_ID = 1024;
    private static final int CANCEL_ID = 1;
    private static final String DELIMITER = "\"";
    private static File lastRoot_s_ = null;
    private static File lastFolder_s_ = null;
    private final IgoFileChooser.Style style_;
    private final FolderTreeViewer folderTreeViewer_;
    private final FilesTableViewer filesTableViewer_;
    private final FilesOutlinePanel collectionOutlinePanel_;
    private Text txFilename_;
    private Combo coFilter_;
    private NamedFileFilter[] fileFilters_;
    private File[] files_;
    static /* synthetic */ Class class$0;

    public ExplorerLikeFileChooser(Shell parent, IgoFileChooser.Style style) {
        super(parent);
        ArgumentChecker.throwIfNull((Object)parent, (Object)style);
        this.setShellStyle(65584);
        this.style_ = style;
        this.folderTreeViewer_ = new FolderTreeViewer();
        this.folderTreeViewer_.addListener(new FolderTreeListener());
        this.filesTableViewer_ = new FilesTableViewer(67586);
        this.filesTableViewer_.addListener(new FileListListener());
        this.collectionOutlinePanel_ = new FilesOutlinePanel(1);
        this.txFilename_ = null;
        this.coFilter_ = null;
        this.fileFilters_ = new NamedFileFilter[0];
        this.files_ = new File[0];
        this.create();
    }

    protected Control createDialogArea(Composite parent) {
        ArgumentChecker.throwIfNull((Object)parent);
        Composite frame = (Composite)super.createDialogArea(parent);
        USashForm sashForm = WidgetFactory.createUSashForm(frame, 256);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 640;
        gridData.heightHint = 400;
        sashForm.setLayoutData(gridData);
        this.folderTreeViewer_.createContents(sashForm);
        Composite filesFrame = new Composite(sashForm, 0);
        filesFrame.setLayout(new GridLayout(2, false));
        USashForm sash = WidgetFactory.createUSashForm(filesFrame, 256);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        sash.setLayoutData(gridData);
        this.filesTableViewer_.createContents(sash);
        this.collectionOutlinePanel_.createContents(sash);
        sash.setWeights(new int[]{1, -200});
        int[] nArray = new int[2];
        nArray[1] = 100;
        sash.setDragMinimums(nArray);
        this.txFilename_ = this.createFilenameText(filesFrame);
        this.createFiletypeCombo(filesFrame);
        sashForm.setWeights(new int[]{1, 3});
        if (lastRoot_s_ != null) {
            this.folderTreeViewer_.setRoot(lastRoot_s_);
        }
        if (lastFolder_s_ != null) {
            this.folderTreeViewer_.setFolder(lastFolder_s_);
            this.filesTableViewer_.setFolder(lastFolder_s_);
        }
        return frame;
    }

    private Text createFilenameText(Composite parent) {
        assert (parent != null);
        Label label = new Label(parent, 0);
        label.setText(CLB_FILENAME.get());
        label.setLayoutData(new GridData(131072, 128, false, false));
        Text text = new Text(parent, 2048);
        text.setLayoutData(new GridData(4, 128, true, false));
        return text;
    }

    private void createFiletypeCombo(Composite parent) {
        assert (parent != null);
        Label lb3 = new Label(parent, 0);
        lb3.setText(CLB_FILETYPE.get());
        lb3.setLayoutData(new GridData(131072, 128, false, false));
        this.coFilter_ = new Combo(parent, 8);
        this.coFilter_.setLayoutData(new GridData(4, 128, true, false));
        this.coFilter_.addSelectionListener(new CoFilterListener());
        this.updateFilter();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.style_.equals((Object)IgoFileChooser.Style.SAVE_FILE)) {
            this.createButton(parent, 1024, CLB_SAVE.get(), true);
        } else {
            this.createButton(parent, 1024, CLB_OPEN.get(), true);
        }
        this.createButton(parent, 1, LB_CANCEL.get(), false);
    }

    protected void buttonPressed(int buttonId) {
        lastRoot_s_ = this.folderTreeViewer_.getRoot();
        lastFolder_s_ = this.filesTableViewer_.getFolder();
        log_s_.debug("lastRoot_s_:" + lastRoot_s_);
        log_s_.debug("lastFolder_s_:" + lastFolder_s_);
        this.setReturnCode(buttonId);
        if (buttonId == 1) {
            this.close();
            return;
        }
        File folder = this.filesTableViewer_.getFolder();
        ArrayList<File> filenameList = new ArrayList<File>();
        StringTokenizer tokenizer = new StringTokenizer(this.txFilename_.getText(), DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.length() == 0) continue;
            filenameList.add(new File(folder, token));
        }
        this.files_ = filenameList.toArray(new File[filenameList.size()]);
        this.close();
    }

    public boolean chooseFile() {
        return this.open() != 1 && this.files_.length != 0;
    }

    public File getFolder() {
        return this.filesTableViewer_.getFolder();
    }

    public File getFile() {
        return this.files_.length != 0 ? this.files_[0] : null;
    }

    public File[] getFiles() {
        File[] ret = new File[this.files_.length];
        System.arraycopy(this.files_, 0, ret, 0, ret.length);
        return ret;
    }

    public void setFolder(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Argument must be directory: " + file);
        }
        this.folderTreeViewer_.setFolder(file);
        this.filesTableViewer_.setFolder(file);
    }

    public void setFilter(NamedFileFilter[] filters) {
        this.fileFilters_ = new NamedFileFilter[filters.length];
        System.arraycopy(filters, 0, this.fileFilters_, 0, this.fileFilters_.length);
        if (this.coFilter_ != null) {
            this.updateFilter();
        }
    }

    private void updateFilter() {
        this.coFilter_.removeAll();
        NamedFileFilter[] namedFileFilterArray = this.fileFilters_;
        int n = 0;
        int n2 = namedFileFilterArray.length;
        while (n < n2) {
            NamedFileFilter filter = namedFileFilterArray[n];
            this.coFilter_.add(filter.displayName());
            ++n;
        }
        if (this.fileFilters_.length != 0) {
            this.coFilter_.select(0);
            this.filesTableViewer_.setFileFilter(this.fileFilters_[0]);
        }
    }

    public Shell getParent() {
        return null;
    }

    public IgoFileChooser.Style getStyle() {
        return this.style_;
    }

    public String getText() {
        return this.getShell().getText();
    }

    public void setText(String title) {
        ArgumentChecker.throwIfNull((Object)title);
        this.getShell().setText(title);
    }

    private class FolderTreeListener
    implements FolderListener {
        FolderTreeListener() {
        }

        public void folderChanged(File newFolder) {
            ExplorerLikeFileChooser.this.filesTableViewer_.setFolder(newFolder);
        }
    }

    private class FileListListener
    implements FileFolderListener {
        FileListListener() {
        }

        public void filesFocused(File[] focused) {
            ArgumentChecker.throwIfNull((Object)focused);
            ArrayList<File> filtered = new ArrayList<File>(focused.length);
            File[] fileArray = focused;
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                File file = fileArray[n];
                if (file.isFile() && file.canRead()) {
                    filtered.add(file);
                }
                ++n;
            }
            File[] files = filtered.toArray(new File[filtered.size()]);
            ExplorerLikeFileChooser.this.collectionOutlinePanel_.setFiles(files);
            switch (files.length) {
                case 0: {
                    ExplorerLikeFileChooser.this.txFilename_.setText("");
                    break;
                }
                case 1: {
                    ExplorerLikeFileChooser.this.txFilename_.setText(files[0].getName());
                    break;
                }
                default: {
                    StringBuilder builder = new StringBuilder();
                    File[] fileArray2 = files;
                    int n3 = 0;
                    int n4 = fileArray2.length;
                    while (n3 < n4) {
                        File file = fileArray2[n3];
                        builder.append(ExplorerLikeFileChooser.DELIMITER).append(file.getName()).append(ExplorerLikeFileChooser.DELIMITER).append(" ");
                        ++n3;
                    }
                    ExplorerLikeFileChooser.this.txFilename_.setText(builder.toString());
                }
            }
        }

        public void filesDoubleClicked(File clicked) {
        }

        public void folderChanged(File newFolder) {
            ExplorerLikeFileChooser.this.folderTreeViewer_.setFolder(newFolder);
        }
    }

    private class CoFilterListener
    extends SelectionAdapter {
        CoFilterListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            int index = ExplorerLikeFileChooser.this.coFilter_.getSelectionIndex();
            if (index != -1) {
                ExplorerLikeFileChooser.this.filesTableViewer_.setFileFilter(ExplorerLikeFileChooser.this.fileFilters_[index]);
            }
        }
    }
}

