/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.io.Ios;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.FileContextValue;
import org.unitarou.yukinoshita.view.jface.dlg.ExplorerLikeFileChooser;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser;
import org.unitarou.yukinoshita.view.jface.dlg.NamedFileFilter;
import org.unitarou.yukinoshita.view.jface.dlg.SwtFileChooser;

public class IgoFileDialog {
    private static final MessageResource NT_FILE_OPEN = new MessageResource(IgoFileDialog.class, "ntFileOpen");
    private static final MessageResource NT_FILE_OPEN_MULTI = new MessageResource(IgoFileDialog.class, "ntFileOpenMulti");
    private static final MessageResource NT_FILE_SAVE = new MessageResource(IgoFileDialog.class, "ntFileSave");
    private static final MessageResource NT_CONFIRM_OVERWRITE = new MessageResource(IgoFileDialog.class, "ntConfirmOverwrite");
    private static final MessageResource MSG_FILE_IS_EXISTS_OVERWRITE = new MessageResource(IgoFileDialog.class, "msgFileIsExistsOverwrite");
    private static final MessageResource CLB_OVERWRITE = new MessageResource(IgoFileDialog.class, "clbOverwrite");
    private static final MessageResource CLB_SAVE_ANOTHER_NAME = new MessageResource(IgoFileDialog.class, "clbSaveAnotherName");
    private static final MessageResource NT_BAD_ASSIGN = new MessageResource(IgoFileDialog.class, "ntBadAssign");
    private static final MessageResource MSG_ASSIGN_NO_DIRECTORY = new MessageResource(IgoFileDialog.class, "msgAssignNoDirectory");
    private static final MessageResource NT_FILTER_SGF = new MessageResource(IgoFileDialog.class, "ntFilterSgf");
    private static final MessageResource NT_FILTER_ALL = new MessageResource(IgoFileDialog.class, "ntFilterAll");
    private static final String FILE_FILTER_SGF = "*.sgf";
    private static final String FILE_FILTER_ALL = "*.*";
    private static final FileContextValue CURRENT_FOLDER = new FileContextValue(IgoFileDialog.class, "currentFolder", Ios.getCurrentDirectory());
    private IgoFileChooser fileDialog_;
    private final Shell parent_;
    private final IgoFileChooser.Style style_;
    private final CurrentContext context_;
    private File currentDirectory_;
    static /* synthetic */ Class class$0;

    public static File askSaveFile(File folder) {
        File file;
        if (folder == null) {
            folder = Ios.getCurrentDirectory();
        }
        while (true) {
            IgoFileDialog dialog = new IgoFileDialog(Display.getCurrent().getActiveShell(), IgoFileChooser.Style.SAVE_FILE);
            dialog.setFolder(folder);
            if (!dialog.open()) {
                return null;
            }
            file = dialog.getFile();
            if (!Ios.isTemporaryFile(file)) break;
            Yukinoshita.application().openMessageDialog(Application.MessageLevel.WARNING, BasicMessages.NT_FILE_SAVE_FAILURE.get(), Ios.MSG_CANT_WRITE_TO_TMP_FILE.get((Object)file.getAbsolutePath()));
        }
        return file;
    }

    public IgoFileDialog(Shell parent) {
        this(parent, IgoFileChooser.Style.OPEN_FILE);
    }

    public IgoFileDialog(Shell parent, IgoFileChooser.Style style) {
        ArgumentChecker.throwIfNull((Object)parent, (Object)style);
        this.fileDialog_ = null;
        this.parent_ = parent;
        this.style_ = style;
        this.context_ = Yukinoshita.context().getCurrent(null);
        this.currentDirectory_ = this.context_.getFile(CURRENT_FOLDER);
    }

    public boolean open() {
        boolean ret;
        if (this.style_.equals((Object)IgoFileChooser.Style.SAVE_FILE)) {
            ret = this.openAsSave();
        } else {
            this.createFileDialog();
            ret = this.fileDialog_.chooseFile();
            if (ret) {
                this.context_.setFile(CURRENT_FOLDER.id(), this.fileDialog_.getFolder());
            }
        }
        return ret;
    }

    private boolean openAsSave() {
        while (true) {
            this.createFileDialog();
            boolean choose = this.fileDialog_.chooseFile();
            if (!choose) {
                return choose;
            }
            this.context_.setFile(CURRENT_FOLDER.id(), this.fileDialog_.getFolder());
            File file = this.fileDialog_.getFile();
            if (!file.exists()) {
                return true;
            }
            if (file.isDirectory()) {
                MessageDialog.openInformation(this.fileDialog_.getParent(), NT_BAD_ASSIGN.get(), MSG_ASSIGN_NO_DIRECTORY.get((Object)this.fileDialog_.getFile().getAbsolutePath()));
                continue;
            }
            MessageDialog md = new MessageDialog(this.fileDialog_.getParent(), NT_CONFIRM_OVERWRITE.get(), null, MSG_FILE_IS_EXISTS_OVERWRITE.get((Object)this.fileDialog_.getFile().getAbsolutePath()), 3, new String[]{CLB_OVERWRITE.get(), CLB_SAVE_ANOTHER_NAME.get()}, 1);
            if (md.open() == 0) break;
        }
        return true;
    }

    private void createFileDialog() {
        Context.FileDialogStyle style = (Context.FileDialogStyle)((Object)Yukinoshita.context().getAttribute(Context.FILE_DIALOG_STYLE.id(), null));
        switch (style) {
            case OS: {
                this.fileDialog_ = new SwtFileChooser(this.parent_, this.style_);
                break;
            }
            case ORIGINAL: {
                this.fileDialog_ = new ExplorerLikeFileChooser(this.parent_, this.style_);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.fileDialog_.setFolder(this.currentDirectory_);
        NamedFileFilter[] filters = new NamedFileFilter[]{new NamedFileFilter(FILE_FILTER_SGF, NT_FILTER_SGF.get()), new NamedFileFilter(FILE_FILTER_ALL, NT_FILTER_ALL.get())};
        this.fileDialog_.setFilter(filters);
        switch (this.style_) {
            case OPEN_FILE: {
                this.fileDialog_.setText(NT_FILE_OPEN.get());
                break;
            }
            case OPEN_FILES: {
                this.fileDialog_.setText(NT_FILE_OPEN_MULTI.get());
                break;
            }
            case SAVE_FILE: {
                this.fileDialog_.setText(NT_FILE_SAVE.get());
                break;
            }
            default: {
                throw new RuntimeException("Bad style:" + (Object)((Object)this.style_));
            }
        }
    }

    public File getFile() {
        return this.fileDialog_.getFile();
    }

    public File[] getFiles() {
        return this.fileDialog_.getFiles();
    }

    public void setFolder(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        while (!file.isDirectory()) {
            if ((file = file.getParentFile()) != null) continue;
            return;
        }
        this.currentDirectory_ = file;
    }
}

