/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dr;

import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.unitarou.io.Ios;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.StopWatch;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.CollectionViewer;
import org.unitarou.yukinoshita.view.NodeViewer;
import org.unitarou.yukinoshita.view.OutlineViwer;
import org.unitarou.yukinoshita.view.cmd.FocusInDrillEditorCommand;
import org.unitarou.yukinoshita.view.cmd.ShowDrillCommand;
import org.unitarou.yukinoshita.view.jface.SelectablePanel;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileDialog;
import org.unitarou.yukinoshita.view.jface.dr.IfContentProvider;
import org.unitarou.yukinoshita.view.jface.dr.IfElement;
import org.unitarou.yukinoshita.view.jface.dr.IfLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrillEditorPanel
implements SelectablePanel {
    private static final Log log_s_ = LogFactory.getLog(DrillEditorPanel.class);
    private static final MessageResource CLB_EXPAND_ALL = new MessageResource(DrillEditorPanel.class, "clbExpandAll");
    private static final MessageResource CLB_COLLAPSE_ALL = new MessageResource(DrillEditorPanel.class, "clbCollapseAll");
    private static final MessageResource CLB_GROUP_OPTION = new MessageResource(DrillEditorPanel.class, "clbGroupOption");
    private static final MessageResource CLB_ADD = new MessageResource(DrillEditorPanel.class, "clbAdd");
    private static final MessageResource CLB_UP = new MessageResource(DrillEditorPanel.class, "clbUp");
    private static final MessageResource CLB_DOWN = new MessageResource(DrillEditorPanel.class, "clbDown");
    private static final MessageResource CLB_EDIT = new MessageResource(DrillEditorPanel.class, "clbEdit");
    private static final MessageResource CLB_REMOVE = new MessageResource(DrillEditorPanel.class, "clbRemove");
    private final Adapter adapter_ = new Adapter();
    private CollectionEditor collectionEditor_;
    private Property ifProperty_;
    private final SelectionListener cbSelectionListener_;
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private Composite frame_;
    private TreeViewer treeViewer_;
    private final Map<ProblemProperties.Flag, Button> cbPpMap_;
    private final Map<String, Button> btCommandMap_ = new HashMap<String, Button>();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DrillEditorPanel() {
        this.cbPpMap_ = new HashMap<ProblemProperties.Flag, Button>();
        this.cbSelectionListener_ = new SelectionListenerImpl();
    }

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite parent) {
        ArgumentChecker.throwIfNull((Object)parent);
        this.frame_ = new Composite(parent, 0);
        this.frame_.setLayout(new GridLayout(1, true));
        this.createProblemPropertyContents(this.frame_);
        this.createTreeHandlerContents(this.frame_);
        this.treeViewer_ = new TreeViewer(this.frame_, 2560);
        this.treeViewer_.getControl().setLayoutData(new GridData(4, 4, true, true));
        this.treeViewer_.addPostSelectionChangedListener(this.adapter_);
        this.createControllerContents(this.frame_);
        this.treeViewer_.setContentProvider(new IfContentProvider());
        this.treeViewer_.setLabelProvider(new IfLabelProvider());
        return this.frame_;
    }

    private void createProblemPropertyContents(Composite frame) {
        Group group = new Group(frame, 16);
        group.setText(CLB_GROUP_OPTION.get());
        group.setLayout(new FillLayout(512));
        EnumSet<ProblemProperties.Flag> set = EnumSet.allOf(ProblemProperties.Flag.class);
        for (ProblemProperties.Flag flag : set) {
            Button cb = new Button(group, 32);
            cb.setText(flag.getDisplayName());
            this.cbPpMap_.put(flag, cb);
            cb.addSelectionListener(this.cbSelectionListener_);
        }
    }

    private void createTreeHandlerContents(Composite frame) {
        Composite buttonFrame = new Composite(this.frame_, 0);
        buttonFrame.setLayoutData(new GridData(4, 0x1000008, true, false));
        buttonFrame.setLayout(new RowLayout(256));
        Button button = new Button(buttonFrame, 8);
        button.setText(CLB_EXPAND_ALL.get());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DrillEditorPanel.this.treeViewer_.expandAll();
            }
        });
        button = new Button(buttonFrame, 8);
        button.setText(CLB_COLLAPSE_ALL.get());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DrillEditorPanel.this.treeViewer_.collapseAll();
            }
        });
    }

    private void createControllerContents(Composite frame) {
        Composite buttonFrame = new Composite(this.frame_, 0);
        buttonFrame.setLayoutData(new GridData(4, 0x1000008, true, false));
        buttonFrame.setLayout(new RowLayout(256));
        Button button = new Button(buttonFrame, 8);
        button.setText(CLB_ADD.get());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DrillEditorPanel.this.addClick(e);
            }
        });
        this.btCommandMap_.put("add", button);
        new Label(buttonFrame, 0).setText(" ");
        button = new Button(buttonFrame, 8);
        button.setText(CLB_UP.get());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DrillEditorPanel.this.upClick(e);
            }
        });
        this.btCommandMap_.put("up", button);
        button = new Button(buttonFrame, 8);
        button.setText(CLB_DOWN.get());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DrillEditorPanel.this.downClick(e);
            }
        });
        this.btCommandMap_.put("down", button);
        button = new Button(buttonFrame, 8);
        button.setText(CLB_EDIT.get());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DrillEditorPanel.this.editClick(e);
            }
        });
        this.btCommandMap_.put("edit", button);
        new Label(buttonFrame, 0).setText(" ");
        button = new Button(buttonFrame, 8);
        button.setText(CLB_REMOVE.get());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DrillEditorPanel.this.removeClick(e);
            }
        });
        this.btCommandMap_.put("remove", button);
    }

    private void selectItem(SelectionChangedEvent event) {
        int index;
        this.btCommandMap_.get("edit").setEnabled((index = this.findSelectedIndex()) != -1);
        this.btCommandMap_.get("remove").setEnabled(index != -1);
        this.btCommandMap_.get("up").setEnabled(index > 0);
        this.btCommandMap_.get("down").setEnabled(index >= 0 && index < this.ifProperty_.value().size() - 1);
        if (event.getSelection() instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)event.getSelection();
            Object element = structuredSelection.getFirstElement();
            if (element instanceof IfElement) {
                this.eventBroker_.executeCommand(new FocusInDrillEditorCommand(((IfElement)element).getCollection()));
            } else if (element instanceof RootGameTree) {
                this.eventBroker_.executeCommand(new FocusInDrillEditorCommand((RootGameTree)element));
            }
        }
    }

    private void addClick(SelectionEvent e) {
        int index = this.findSelectedIndex();
        if (index == -1) {
            index = 0;
        }
        IgoFileDialog igoFileDialog = new IgoFileDialog(this.frame_.getShell(), IgoFileChooser.Style.OPEN_FILES);
        igoFileDialog.setFolder(this.collectionEditor_.getCollection().getFile());
        igoFileDialog.open();
        File[] filenames = igoFileDialog.getFiles();
        if (filenames == null || filenames.length == 0) {
            return;
        }
        String[] lastData = this.ifProperty_.value().getStrings();
        String[] data = new String[lastData.length + filenames.length];
        System.arraycopy(lastData, 0, data, 0, index);
        File file = this.collectionEditor_.getCollection().getFile();
        int offset = 0;
        File[] fileArray = filenames;
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File filename = fileArray[n];
            String rp = Ios.calcRelativePath(file.getParent(), filename.getAbsolutePath());
            data[index + offset] = FilenameUtils.separatorsToUnix(rp);
            ++offset;
            ++n;
        }
        int i = index + offset;
        while (i < data.length) {
            data[i] = lastData[i - offset];
            ++i;
        }
        this.updateIfProperty(data);
    }

    private void upClick(SelectionEvent e) {
        int index = this.findSelectedIndex();
        if (index < 1) {
            return;
        }
        String[] data = this.ifProperty_.value().getStrings();
        String des = data[index - 1];
        data[index - 1] = data[index];
        data[index] = des;
        this.updateIfProperty(data);
    }

    private void downClick(SelectionEvent e) {
        int index = this.findSelectedIndex();
        String[] data = this.ifProperty_.value().getStrings();
        if (index == -1 || data.length - 1 <= index) {
            return;
        }
        String des = data[index];
        data[index] = data[index + 1];
        data[index + 1] = des;
        this.updateIfProperty(data);
    }

    private void editClick(SelectionEvent e) {
        String rp;
        int index = this.findSelectedIndex();
        if (index == -1) {
            return;
        }
        File file = this.collectionEditor_.getCollection().getFile();
        IgoFileDialog igoFileDialog = new IgoFileDialog(this.frame_.getShell(), IgoFileChooser.Style.OPEN_FILE);
        String[] data = this.ifProperty_.value().getStrings();
        String filename = data[index];
        igoFileDialog.setFolder(new File(file.getParent(), filename));
        if (!igoFileDialog.open()) {
            return;
        }
        String newFilename = igoFileDialog.getFile().getAbsolutePath();
        data[index] = rp = Ios.calcRelativePath(file.getParent(), newFilename);
        this.updateIfProperty(data);
    }

    private void removeClick(SelectionEvent e) {
        int index = this.findSelectedIndex();
        if (index == -1) {
            return;
        }
        String[] lastData = this.ifProperty_.value().getStrings();
        String[] data = new String[lastData.length - 1];
        System.arraycopy(lastData, 0, data, 0, index);
        int i = index;
        while (i < data.length) {
            data[i] = lastData[i + 1];
            ++i;
        }
        Property remove = new Property(SgfId.INPUT_FILES, lastData[index]);
        this.ifProperty_.clear();
        this.ifProperty_.setId(SgfId.INPUT_FILES.id());
        String[] stringArray = data;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String datum = stringArray[n];
            this.ifProperty_.value().addValue(new Value(datum));
            ++n;
        }
        this.eventBroker_.executeCommand(new UpdateProperty(new Property[]{remove}, this.ifProperty_, PropertyType.GAME_INFO));
    }

    private int findSelectedIndex() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer_.getSelection();
        Object obj = selection.getFirstElement();
        if (!(obj instanceof IfElement)) {
            return -1;
        }
        String lastFileName = ((IfElement)obj).getInputFileName();
        String[] filnames = this.ifProperty_.value().getStrings();
        int i = 0;
        while (i < filnames.length) {
            if (filnames[i].equals(lastFileName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void updateIfProperty(String[] data) {
        this.ifProperty_.clear();
        this.ifProperty_.setId(SgfId.INPUT_FILES.id());
        String[] stringArray = data;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String datum = stringArray[n];
            this.ifProperty_.value().addValue(new Value(datum));
            ++n;
        }
        this.eventBroker_.executeCommand(new UpdateProperty(new Property[0], this.ifProperty_, null));
    }

    private void updatePpProperty() {
        int val = 0;
        for (Map.Entry<ProblemProperties.Flag, Button> entry : this.cbPpMap_.entrySet()) {
            if (entry.getValue().getSelection()) {
                val |= entry.getKey().getValue();
                continue;
            }
            val &= ~entry.getKey().getValue();
        }
        Property property = new Property(SgfId.PROBLEM_PROPERTIES, Integer.toString(val));
        this.eventBroker_.executeCommand(new UpdateProperty(new Property[0], property, null));
    }

    @Override
    public Control getControl() {
        return this.frame_;
    }

    @Override
    public void dispose() {
    }

    private void updateTreeViewer() {
        StopWatch stopWatch = new StopWatch();
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer_.getSelection();
        Object obj = selection.getFirstElement();
        String lastValue = "";
        if (obj instanceof IfElement) {
            lastValue = ((IfElement)obj).getInputFileName();
        }
        File file = this.collectionEditor_.getCollection().getFile();
        IfElement select = null;
        String[] values = this.ifProperty_.value().getStrings();
        IfElement[] ifElements = new IfElement[values.length];
        int i = 0;
        while (i < ifElements.length) {
            ifElements[i] = new IfElement(file.getParent(), FilenameUtils.separatorsToSystem(values[i]));
            if (ifElements[i].getInputFileName().equals(lastValue)) {
                select = ifElements[i];
            }
            ++i;
        }
        this.treeViewer_.setInput(ifElements);
        if (select != null) {
            this.treeViewer_.setSelection(new StructuredSelection(select));
        }
        Collection[] collections = new Collection[ifElements.length];
        int i2 = 0;
        while (i2 < collections.length) {
            collections[i2] = ifElements[i2].getCollection();
            ++i2;
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace(String.valueOf(stopWatch.lapSecond()) + " secs for getCollection");
        }
        this.eventBroker_.executeCommand(new ShowDrillCommand(collections));
        if (log_s_.isTraceEnabled()) {
            log_s_.trace(String.valueOf(stopWatch.stopSecond()) + " secs for execute ShowDrillCommand");
        }
    }

    private class SelectionListenerImpl
    extends SelectionAdapter {
        SelectionListenerImpl() {
        }

        public void widgetSelected(SelectionEvent e) {
            DrillEditorPanel.this.updatePpProperty();
        }
    }

    private class Adapter
    implements ModelEventNotifier,
    CollectionViewer,
    NodeViewer,
    OutlineViwer,
    ISelectionChangedListener {
        Adapter() {
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            DrillEditorPanel.this.eventBroker_.removeView(DrillEditorPanel.this);
            DrillEditorPanel.this.eventBroker_ = eventBroker;
            DrillEditorPanel.this.eventBroker_.addView(DrillEditorPanel.this);
        }

        public void update(CollectionEditor collectionEditor) {
            ArgumentChecker.throwIfNull((Object)collectionEditor);
            DrillEditorPanel.this.collectionEditor_ = collectionEditor;
        }

        public void update(NodeView nodeView) {
            ArgumentChecker.throwIfNull((Object)nodeView);
            DrillEditorPanel.this.ifProperty_ = nodeView.getProperty(SgfId.INPUT_FILES);
            if (DrillEditorPanel.this.ifProperty_ == null) {
                DrillEditorPanel.this.ifProperty_ = new Property();
                DrillEditorPanel.this.ifProperty_.setId(SgfId.INPUT_FILES.id());
            }
            DrillEditorPanel.this.updateTreeViewer();
            int val = 0;
            Property property = nodeView.getProperty(SgfId.PROBLEM_PROPERTIES);
            if (property != null) {
                String value = property.value().getString();
                try {
                    val = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            for (Map.Entry entry : DrillEditorPanel.this.cbPpMap_.entrySet()) {
                ((Button)entry.getValue()).setSelection((((ProblemProperties.Flag)((Object)entry.getKey())).getValue() & val) != 0);
            }
        }

        public void show(Collection[] collections) {
        }

        public void setFocus(Collection collection) {
            IfElement[] ifElements;
            IfElement[] ifElementArray = ifElements = (IfElement[])DrillEditorPanel.this.treeViewer_.getInput();
            int n = 0;
            int n2 = ifElementArray.length;
            while (n < n2) {
                IfElement ifElement = ifElementArray[n];
                if (ifElement.getCollection().equals(collection)) {
                    DrillEditorPanel.this.treeViewer_.removePostSelectionChangedListener(DrillEditorPanel.this.adapter_);
                    DrillEditorPanel.this.treeViewer_.setSelection(new StructuredSelection(ifElement));
                    DrillEditorPanel.this.treeViewer_.addPostSelectionChangedListener(DrillEditorPanel.this.adapter_);
                    return;
                }
                ++n;
            }
        }

        public void setFocus(RootGameTree rootGameTree) {
            IfElement[] ifElements;
            IfElement[] ifElementArray = ifElements = (IfElement[])DrillEditorPanel.this.treeViewer_.getInput();
            int n = 0;
            int n2 = ifElementArray.length;
            while (n < n2) {
                IfElement ifElement = ifElementArray[n];
                Collection collection = ifElement.getCollection();
                int i = 0;
                while (i < collection.size()) {
                    if (collection.get(i).equals(rootGameTree)) {
                        DrillEditorPanel.this.treeViewer_.removePostSelectionChangedListener(DrillEditorPanel.this.adapter_);
                        DrillEditorPanel.this.treeViewer_.setSelection(new StructuredSelection(ifElement));
                        DrillEditorPanel.this.treeViewer_.expandToLevel(rootGameTree, -1);
                        DrillEditorPanel.this.treeViewer_.setSelection(new StructuredSelection(rootGameTree));
                        DrillEditorPanel.this.treeViewer_.addPostSelectionChangedListener(DrillEditorPanel.this.adapter_);
                        return;
                    }
                    ++i;
                }
                ++n;
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            DrillEditorPanel.this.selectItem(event);
        }
    }
}

