/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dr;

import java.io.File;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.yukinoshita.view.jface.dr.IfElement;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;

class IfLabelProvider
extends LabelProvider
implements IColorProvider {
    private static final MessageResource LB_NOTFOUND = new MessageResource(IfLabelProvider.class, "lbNotfound");
    private static final MessageResource LB_CANNTO_READ = new MessageResource(IfLabelProvider.class, "lbCannotRead");
    private static final MessageResource LB_ERROR_FRAME = new MessageResource(IfLabelProvider.class, "lbErrorFrame");
    static /* synthetic */ Class class$0;

    IfLabelProvider() {
    }

    public Image getImage(Object element) {
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof IfElement) {
            IfElement topElement = (IfElement)element;
            File file = topElement.getInputFile();
            StringBuilder stringBuilder = new StringBuilder();
            if (!file.exists() || !file.isFile()) {
                stringBuilder.append(LB_ERROR_FRAME.get(LB_NOTFOUND.get(), topElement.getInputFileName()));
            } else if (!file.canRead()) {
                stringBuilder.append(LB_ERROR_FRAME.get(LB_CANNTO_READ.get(), topElement.getInputFileName()));
            } else {
                stringBuilder.append(topElement.getInputFileName());
            }
            return stringBuilder.toString();
        }
        if (element instanceof RootGameTree) {
            RootGameTree rgt = (RootGameTree)element;
            if (rgt.getGameType().equals(GameType.PROBLEM)) {
                return RootGameTreeLabelProvider.CONTEXT.defaultProvider().getLabel((RootGameTree)element);
            }
            return LB_ERROR_FRAME.get(rgt.getGameType().displayName(), RootGameTreeLabelProvider.CONTEXT.defaultProvider().getLabel((RootGameTree)element));
        }
        return super.getText(element);
    }

    public Color getForeground(Object element) {
        if (element instanceof IfElement) {
            IfElement topElement = (IfElement)element;
            File file = topElement.getInputFile();
            return file.exists() && file.isFile() ? Display.getCurrent().getSystemColor(16) : Display.getCurrent().getSystemColor(3);
        }
        if (element instanceof RootGameTree) {
            RootGameTree rgt = (RootGameTree)element;
            if (rgt.getGameType().equals(GameType.PROBLEM)) {
                return Display.getCurrent().getSystemColor(2);
            }
            return Display.getCurrent().getSystemColor(3);
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

