/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gi;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.unitarou.sgf.type.GameType;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.view.CollectionViewer;
import org.unitarou.yukinoshita.view.GameViewer;
import org.unitarou.yukinoshita.view.jface.gi.GameInfoPlainPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameInfoPanel
implements Adaptable,
WidgetContainer {
    public static final String ID_DEFAULT = "Default";
    private Composite frame_ = null;
    private GameInfoPlainPanel currentPanel_ = null;
    private final StackLayout stackLayout_ = new StackLayout();
    private final Adapter adapter_;
    private final Map<String, Map<GameType, GameInfoPlainPanel>> panelsMap_ = new TreeMap<String, Map<GameType, GameInfoPlainPanel>>();

    public GameInfoPanel() {
        this.adapter_ = new Adapter();
    }

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite parent) {
        this.frame_ = new Composite(parent, 0);
        this.frame_.setLayout(this.stackLayout_);
        for (GameInfoPlainPanel gameInfoPanel : this.panelsMap_.get(ID_DEFAULT).values()) {
            gameInfoPanel.createContents(this.frame_);
        }
        this.currentPanel_ = this.panelsMap_.get(ID_DEFAULT).get(GameType.GAME);
        this.stackLayout_.topControl = this.currentPanel_.getControl();
        return this.frame_;
    }

    public Control getControl() {
        return this.frame_;
    }

    @Override
    public void dispose() {
    }

    public boolean add(GameInfoPlainPanel gameInfoPanel) {
        ArgumentChecker.throwIfNull((Object)gameInfoPanel);
        Map<GameType, GameInfoPlainPanel> map = this.panelsMap_.get(gameInfoPanel.getId());
        if (map == null) {
            map = new TreeMap<GameType, GameInfoPlainPanel>();
            this.panelsMap_.put(gameInfoPanel.getId(), map);
        }
        return map.put(gameInfoPanel.getGameType(), gameInfoPanel) == null;
    }

    private GameInfoPlainPanel get(String id, GameType gameType) {
        ArgumentChecker.throwIfNull((Object)id, (Object)gameType);
        Map<GameType, GameInfoPlainPanel> map = this.panelsMap_.get(id);
        if (map != null) {
            GameInfoPlainPanel ret = map.get(gameType);
            if (ret == null) {
                ret = map.get(GameType.GAME);
            }
            return ret;
        }
        return null;
    }

    private GameInfoPlainPanel getDefault(GameType gameType) {
        return this.get(ID_DEFAULT, gameType);
    }

    private class Adapter
    implements ModelEventNotifier,
    CollectionViewer,
    GameViewer {
        Adapter() {
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            eventBroker.addView(GameInfoPanel.this);
            for (GameInfoPlainPanel gameInfoPanel : ((Map)GameInfoPanel.this.panelsMap_.get(GameInfoPanel.ID_DEFAULT)).values()) {
                gameInfoPanel.setEventBroker(eventBroker);
            }
        }

        public void update(CollectionEditor collectionEditor) {
            ArgumentChecker.throwIfNull((Object)collectionEditor);
            this.update(collectionEditor.getActiveGame());
        }

        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            GameInfoPanel.this.currentPanel_ = GameInfoPanel.this.getDefault(gameMediator.getGameType());
            ((GameInfoPanel)GameInfoPanel.this).stackLayout_.topControl = GameInfoPanel.this.currentPanel_.getControl();
            GameInfoPanel.this.currentPanel_.getControl().getParent().layout();
        }
    }
}

