/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gi;

import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.unitarou.lang.Strings;
import org.unitarou.lang.UEnum;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.NodeViewer;
import org.unitarou.yukinoshita.view.jface.gi.GiEmpty;
import org.unitarou.yukinoshita.view.jface.gi.GiEnum;
import org.unitarou.yukinoshita.view.jface.gi.GiFormula;
import org.unitarou.yukinoshita.view.jface.gi.GiLabelFormula;
import org.unitarou.yukinoshita.view.jface.gi.GiTextFormula;

public class GiItem
implements WidgetContainer,
NodeViewer {
    private static final Log logger_s_ = LogFactory.getLog(GiItem.class);
    private static final Messages messages_s_ = Messages.createByPackage(GiItem.class);
    private String labelText_ = "";
    private String expression_ = "";
    private final Map<SgfId, String> emptyMap_ = new TreeMap<SgfId, String>();
    private final Map<SgfId, List<GiEnum>> enumMap_ = new TreeMap<SgfId, List<GiEnum>>();
    private Composite composite_;
    private Label label_;
    private GiFormula[] giFormulae_ = new GiFormula[0];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static String convert(String text, Properties properties) {
        if (text.startsWith("%")) {
            String key = text.substring(1);
            String ret = properties.getProperty(key);
            if (ret == null) {
                logger_s_.warn("Cannot find the key = " + key);
                return "";
            }
            return ret;
        }
        return text;
    }

    public Control createContents(Composite parent) {
        this.setup();
        this.composite_ = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(this.giFormulae_.length + 1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 4;
        this.composite_.setLayout(gridLayout);
        GridData gridData = new GridData(3, 1, false, false);
        this.label_ = new Label(this.composite_, 131072);
        this.label_.setText(this.labelText_);
        this.label_.setLayoutData(gridData);
        GiFormula[] giFormulaArray = this.giFormulae_;
        int n = 0;
        int n2 = giFormulaArray.length;
        while (n < n2) {
            GiFormula giFormula = giFormulaArray[n];
            Control control = giFormula.createContents(this.composite_);
            gridData = new GridData(1, 1, true, true);
            control.setLayoutData(gridData);
            SgfId sgfId = giFormula.getSgfId();
            if (sgfId != null && ValueType.TEXT.equals((Object)sgfId.valueType())) {
                gridLayout.numColumns = 1;
                ((GridData)this.label_.getLayoutData()).horizontalAlignment = 1;
            }
            ++n;
        }
        return this.composite_;
    }

    public void dispose() {
        if (this.composite_ == null) {
            return;
        }
        this.composite_.dispose();
        this.composite_ = null;
    }

    public void setLabel(String label) {
        ArgumentChecker.throwIfNull((Object)label);
        this.labelText_ = label;
    }

    public void setExpression(String expression) {
        ArgumentChecker.throwIfNull((Object)expression);
        this.expression_ = expression;
    }

    public void addEmpty(GiEmpty empty) {
        ArgumentChecker.throwIfNull((Object)empty);
        this.emptyMap_.put(empty.getSgfType(), empty.getValue());
    }

    public void addEnum(GiEnum giEnum) {
        ArgumentChecker.throwIfNull((Object)giEnum);
        List<GiEnum> list = this.enumMap_.get(giEnum.getSgfType());
        if (list == null) {
            list = new ArrayList<GiEnum>();
            this.enumMap_.put(giEnum.getSgfType(), list);
        }
        list.add(giEnum);
    }

    public void setup() {
        ArrayList<GiFormula> giFormulaList = new ArrayList<GiFormula>();
        StringBuilder text = new StringBuilder(this.expression_.length());
        int queue = 65535;
        StringCharacterIterator ip = new StringCharacterIterator(this.expression_);
        int c = ip.first();
        while (c != 65535) {
            if (!Strings.isUppercaseRomanAlphabet((char)c)) {
                if (queue != 65535) {
                    text.append((char)queue);
                    queue = 65535;
                }
                text.append((char)c);
            } else {
                StringBuilder id = new StringBuilder(2);
                if (queue != 65535) {
                    id.append((char)queue);
                }
                id.append((char)c);
                SgfId sgfType = (SgfId)UEnum.find(SgfId.class, (Comparable)((Object)id.toString()));
                if (sgfType == null || !PropertyType.GAME_INFO.equals(sgfType.propertyType())) {
                    if (queue != 65535) {
                        text.append((char)queue);
                    }
                    queue = c;
                } else {
                    List<GiEnum> giEnums;
                    if (text.length() != 0) {
                        giFormulaList.add(new GiLabelFormula(text.toString()));
                        text.delete(0, text.length());
                    }
                    GiTextFormula giTextFormula = new GiTextFormula(sgfType);
                    String value = this.emptyMap_.get(sgfType);
                    if (value != null) {
                        giTextFormula.setEmpty(value);
                    }
                    if ((giEnums = this.enumMap_.get(sgfType)) != null) {
                        for (GiEnum giEnum : giEnums) {
                            String value2 = giEnum.getValue();
                            if (value2.startsWith("%")) {
                                String key = value2.substring(1);
                                value2 = messages_s_.get(key);
                                giEnum.setValue(value2);
                            }
                            giTextFormula.addEnum(giEnum);
                        }
                    }
                    giFormulaList.add(giTextFormula);
                    queue = 65535;
                }
            }
            c = ip.next();
        }
        if (text.length() != 0) {
            giFormulaList.add(new GiLabelFormula(text.toString()));
        }
        int i = 0;
        while (i < this.giFormulae_.length) {
            this.giFormulae_[i].dispose();
            ++i;
        }
        this.giFormulae_ = giFormulaList.toArray(new GiFormula[giFormulaList.size()]);
    }

    public void update(NodeView nodeView) {
        ArgumentChecker.throwIfNull((Object)nodeView);
        int i = 0;
        while (i < this.giFormulae_.length) {
            this.giFormulae_[i].update(nodeView);
            ++i;
        }
    }

    public void setLocalizedLabel(Properties properties) {
        ArgumentChecker.throwIfNull((Object)properties);
        this.labelText_ = GiItem.convert(this.labelText_, properties);
        int i = 0;
        while (i < this.giFormulae_.length) {
            this.giFormulae_[i].setLabel(properties);
            ++i;
        }
        for (SgfId key : this.emptyMap_.keySet()) {
            String value = this.emptyMap_.get(key);
            this.emptyMap_.put(key, GiItem.convert(value, properties));
        }
    }

    public void setWidth(int width) {
        Point lbPt = this.label_.computeSize(-1, -1);
        if (((GridLayout)this.composite_.getLayout()).numColumns == 1) {
            lbPt.x = 0;
        }
        GiFormula[] giFormulaArray = this.giFormulae_;
        int n = 0;
        int n2 = giFormulaArray.length;
        while (n < n2) {
            GiFormula giFormula = giFormulaArray[n];
            Control control = giFormula.getControl();
            GridData gridData = (GridData)control.getLayoutData();
            gridData.widthHint = width - lbPt.x - (gridData.horizontalSpan + gridData.horizontalIndent) * 2;
            ++n;
        }
    }
}

