/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gi;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.unitarou.lang.Strings;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.jface.gi.GiEnum;
import org.unitarou.yukinoshita.view.jface.gi.GiFormula;
import org.unitarou.yukinoshita.view.jface.gi.GiItem;

public class GiTextFormula
implements GiFormula {
    private static final String EMPTY = " ";
    private Label label_;
    private final SgfId sgfType_;
    private String empty_;
    private final List<GiEnum> giEnums_;

    public GiTextFormula(SgfId sgfType) {
        ArgumentChecker.throwIfNull((Object)sgfType);
        this.label_ = null;
        this.sgfType_ = sgfType;
        this.empty_ = EMPTY;
        this.giEnums_ = new ArrayList<GiEnum>();
    }

    public void setEmpty(String empty) {
        ArgumentChecker.throwIfNull((Object)empty);
        this.empty_ = empty;
    }

    public Control createContents(Composite parent) {
        ArgumentChecker.throwIfNull((Object)parent);
        int style = 64;
        this.label_ = new Label(parent, style);
        return this.label_;
    }

    public void dispose() {
        if (this.label_ == null) {
            return;
        }
        this.label_.dispose();
        this.label_ = null;
    }

    public void update(NodeView nodeView) {
        ArgumentChecker.throwIfNull((Object)nodeView);
        if (this.label_ == null) {
            throw new IllegalStateException("Can't call before createControl(Composite) called.");
        }
        Property property = nodeView.findProperty(this.sgfType_);
        if (property == null) {
            this.label_.setText(this.empty_);
            return;
        }
        this.updateImpl(property);
        this.label_.setVisible(true);
    }

    private void updateImpl(Property property) {
        String now;
        String[] texts = property.value().getStrings();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < texts.length) {
            for (GiEnum giEnum : this.giEnums_) {
                texts[i] = giEnum.replace(texts[i]);
            }
            sb.append(texts[i]);
            if (i != 0) {
                sb.append(Strings.LINE_SEPARATOR);
            }
            ++i;
        }
        String old = this.label_.getText();
        if (!old.equals(now = sb.toString())) {
            this.label_.setText(sb.toString());
            this.label_.pack();
        }
    }

    public SgfId getSgfId() {
        return this.sgfType_;
    }

    public void addEnum(GiEnum giEnum) {
        ArgumentChecker.throwIfNull((Object)giEnum);
        if (!giEnum.getSgfType().equals(this.sgfType_)) {
            throw new IllegalArgumentException();
        }
        this.giEnums_.add(giEnum);
    }

    public void setLabel(Properties properties) {
        this.empty_ = GiItem.convert(this.empty_, properties);
    }

    public Control getControl() {
        return this.label_;
    }
}

