/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gm;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.swt.Layouts;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.CollectionViewer;
import org.unitarou.yukinoshita.view.ControllerStatusViewer;
import org.unitarou.yukinoshita.view.GameViewer;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.NodeViewer;
import org.unitarou.yukinoshita.view.cmd.ChangeEditModeCommand;
import org.unitarou.yukinoshita.view.cmd.GameChangeCommand;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameChooserPanel
implements Adaptable,
WidgetContainer {
    private static final MessageResource LB_GAME = new MessageResource(GameChooserPanel.class, "lbGame");
    private static final MessageResource LB_EDIT = new MessageResource(GameChooserPanel.class, "lbEdit");
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private CollectionEditor collectionEditor_ = null;
    private Combo gameCombo_ = null;
    private Label label_ = null;
    private Button checkButton_ = null;
    private final Adapter adapter_ = new Adapter();
    static /* synthetic */ Class class$0;

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite parent) {
        ArgumentChecker.throwIfNull((Object)parent);
        Composite frame = new Composite(parent, 0);
        frame.setLayout(new FillLayout(512));
        Composite chooserComposte = new Composite(frame, 0);
        chooserComposte.setLayout(Layouts.createForm(0, 0, 0));
        this.createLabel(chooserComposte);
        this.gameCombo_ = this.createCombo(chooserComposte, this.label_);
        this.createEditCheckButton(frame);
        return frame;
    }

    private void createLabel(Composite parent) {
        this.label_ = new Label(parent, 0x1000000);
        FormData formData = Layouts.createSpreadFormData(0);
        formData.top = null;
        formData.right = null;
        this.label_.setLayoutData(formData);
    }

    private Combo createCombo(Composite parent, Control left) {
        Combo gameCombo = new Combo(parent, 12);
        gameCombo.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GameChooserPanel.this.fireGameChangeEvent();
            }
        });
        gameCombo.setVisibleItemCount(10);
        FormData formData = Layouts.createSpreadFormData(0);
        formData.left = new FormAttachment(left);
        gameCombo.setLayoutData(formData);
        return gameCombo;
    }

    private void createEditCheckButton(Composite parent) {
        this.checkButton_ = new Button(parent, 0x800020);
        this.checkButton_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GameChooserPanel.this.fireEditModeChageEvent(GameChooserPanel.this.checkButton_.getSelection());
            }
        });
    }

    @Override
    public void dispose() {
        this.eventBroker_ = EventBroker.NULL_BROKER;
        this.gameCombo_.dispose();
        this.checkButton_.dispose();
    }

    public void setEventBroker(EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)eventBroker);
        this.eventBroker_ = eventBroker;
        this.eventBroker_.addView(this);
    }

    private void fireGameChangeEvent() {
        GameChangeCommand command = new GameChangeCommand(this.gameCombo_.getSelectionIndex());
        this.eventBroker_.executeCommand(command);
    }

    private void fireEditModeChageEvent(boolean selected) {
        this.eventBroker_.executeCommand(new ChangeEditModeCommand(selected));
    }

    private class Adapter
    implements ModelEventNotifier,
    ControllerStatusViewer,
    CollectionViewer,
    GameViewer,
    NodeViewer {
        static /* synthetic */ Class class$0;

        Adapter() {
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            GameChooserPanel.this.eventBroker_ = eventBroker;
            GameChooserPanel.this.eventBroker_.addView(GameChooserPanel.this);
        }

        public void setEditMode(boolean isEditMode) {
            GameChooserPanel.this.checkButton_.setSelection(isEditMode);
        }

        public void changeHandlerPhase(HandlerPhase phase) {
        }

        public void update(CollectionEditor collectionEditor) {
            ArgumentChecker.throwIfNull((Object)collectionEditor);
            GameChooserPanel.this.collectionEditor_ = collectionEditor;
            RootGameTreeLabelProvider provider = this.getLabelProvider();
            Collection collection = GameChooserPanel.this.collectionEditor_.getCollection();
            String[] items = new String[collection.size()];
            if (collection.get(0).getGameType().equals(GameType.DRILL)) {
                int i = 0;
                while (i < items.length) {
                    items[i] = provider.getLabel(collection.get(0));
                    ++i;
                }
                GameChooserPanel.this.gameCombo_.setEnabled(false);
            } else {
                int i = 0;
                while (i < items.length) {
                    items[i] = this.makeRgtLabel(provider, i, collection.get(i));
                    ++i;
                }
                GameChooserPanel.this.gameCombo_.setEnabled(true);
            }
            GameChooserPanel.this.gameCombo_.setItems(items);
            if (items.length > 0) {
                GameChooserPanel.this.gameCombo_.select(GameChooserPanel.this.collectionEditor_.getActiveGameIndex());
            }
        }

        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            String name = gameMediator.getGameType().displayName();
            GameChooserPanel.this.checkButton_.setText(LB_EDIT.get((Object)name));
            GameChooserPanel.this.label_.setText(LB_GAME.get((Object)name));
            GameChooserPanel.this.label_.getParent().layout(true, true);
        }

        public void update(NodeView nodeView) {
            ArgumentChecker.throwIfNull((Object)nodeView);
            RootGameTreeLabelProvider provider = this.getLabelProvider();
            Collection collection = GameChooserPanel.this.collectionEditor_.getCollection();
            String[] items = new String[collection.size()];
            if (collection.get(0).getGameType().equals(GameType.DRILL)) {
                if (GameChooserPanel.this.collectionEditor_.getActiveGameIndex() != 0) {
                    return;
                }
                int i = 0;
                while (i < items.length) {
                    items[i] = provider.getLabel(collection.get(0));
                    ++i;
                }
                GameChooserPanel.this.gameCombo_.setEnabled(false);
            } else {
                GameChooserPanel.this.gameCombo_.setItem(GameChooserPanel.this.collectionEditor_.getActiveGameIndex(), this.makeRgtLabel(provider, GameChooserPanel.this.collectionEditor_.getActiveGameIndex(), GameChooserPanel.this.collectionEditor_.getActiveGame().getRootGameTree()));
            }
            if (items.length > 0) {
                GameChooserPanel.this.gameCombo_.select(GameChooserPanel.this.collectionEditor_.getActiveGameIndex());
            }
        }

        private String makeRgtLabel(RootGameTreeLabelProvider provider, int index, RootGameTree rgt) {
            StringBuilder sb = new StringBuilder();
            sb.append(index + 1).append(':');
            sb.append(provider.getLabel(rgt));
            return sb.toString();
        }

        private RootGameTreeLabelProvider getLabelProvider() {
            Collection collection = GameChooserPanel.this.collectionEditor_.getCollection();
            return Yukinoshita.context().getProvider(RootGameTreeLabelProvider.class, collection);
        }
    }
}

