/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ns;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.unitarou.jface.ImageResource;
import org.unitarou.lang.NullArgumentException;
import org.unitarou.swt.Swts;
import org.unitarou.yukinoshita.view.jface.ns.VariationSelectorPanel;

public class MoveButton {
    private final VariationSelectorPanel variationSelectorPanel_;
    private Button button_;
    private final int index_;

    public MoveButton(VariationSelectorPanel variationSelectorPanel, int index) {
        if (variationSelectorPanel == null) {
            throw new NullArgumentException("Argument(variationSelectorPanel) must not be null.");
        }
        this.index_ = index;
        this.variationSelectorPanel_ = variationSelectorPanel;
        this.button_ = null;
    }

    public void createControl(Composite parent, int style) {
        this.button_ = new Button(parent, style);
        this.button_.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MoveButton.this.disposeButtonImage();
            }
        });
        this.button_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!((Button)e.widget).getSelection()) {
                    return;
                }
                MoveButton.this.variationSelectorPanel_.variationChanged(MoveButton.this);
            }
        });
    }

    public void set(String prefix, ImageResource imageResource, String postfix) {
        Image image = imageResource.get();
        GC gc = new GC(this.button_);
        try {
            Painter p = new Painter();
            p.set(gc, prefix, image, postfix);
            this.disposeButtonImage();
            this.button_.setImage(new Image((Device)this.button_.getDisplay(), ((Painter)p).totalSp_.x, ((Painter)p).totalSp_.y));
            this.paint(p);
        }
        finally {
            gc.dispose();
        }
    }

    private void paint(Painter p) {
        GC gc = new GC(this.button_.getImage());
        try {
            gc.setFont(this.button_.getFont());
            gc.setBackground(this.button_.getBackground());
            gc.setForeground(this.button_.getForeground());
            p.paint(gc);
        }
        finally {
            gc.dispose();
        }
    }

    private void disposeButtonImage() {
        if (this.button_ == null) {
            return;
        }
        Image image = this.button_.getImage();
        if (image != null && !image.isDisposed()) {
            image.dispose();
        }
        this.button_.setImage(null);
    }

    public void setVisible(boolean visible) {
        this.button_.setVisible(visible);
    }

    public void setSelection(boolean selected) {
        this.button_.setSelection(selected);
    }

    public int getIndex() {
        return this.index_;
    }

    private static class Painter {
        private String prefix_;
        private Image image_;
        private String postfix_;
        private Point prefixSp_;
        private Point imageSp_;
        private Point postfixSp_;
        private Point totalSp_;

        Painter() {
        }

        private void set(GC gc, String prefix, Image image, String postfix) {
            this.prefix_ = prefix;
            this.image_ = image;
            this.postfix_ = postfix;
            this.prefixSp_ = gc.textExtent(this.prefix_, 8);
            this.imageSp_ = Geometry.getSize(this.image_.getBounds());
            this.postfixSp_ = gc.textExtent(this.postfix_, 8);
            this.totalSp_ = Swts.add(this.prefixSp_, this.imageSp_, 256);
            this.totalSp_ = Swts.add(this.totalSp_, this.postfixSp_, 256);
        }

        private void paint(GC gc) {
            gc.fillRectangle(0, 0, this.totalSp_.x, this.totalSp_.y);
            gc.drawText(this.prefix_, 0, (this.totalSp_.y - this.prefixSp_.y) / 2, 8);
            gc.drawImage(this.image_, this.prefixSp_.x, (this.totalSp_.y - this.imageSp_.y) / 2);
            gc.drawText(this.postfix_, this.prefixSp_.x + this.imageSp_.x, (this.totalSp_.y - this.postfixSp_.y) / 2, 8);
        }
    }
}

