/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ns;

import java.util.EnumSet;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.unitarou.jface.ColorResource;
import org.unitarou.jface.ImageResource;
import org.unitarou.lang.Strings;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.swt.Swts;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.jface.resource.NodeImage;
import org.unitarou.yukinoshita.view.provider.nlp.NodeViewLabelProvider;

class NodeListLabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private static final ImageRegistry imageRegistry_s_ = JFaceResources.getImageRegistry();
    private static final ColorResource BACKGROUND = new ColorResource(25);
    private static final ColorResource MAIN_FONT = new ColorResource(24);
    private static final ColorResource[] VARIATIONS;
    private CoordinatesLabelProvider coordinatesLabelProvider_ = Yukinoshita.context().getProvider(CoordinatesLabelProvider.class, null);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        int[] rs = new int[]{238, 221};
        int[] gs = new int[]{238, 221};
        int[] bs = new int[]{238, 221};
        VARIATIONS = new ColorResource[rs.length * gs.length * bs.length - rs.length];
        int index = 0;
        int r = 0;
        while (r < rs.length) {
            int b = 0;
            while (b < bs.length) {
                int g = 0;
                while (g < gs.length) {
                    if (r != b || b != g) {
                        NodeListLabelProvider.VARIATIONS[index] = new ColorResource(rs[r], gs[g], bs[b]);
                        ++index;
                    }
                    ++g;
                }
                ++b;
            }
            ++r;
        }
    }

    public void dispose() {
    }

    public Image getColumnImage(Object obj, int column) {
        Image image;
        if (!(obj instanceof NodeView) || column != 1) {
            return null;
        }
        NodeView nodeView = (NodeView)obj;
        EnumSet<NodeStatus> statusSet = EnumSet.noneOf(NodeStatus.class);
        if (nodeView.getProperty(SgfId.WHITE) != null) {
            statusSet.add(NodeStatus.WHITE_MOVE);
        } else if (nodeView.getProperty(SgfId.BLACK) != null) {
            statusSet.add(NodeStatus.BLACK_MOVE);
        }
        if (nodeView.variationSize() != 0) {
            statusSet.add(NodeStatus.HAS_VARIATION);
        }
        if (!nodeView.getInvalid().isEmpty()) {
            statusSet.add(NodeStatus.WARNING);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().toString()).append('/');
        for (NodeStatus status : statusSet) {
            builder.append(status.name()).append(':');
        }
        String key = builder.toString();
        Image image2 = imageRegistry_s_.get(key);
        if (image2 != null) {
            return image2;
        }
        GC gc = null;
        try {
            image2 = new Image(null, 16, 16);
            gc = new GC(image2);
            for (NodeStatus status : statusSet) {
                gc.drawImage(status.imageResource_.get(), 0, 0);
            }
            imageRegistry_s_.put(key, image2);
            image = image2;
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(gc);
            throw throwable;
        }
        Swts.disposeQuietly(gc);
        return image;
    }

    public String getColumnText(Object obj, int column) {
        if (!(obj instanceof NodeView)) {
            return null;
        }
        NodeView nodeView = (NodeView)obj;
        switch (column) {
            case 1: {
                return this.getMoveNumber(nodeView);
            }
            case 2: {
                return this.getMoveText(nodeView);
            }
            case 3: {
                return this.getTreeText(nodeView);
            }
        }
        return "";
    }

    private String getMoveNumber(NodeView nodeView) {
        Double tl;
        StringBuilder sb = new StringBuilder();
        Integer number = nodeView.getMove().getNumber();
        if (number != null) {
            sb.append(number);
        }
        if ((tl = nodeView.getMove().getTimeLapsed()) != null) {
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append('[').append(Strings.formatDuration(tl.intValue())).append(']');
        }
        return sb.toString();
    }

    private String getMoveText(NodeView nodeView) {
        try {
            Property property = nodeView.getProperty(SgfId.WHITE);
            if (property != null) {
                SgfPoint sgfPoint = SgfPoint.parseMove(nodeView.getSize(), property.value().getString());
                return this.coordinatesLabelProvider_.getMoveLabel(sgfPoint);
            }
            property = nodeView.getProperty(SgfId.BLACK);
            if (property != null) {
                SgfPoint sgfPoint = SgfPoint.parseMove(nodeView.getSize(), property.value().getString());
                return this.coordinatesLabelProvider_.getMoveLabel(sgfPoint);
            }
        }
        catch (TypeParseException e) {
            e.printStackTrace();
        }
        return "";
    }

    private String getTreeText(NodeView nodeView) {
        return NodeViewLabelProvider.CONTEXT.defaultProvider().getLabel(nodeView);
    }

    public CoordinatesLabelProvider getProvider() {
        return this.coordinatesLabelProvider_;
    }

    public Color getForeground(Object element, int columnIndex) {
        return MAIN_FONT.get();
    }

    public Color getBackground(Object element, int columnIndex) {
        if (columnIndex == 0 || !(element instanceof NodeView)) {
            return BACKGROUND.get();
        }
        NodeView nodeView = (NodeView)element;
        int variation = nodeView.getVariationHash();
        if (-1 == variation) {
            return BACKGROUND.get();
        }
        return VARIATIONS[variation % VARIATIONS.length].get();
    }

    public void addListener(ILabelProviderListener arg0) {
    }

    public void removeListener(ILabelProviderListener arg0) {
    }

    public boolean isLabelProperty(Object arg0, String arg1) {
        return false;
    }

    public void setProvider(CoordinatesLabelProvider provider) {
        ArgumentChecker.throwIfNull((Object)provider);
        this.coordinatesLabelProvider_ = provider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NodeStatus {
        WHITE_MOVE(NodeImage.WHITE),
        BLACK_MOVE(NodeImage.BLACK),
        HAS_VARIATION(NodeImage.VNONE),
        WARNING(NodeImage.WARNING);

        private final ImageResource imageResource_;

        NodeStatus(ImageResource imageResource) {
            this.imageResource_ = imageResource;
        }
    }
}

