/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ns;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.unitarou.jface.ImageResource;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.SelectVariation;
import org.unitarou.yukinoshita.view.ContextViewer;
import org.unitarou.yukinoshita.view.GameViewer;
import org.unitarou.yukinoshita.view.NodeViewer;
import org.unitarou.yukinoshita.view.jface.ns.MoveButton;
import org.unitarou.yukinoshita.view.jface.resource.NodeImage;
import org.unitarou.yukinoshita.view.provider.vlp.VariationLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariationSelectorPanel
implements Adaptable,
WidgetContainer {
    private static final MessageResource LB_VARIATION = new MessageResource(VariationSelectorPanel.class, "lbVariation");
    private static final MessageResource LB_REGULAR_PATH = new MessageResource(VariationSelectorPanel.class, "lbRegularPath");
    private static final MessageResource LB_ANOTHER_PATH = new MessageResource(VariationSelectorPanel.class, "lbAnotherPath");
    private EventBroker eventHandler_ = EventBroker.NULL_BROKER;
    private Group selector_;
    private final ArrayList<MoveButton> variationButtons_ = new ArrayList();
    private CoordinatesLabelProvider coordinatesLabelProvider_ = Yukinoshita.context().getProvider(CoordinatesLabelProvider.class, null);
    private VariationLabelProvider variationLabelProvider_ = VariationLabelProvider.CONTEXT.defaultProvider();
    private final Adapter adapter_ = new Adapter();
    private NodeView[] variations_ = new NodeView[0];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    @Override
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite parent) {
        this.selector_ = new Group(parent, 16);
        this.selector_.setLayout(new RowLayout(512));
        this.selector_.setText(LB_VARIATION.get());
        MouseOnGroupListener listener = new MouseOnGroupListener();
        this.selector_.addListener(37, listener);
        this.selector_.addMouseTrackListener(listener);
        return this.selector_;
    }

    @Override
    public void dispose() {
    }

    private void updateButtonArray(int newVariations) {
        int current;
        int i = current = this.variationButtons_.size();
        while (i < newVariations) {
            MoveButton variation = new MoveButton(this, i);
            variation.createControl(this.selector_, 0x800010);
            this.variationButtons_.add(variation);
            ++i;
        }
        i = newVariations;
        while (i < this.variationButtons_.size()) {
            this.variationButtons_.get(i).setVisible(false);
            ++i;
        }
    }

    private void setupMoveButton(int index, NodeView sibling, boolean isSelected) {
        MoveButton button = this.variationButtons_.get(index);
        button.setSelection(isSelected);
        String prefix = this.makeMoveButtonPrefix();
        String postfix = this.makeMoveButtonPostfix(index, sibling);
        ImageResource imageResource = this.makeMoveButtonImageResource(sibling);
        button.set(prefix, imageResource, postfix);
        button.setVisible(true);
    }

    private String makeMoveButtonPrefix() {
        String prefix = "";
        return prefix;
    }

    private String makeMoveButtonPostfix(int index, NodeView sibling) {
        StringBuilder ret = new StringBuilder();
        String moveLabel = "";
        try {
            SgfPoint sgfPoint;
            Property property = sibling.getProperty(SgfId.BLACK);
            if (property != null) {
                sgfPoint = SgfPoint.parseMove(sibling.getSize(), property.value().getString());
                moveLabel = this.coordinatesLabelProvider_.getMoveLabel(sgfPoint);
            }
            if ((property = sibling.getProperty(SgfId.WHITE)) != null) {
                sgfPoint = SgfPoint.parseMove(sibling.getSize(), property.value().getString());
                moveLabel = this.coordinatesLabelProvider_.getMoveLabel(sgfPoint);
            }
            ret.append(moveLabel);
            ret.append(' ');
            ret.append(index == 0 ? LB_REGULAR_PATH.get() : LB_ANOTHER_PATH.get());
            ret.append(this.variationLabelProvider_.getVariationLabel(index));
        }
        catch (TypeParseException e) {
            e.printStackTrace();
        }
        return ret.toString();
    }

    private ImageResource makeMoveButtonImageResource(NodeView sibling) {
        ImageResource imageResource = NodeImage.VNONE;
        Property property = sibling.getProperty(SgfId.BLACK);
        if (property != null) {
            imageResource = NodeImage.BLACK;
        }
        if ((property = sibling.getProperty(SgfId.WHITE)) != null) {
            imageResource = NodeImage.WHITE;
        }
        return imageResource;
    }

    void variationChanged(MoveButton button) {
        this.eventHandler_.executeCommand(new SelectVariation(button.getIndex()));
    }

    private class MouseOnGroupListener
    extends MouseTrackAdapter
    implements Listener {
        private int index_ = 0;

        MouseOnGroupListener() {
        }

        public void handleEvent(Event event) {
            if (VariationSelectorPanel.this.variations_.length == 0) {
                return;
            }
            if (event.count > 0) {
                --this.index_;
                if (this.index_ < 0) {
                    this.index_ = 0;
                }
            } else if (event.count < 0) {
                ++this.index_;
                if (VariationSelectorPanel.this.variations_.length <= this.index_) {
                    this.index_ = VariationSelectorPanel.this.variations_.length - 1;
                }
            }
            VariationSelectorPanel.this.eventHandler_.executeCommand(new SelectVariation(this.index_));
        }

        public void mouseEnter(MouseEvent e) {
            VariationSelectorPanel.this.selector_.forceFocus();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Adapter
    implements GameViewer,
    ModelEventNotifier,
    NodeViewer,
    ContextViewer {
        private CurrentContext context_ = CurrentContext.nullContext;
        private int variationIndex_;
        static /* synthetic */ Class class$0;

        Adapter() {
        }

        @Override
        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            this.context_ = gameMediator.getContext();
        }

        @Override
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            VariationSelectorPanel.this.eventHandler_ = eventBroker;
            eventBroker.addView(VariationSelectorPanel.this);
        }

        @Override
        public void update(NodeView nodeView) {
            ArgumentChecker.throwIfNull((Object)nodeView);
            VariationSelectorPanel.this.variations_ = nodeView.getVariations();
            this.variationIndex_ = nodeView.getSelectedVariationIndex();
            this.update();
            VariationSelectorPanel.this.selector_.layout();
        }

        private void update() {
            VariationSelectorPanel.this.updateButtonArray(VariationSelectorPanel.this.variations_.length);
            int i = 0;
            while (i < VariationSelectorPanel.this.variations_.length) {
                VariationSelectorPanel.this.setupMoveButton(i, VariationSelectorPanel.this.variations_[i], i == this.variationIndex_);
                ++i;
            }
        }

        @Override
        public void attributeChanged(Set<String> keySet) {
            CoordinatesLabelProvider newProvider;
            ArgumentChecker.throwIfNull(keySet);
            boolean needsRefresh = false;
            if (keySet.contains(CoordinatesLabelProvider.class.getName()) && !(newProvider = this.context_.getProvider(CoordinatesLabelProvider.class)).equals(VariationSelectorPanel.this.coordinatesLabelProvider_)) {
                VariationSelectorPanel.this.coordinatesLabelProvider_ = newProvider;
                needsRefresh = true;
            }
            if (needsRefresh) {
                this.update();
                VariationSelectorPanel.this.selector_.layout();
            }
        }
    }
}

