/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.provider.rgtlp;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;

public class DefaultRgtLabelProvider
implements RootGameTreeLabelProvider {
    private static final MessageResource LB_DISPLAY_NAME = new MessageResource(DefaultRgtLabelProvider.class, "lbDisplayName");
    private static final MessageResource LB_VERSUS = new MessageResource(DefaultRgtLabelProvider.class, "lbVersus");
    private static final MessageResource LB_UNKNOWN = new MessageResource(DefaultRgtLabelProvider.class, "lbUnknown");
    static /* synthetic */ Class class$0;

    public String getLabel(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        Sequence sequence = rootGameTree.getSequence();
        String datum = this.composeGameName(sequence);
        if (!datum.equals("")) {
            return datum;
        }
        datum = this.composeEventInfo(sequence);
        if (!datum.equals("")) {
            return datum;
        }
        return this.composePlayerInfo(sequence);
    }

    private String composeGameName(Sequence sequence) {
        return BasicFinder.findDatum(sequence, SgfId.GAME_NAME);
    }

    private String composeEventInfo(Sequence sequence) {
        Node node = BasicFinder.findNode(sequence, SgfId.EVENT);
        if (node != null) {
            return this.compose(node, SgfId.EVENT, SgfId.ROUND);
        }
        return "";
    }

    private String composePlayerInfo(Sequence sequence) {
        Node node = BasicFinder.findNode(sequence, SgfId.PLAYER_WHITE);
        Node node2 = node = node != null ? node : BasicFinder.findNode(sequence, SgfId.PLAYER_BLACK);
        if (node == null) {
            return "";
        }
        StringBuilder stringBuffer = new StringBuilder();
        String white = this.compose(node, SgfId.PLAYER_WHITE, SgfId.WHITE_RANK);
        stringBuffer.append("".equals(white) ? LB_UNKNOWN.get() : white);
        stringBuffer.append(' ').append(LB_VERSUS.get()).append(' ');
        String black = this.compose(node, SgfId.PLAYER_BLACK, SgfId.BLACK_RANK);
        stringBuffer.append("".equals(black) ? LB_UNKNOWN.get() : black);
        return stringBuffer.toString();
    }

    private String compose(Node node, SgfId mainType, SgfId subType) {
        String main = BasicFinder.findDatum(node, mainType);
        if (node == null) {
            return "";
        }
        String sub = BasicFinder.findDatum(node, subType);
        return sub.equals("") ? main : String.valueOf(main) + " [" + sub + "]";
    }

    public String displayName() {
        return LB_DISPLAY_NAME.get();
    }
}

