/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.io;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.unitarou.util.ArgumentChecker;

public class FileSnapshot {
    private final File file_;
    private final long lastModified_;
    private final long length_;

    public FileSnapshot(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        this.file_ = file;
        this.lastModified_ = this.file_.lastModified();
        this.length_ = this.file_.length();
    }

    public File file() {
        return this.file_;
    }

    public long lastModified() {
        return this.lastModified_;
    }

    public long length() {
        return this.length_;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        FileSnapshot fileSnapshot = (FileSnapshot)object;
        return this.lastModified_ == fileSnapshot.lastModified_ && this.length_ == fileSnapshot.length_ && FilenameUtils.equalsOnSystem(this.file_.getAbsolutePath(), fileSnapshot.file_.getAbsolutePath());
    }

    public int hashCode() {
        String string = this.file_.getAbsolutePath();
        if (File.separatorChar == '\\') {
            string = string.toUpperCase();
        }
        return (int)((long)(string.hashCode() * 1009) + this.lastModified_ * 1013L + this.length_ * 1019L);
    }
}

