/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.io;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;
import org.unitarou.ml.MessageResource;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ios {
    public static final char EXTENSION_SEPARATOR = '.';
    public static final MessageResource MSG_CANT_WRITE_TO_TMP_FILE = new MessageResource(Ios.class, "mgsCantWriteToTmpFile");
    private static final Set<File> tempFiles_s_ = new HashSet<File>(1);

    public static String calcRelativePath(String string, String string2) {
        String string3;
        ArgumentChecker.throwIfNull((Object)string, (Object)string2);
        string = FilenameUtils.separatorsToSystem(string);
        if (string.charAt(string.length() - 1) != File.separatorChar) {
            string = string + File.separator;
        }
        string2 = FilenameUtils.separatorsToSystem(string2);
        String string4 = FilenameUtils.getPrefix(string);
        if (!string4.equals(string3 = FilenameUtils.getPrefix(string2))) {
            return null;
        }
        Queue<String> queue = Ios.divide(FilenameUtils.getPath(string));
        Queue<String> queue2 = Ios.divide(FilenameUtils.getPath(string2));
        while (!queue.isEmpty() && !queue2.isEmpty() && queue.peek().equals(queue2.peek())) {
            queue.poll();
            queue2.poll();
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (queue.poll() != null) {
            stringBuilder.append("..").append(File.separatorChar);
        }
        for (String string5 : queue2) {
            stringBuilder.append(string5).append(File.separatorChar);
        }
        if (stringBuilder.length() != 0 && stringBuilder.charAt(stringBuilder.length() - 1) != File.separatorChar) {
            stringBuilder.append(File.separator);
        }
        stringBuilder.append(FilenameUtils.getName(string2));
        return stringBuilder.toString();
    }

    public static String calcCommonRoot(File file, File file2) {
        String string;
        String string2 = Ios.getFullPath(file);
        String string3 = Ios.getFullPath(file2);
        String string4 = FilenameUtils.getPrefix(string2);
        if (!string4.equals(string = FilenameUtils.getPrefix(string3))) {
            return null;
        }
        string2 = string2.substring(string4.length());
        string3 = string3.substring(string.length());
        Queue<String> queue = Ios.divide(FilenameUtils.getPath(string2));
        Queue<String> queue2 = Ios.divide(FilenameUtils.getPath(string3));
        StringBuilder stringBuilder = new StringBuilder(string4);
        while (!queue.isEmpty() && !queue2.isEmpty() && queue.peek().equals(queue2.peek())) {
            stringBuilder.append(queue.poll()).append(File.separator);
            queue2.poll();
        }
        return stringBuilder.toString();
    }

    public static boolean isChild(File file, File file2) {
        String string;
        String string2 = Ios.getFullPath(file);
        String string3 = Ios.getFullPath(file2);
        String string4 = FilenameUtils.getPrefix(string2);
        if (!string4.equals(string = FilenameUtils.getPrefix(string3))) {
            return false;
        }
        string2 = FilenameUtils.getPath(string2.substring(string4.length()));
        string3 = FilenameUtils.getPath(string3.substring(string.length()));
        return string3.startsWith(string2);
    }

    private static Queue<String> divide(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            linkedList.add(stringTokenizer.nextToken());
        }
        return linkedList;
    }

    private static String getFullPath(File file) {
        String string = file.getAbsolutePath();
        if (file.isDirectory() && string.charAt(string.length() - 1) != File.separatorChar) {
            return string + File.separator;
        }
        return string;
    }

    public static File getCurrentDirectory() {
        return new File(".").getAbsoluteFile().getParentFile().getAbsoluteFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createTemporaryFile(File file, int n) throws IOException {
        ArgumentChecker.throwIfNull((Object)file);
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        String string = file.getAbsolutePath();
        String string2 = FilenameUtils.getFullPath(string);
        String string3 = FilenameUtils.getBaseName(string);
        String string4 = FilenameUtils.getExtension(string);
        int n2 = 1;
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append('0');
            n2 *= 10;
        }
        DecimalFormat decimalFormat = new DecimalFormat(stringBuilder.toString());
        for (int i = 1; i <= n2 - 1; ++i) {
            File file2 = new File(string2 + File.separator + string3 + decimalFormat.format(i) + '.' + string4);
            if (file2.exists()) continue;
            file2.createNewFile();
            file2.deleteOnExit();
            Set<File> set = tempFiles_s_;
            synchronized (set) {
                tempFiles_s_.add(file2);
            }
            return file2;
        }
        throw new IOException();
    }

    public static boolean isTemporaryFile(File file) {
        return tempFiles_s_.contains(file);
    }

    protected Ios() {
    }
}

