/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;

class CreateGameTreeImpl
extends AbstractCommand {
    private final GameTree parent_;
    private final Node extensionPoint_;
    private final GameTree child_;

    CreateGameTreeImpl(GameTree gameTree, Node node, GameTree gameTree2) {
        if (gameTree == null || node == null || gameTree2 == null) {
            throw new NullPointerException("Arguments must not be null.  parent = " + gameTree + " extensionPoint = " + node + " child = " + gameTree2);
        }
        this.parent_ = gameTree;
        this.extensionPoint_ = node;
        this.child_ = gameTree2;
    }

    public void execute() {
        super.execute();
        GameTree gameTree = new GameTree();
        Node node = this.parent_.getSequence().removeLast();
        while (node != this.extensionPoint_) {
            gameTree.getSequence().addFirst(node);
            node = this.parent_.getSequence().removeLast();
        }
        this.parent_.getSequence().addLast(node);
        GameTree[] gameTreeArray = this.parent_.getChildren();
        for (int i = 0; i < gameTreeArray.length; ++i) {
            gameTree.addGameTree(gameTreeArray[i]);
        }
        this.parent_.clearGameTree();
        this.parent_.addGameTree(gameTree);
        this.parent_.addGameTree(this.child_);
    }

    public void undo() {
        super.undo();
        GameTree[] gameTreeArray = this.parent_.getChildren();
        for (Node node : gameTreeArray[0].getSequence()) {
            this.parent_.getSequence().addLast(node);
        }
        this.parent_.clearGameTree();
        GameTree[] gameTreeArray2 = gameTreeArray[0].getChildren();
        for (int i = 0; i < gameTreeArray2.length; ++i) {
            this.parent_.addGameTree(gameTreeArray2[i]);
        }
    }
}

