/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;

public class RemoveProperty
extends AbstractCommand {
    private final Node node_;
    private final Property[] properties_;
    private final String id_;
    private Property removed_;

    public RemoveProperty(Node node, String string) {
        if (node == null) {
            throw new NullPointerException("Arguments must not be null. node_ = " + node + " id = " + string);
        }
        this.node_ = node;
        this.properties_ = this.node_.getProperties();
        this.id_ = string;
        this.removed_ = null;
    }

    public void execute() {
        super.execute();
        this.removed_ = this.node_.removeProperty(this.id_);
        if (this.removed_ == null) {
            throw new IllegalStateException("Cannot remove property. property = " + this.id_);
        }
    }

    public void undo() {
        int n;
        super.undo();
        for (n = 0; n < this.properties_.length; ++n) {
            this.node_.removeProperty(this.properties_[n].getId());
        }
        for (n = 0; n < this.properties_.length; ++n) {
            this.node_.addProperty(this.properties_[n]);
        }
        this.removed_ = null;
    }
}

