/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.io;

import java.io.File;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.io.FileSnapshot;
import org.unitarou.lang.Exceptions;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.parser.SgfParser;
import org.unitarou.sgf.parser.SgfParserException;
import org.unitarou.sgf.parser.SgfParserLogger;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.sgf.util.filter.BasicFilter;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.FilterException;
import org.unitarou.util.StopWatch;

public final class CollectionRepository {
    private static final CollectionRepository instance_s_ = new CollectionRepository();
    private static final Log log_s_ = LogFactory.getLog(CollectionRepository.class);
    private static final MessageResource NT_CANT_READ_FILE = new MessageResource(CollectionRepository.class, "ntCantReadFile");
    private static final MessageResource NT_BAD_TYPE_FOR_DRILL = new MessageResource(SgfParser.class, "ntBadTypeForDrill");
    private static final MessageResource NT_FILE_NOT_FOUND_IN_DRILL = new MessageResource(SgfParser.class, "ntFileNotFoundInDrill");
    private static final MessageResource NT_FILE_IS_NOT_PROBLEM = new MessageResource(SgfParser.class, "ntFileIsNotProblem");
    private final Map<File, SoftReference<Collection>> fileCacheMap_ = new HashMap<File, SoftReference<Collection>>();
    private final Random random_ = new Random();

    public static CollectionRepository instance() {
        return instance_s_;
    }

    private CollectionRepository() {
    }

    public Collection load(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        StopWatch stopWatch = new StopWatch();
        SgfParser sgfParser = new SgfParser();
        try {
            Collection collection;
            SoftReference<Collection> softReference = this.fileCacheMap_.get(file);
            Collection collection2 = collection = softReference != null ? softReference.get() : null;
            if (collection == null || !this.isSameContents(collection.getFileSnapshot(), file)) {
                Collection collection3 = sgfParser.parse(file);
                this.fileCacheMap_.put(file, new SoftReference<Collection>(new Collection(collection3)));
                if (log_s_.isTraceEnabled()) {
                    log_s_.trace("Loaded " + stopWatch.stopSecond() + " secs for " + file);
                }
                return collection3;
            }
            if (log_s_.isTraceEnabled()) {
                log_s_.trace("Cache  " + stopWatch.stopSecond() + " secs for " + file);
            }
            return new Collection(collection);
        }
        catch (SgfParserException sgfParserException) {
            SgfParserLogger sgfParserLogger = new SgfParserLogger();
            sgfParserLogger.info(0, NT_CANT_READ_FILE.get(file.getAbsoluteFile(), Exceptions.getRootMessage(sgfParserException)), "");
            log_s_.debug("Instracted unreadable file:" + file.getAbsolutePath(), sgfParserException);
            return new Collection();
        }
    }

    private boolean isSameContents(FileSnapshot fileSnapshot, File file) {
        if (fileSnapshot == null || file == null) {
            return false;
        }
        return fileSnapshot.equals(new FileSnapshot(file));
    }

    public void loadProblem(Collection collection) {
        RootGameTree rootGameTree;
        String[] stringArray;
        ArgumentChecker.throwIfNull((Object)collection);
        if (collection.size() < 1 || !collection.get(0).getGameType().equals(GameType.DRILL) || collection.getFile() == null) {
            return;
        }
        StopWatch stopWatch = new StopWatch();
        SgfParserLogger sgfParserLogger = collection.getParserLog();
        File file = collection.getFile();
        if (1 < collection.size()) {
            while (collection.size() < 1) {
                collection.remove(collection.get(collection.size() - 1));
            }
            collection.setFile(null);
            sgfParserLogger.warn(1, NT_BAD_TYPE_FOR_DRILL.get(), "");
        }
        stringArray = (stringArray = BasicFinder.findData((rootGameTree = collection.get(0)).getSequence(), SgfId.INPUT_FILES)) == null ? new String[]{} : stringArray;
        String string = BasicFinder.findDatum(rootGameTree.getSequence(), SgfId.PROBLEM_PROPERTIES);
        ProblemProperties problemProperties = ProblemProperties.parsePpQuietly(string);
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray2[i];
            string2 = Sgfs.unescapeIfForRead(string2);
            File file2 = new File(file.getParent(), string2);
            if (!file2.exists() || !file2.isFile()) {
                sgfParserLogger.warn(1, NT_FILE_NOT_FOUND_IN_DRILL.get(), file2.getPath());
                continue;
            }
            this.appendProblem(collection, file2, problemProperties);
        }
        if (problemProperties.contains(ProblemProperties.Flag.SHUFFLE)) {
            int n2 = collection.size() - 1;
            for (n = 1; n < n2; ++n) {
                RootGameTree rootGameTree2 = collection.get(this.random_.nextInt(n2) + 1);
                collection.remove(rootGameTree2);
                collection.addLast(rootGameTree2);
            }
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("Costs " + stopWatch.stopSecond() + " secs");
        }
    }

    private void appendProblem(Collection collection, File file, ProblemProperties problemProperties) {
        Collection collection2 = this.load(file);
        SgfParserLogger sgfParserLogger = collection2.getParserLog();
        for (int i = 0; i < collection2.size(); ++i) {
            RootGameTree rootGameTree = collection2.get(i);
            if (!rootGameTree.getGameType().equals(GameType.PROBLEM)) {
                sgfParserLogger.info(0, NT_FILE_IS_NOT_PROBLEM.get(), String.valueOf(i + 1));
                continue;
            }
            try {
                if (problemProperties.contains(ProblemProperties.Flag.MIRROR_ROTATE)) {
                    BasicFilter.mirrorRotate(rootGameTree, this.random_.nextInt(8));
                }
                collection.addLast(rootGameTree);
                continue;
            }
            catch (FilterException filterException) {
                filterException.printStackTrace();
            }
        }
    }
}

