/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.io.dl;

import java.io.ByteArrayOutputStream;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.io.dl.HttpDownloadEvent;
import org.unitarou.sgf.io.dl.HttpDownloader;
import org.unitarou.sgf.io.dl.HttpDownloaderException;
import org.unitarou.sgf.io.dl.HttpDownloaderListener;
import org.unitarou.sgf.parser.SgfParser;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;

public class DefaultHttpDownloader
implements HttpDownloader {
    private static final Log log_s_ = LogFactory.getLog(DefaultHttpDownloader.class);
    private static final MessageResource LB_NAME = new MessageResource(DefaultHttpDownloader.class, "lbName");
    private static final MessageResource LB_STATUS_START = new MessageResource(DefaultHttpDownloader.class, "lbStatusStart");
    private static final MessageResource LB_STATUS_DOWNLOADING = new MessageResource(DefaultHttpDownloader.class, "lbStatusDownloading");
    private static final MessageResource LB_STATUS_START_PARSE = new MessageResource(DefaultHttpDownloader.class, "lbStatusStartParse");
    private static final MessageResource LB_STATUS_REPLACE_BR = new MessageResource(DefaultHttpDownloader.class, "lbStatusReplaceBr");
    private static final MessageResource LB_STATUS_REPLACE_ENTITY_REFERENCE = new MessageResource(DefaultHttpDownloader.class, "lbStatusReplaceEntityReference");
    private static final MessageResource NT_UNKNOWN_HOST = new MessageResource(DefaultHttpDownloader.class, "ntUnknownHost");
    private static final MessageResource NT_BAD_URL = new MessageResource(DefaultHttpDownloader.class, "ntBadUrl");
    private static final int NOTIFY_BYTE_SIZE = 4096;
    protected static final Pattern patternBr_s_ = Pattern.compile("<\\s*[bB][rR]\\s*>");
    protected static final Pattern patternGt_s_ = Pattern.compile("&gt;");
    protected static final Pattern patternLt_s_ = Pattern.compile("&lt;");
    protected static final Pattern patternAmp_s_ = Pattern.compile("&amp;");
    protected static final Pattern patternQuot_s_ = Pattern.compile("&quot;");
    protected static final Pattern patternMetaCharset_s_ = Pattern.compile("^.*<meta\\s+http-equiv\\s*=\\s*\"Content-Type\"\\s+content\\s*=\\s*\"text/html;\\s*charset\\s*=\\s*(.+)\\s*\".*>.*$", 10);
    private final List<HttpDownloaderListener> listeners_ = Collections.synchronizedList(new ArrayList(1));
    private int statusCode_;

    public String displayName() {
        return LB_NAME.get();
    }

    public Collection download(String string) throws HttpDownloaderException {
        ArgumentChecker.throwIfNull((Object)string);
        HttpClient httpClient = new HttpClient();
        GetMethod getMethod = null;
        try {
            int n;
            getMethod = new GetMethod(string);
            this.setupRequestHeader(getMethod);
            this.notifyListener(new HttpDownloadEvent(this, LB_STATUS_START.get()));
            this.statusCode_ = httpClient.executeMethod(getMethod);
            Header[] headerArray = getMethod.getResponseHeaders();
            if (log_s_.isTraceEnabled()) {
                log_s_.trace("STATUS CODE: " + this.statusCode_);
                for (Header header : headerArray) {
                    log_s_.trace("HEADER: " + header.toExternalForm());
                }
            }
            Header[] headerArray2 = getMethod.getResponseBodyAsStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = 0;
            StringBuilder stringBuilder = new StringBuilder();
            while ((n = headerArray2.read()) != -1) {
                byteArrayOutputStream.write(n);
                if (++n2 % 4096 != 0) continue;
                if (stringBuilder.length() != 0) {
                    stringBuilder.delete(0, stringBuilder.length());
                }
                this.notifyListener(new HttpDownloadEvent(this, LB_STATUS_DOWNLOADING.get((Object)new Integer(n2 / 1024)), 1));
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
            Charset charset = this.getCharset(headerArray, byteBuffer);
            byteBuffer.rewind();
            CharBuffer charBuffer = charset.decode(byteBuffer);
            CharSequence charSequence = this.findSgf(charBuffer);
            charSequence = this.replaceHtmlElements(charSequence);
            this.notifyListener(new HttpDownloadEvent(this, LB_STATUS_START_PARSE.get(), 20));
            SgfParser sgfParser = new SgfParser();
            Collection collection = sgfParser.parse(((Object)charSequence).toString(), charset);
            return collection;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HttpDownloaderException(NT_BAD_URL.get());
        }
        catch (UnknownHostException unknownHostException) {
            throw new HttpDownloaderException(NT_UNKNOWN_HOST.get((Object)unknownHostException.getMessage()));
        }
        catch (Exception exception) {
            throw new HttpDownloaderException(exception);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
    }

    protected void setupRequestHeader(HttpMethod httpMethod) {
        Yukinoshita yukinoshita = Yukinoshita.instance();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(yukinoshita.getName()).append('/').append(yukinoshita.getVersion()).append('(').append(yukinoshita.getLastUpdate()).append(')');
        httpMethod.addRequestHeader("User-Agent", stringBuilder.toString());
    }

    protected Charset getCharset(Header[] headerArray, ByteBuffer byteBuffer) {
        try {
            CharBuffer charBuffer = Strings.CHARSET_US_ASCII.decode(byteBuffer);
            Matcher matcher = patternMetaCharset_s_.matcher(charBuffer);
            if (matcher.find()) {
                String string = matcher.group(1);
                return Charset.forName(string);
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        return Charset.defaultCharset();
    }

    protected CharSequence findSgf(CharSequence charSequence) {
        return charSequence;
    }

    protected CharSequence replaceHtmlElements(CharSequence charSequence) {
        this.notifyListener(new HttpDownloadEvent(this, LB_STATUS_REPLACE_BR.get(), 20));
        charSequence = patternBr_s_.matcher(charSequence).replaceAll(Strings.LINE_SEPARATOR);
        this.notifyListener(new HttpDownloadEvent(this, LB_STATUS_REPLACE_ENTITY_REFERENCE.get(), 20));
        charSequence = patternGt_s_.matcher(charSequence).replaceAll(">");
        charSequence = patternLt_s_.matcher(charSequence).replaceAll("<");
        charSequence = patternAmp_s_.matcher(charSequence).replaceAll("&");
        charSequence = patternQuot_s_.matcher(charSequence).replaceAll("\"");
        return charSequence;
    }

    public int matches(String string) {
        return 0;
    }

    public void addListener(HttpDownloaderListener httpDownloaderListener) {
        if (httpDownloaderListener != null) {
            this.listeners_.add(httpDownloaderListener);
        }
    }

    public boolean removeListener(HttpDownloaderListener httpDownloaderListener) {
        return this.listeners_.remove(httpDownloaderListener);
    }

    protected void notifyListener(HttpDownloadEvent httpDownloadEvent) {
        HttpDownloaderListener[] httpDownloaderListenerArray;
        for (HttpDownloaderListener httpDownloaderListener : httpDownloaderListenerArray = this.listeners_.toArray(new HttpDownloaderListener[0])) {
            httpDownloaderListener.changeStatus(httpDownloadEvent);
        }
    }
}

