/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.filter;

import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.util.Filter;
import org.unitarou.util.FilterException;
import org.unitarou.util.NestedFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSgfFilter
extends NestedFilter<Collection> {
    public AbstractSgfFilter() {
    }

    public AbstractSgfFilter(Filter<Collection> filter) {
        super(filter);
    }

    @Override
    public Collection filter(Collection collection) throws FilterException {
        collection = super.filter(collection);
        collection = this.filterCollection(collection);
        Collection collection2 = new Collection();
        for (RootGameTree rootGameTree : collection) {
            collection2.addLast(this.filterRootGameTreeFrame(rootGameTree));
        }
        return collection2;
    }

    private RootGameTree filterRootGameTreeFrame(RootGameTree rootGameTree) {
        rootGameTree = this.filterRootGameTree(rootGameTree);
        RootGameTree rootGameTree2 = new RootGameTree(rootGameTree);
        rootGameTree2.getSequence().clear();
        for (Node node : rootGameTree.getSequence()) {
            rootGameTree2.getSequence().addLast(this.filterNodeFrame(node));
        }
        rootGameTree2.clearGameTree();
        for (GameTree gameTree : rootGameTree.getChildren()) {
            rootGameTree2.addGameTree(this.filterGameTreeFrame(gameTree));
        }
        return rootGameTree2;
    }

    private GameTree filterGameTreeFrame(GameTree gameTree) {
        gameTree = this.filterGameTree(gameTree);
        GameTree gameTree2 = new GameTree(gameTree);
        gameTree2.getSequence().clear();
        for (Node node : gameTree.getSequence()) {
            gameTree2.getSequence().addLast(this.filterNodeFrame(node));
        }
        gameTree2.clearGameTree();
        for (GameTree gameTree3 : gameTree.getChildren()) {
            gameTree2.addGameTree(this.filterGameTreeFrame(gameTree3));
        }
        return gameTree2;
    }

    private Node filterNodeFrame(Node node) {
        node = this.filterNode(node);
        Node node2 = new Node(node);
        node2.clearProperty();
        for (Property property : node.getProperties()) {
            if (!(property = this.filterPropertyFrame(property)).isValid()) continue;
            node2.addProperty(property);
        }
        return node2;
    }

    private Property filterPropertyFrame(Property property) {
        if (!(property = this.filterProperty(property)).isValid()) {
            return property;
        }
        Property property2 = new Property(property);
        property2.clearValue();
        for (Value value : property.getValues()) {
            property2.addValue(this.filterValue(value, property2.sgfId()));
        }
        return property2;
    }

    protected Collection filterCollection(Collection collection) {
        return collection;
    }

    protected RootGameTree filterRootGameTree(RootGameTree rootGameTree) {
        return rootGameTree;
    }

    protected GameTree filterGameTree(GameTree gameTree) {
        return gameTree;
    }

    protected Node filterNode(Node node) {
        return node;
    }

    protected Property filterProperty(Property property) {
        return property;
    }

    protected Value filterValue(Value value, SgfId sgfId) {
        return value;
    }
}

