/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.filter;

import org.unitarou.sgf.Collection;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.util.filter.AbstractSgfFilter;
import org.unitarou.util.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveSoftLineBreakFilter
extends AbstractSgfFilter {
    private static final String[] SOFT_LINE_BREAKS = new String[]{"\\\r\n", "\\\n\r", "\\\r", "\\\n"};

    public RemoveSoftLineBreakFilter() {
    }

    public RemoveSoftLineBreakFilter(Filter<Collection> filter) {
        super(filter);
    }

    @Override
    protected Value filterValue(Value value, SgfId sgfId) {
        value = super.filterValue(value, sgfId);
        if (sgfId.valueType().equals((Object)ValueType.TEXT) || sgfId.valueType().equals((Object)ValueType.SIMPLE_TEXT)) {
            String string = value.getString();
            for (String string2 : SOFT_LINE_BREAKS) {
                string = string.replace(string2, "");
            }
            value = new Value(string, value.getOpenUtr());
        }
        return value;
    }
}

