/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.filter;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.util.filter.AbstractSgfFilter;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveUtrFilter
extends AbstractSgfFilter {
    private Option option_ = Option.REMOVE_ALL;

    public RemoveUtrFilter() {
        this((Filter<Collection>)null);
    }

    public RemoveUtrFilter(Filter<Collection> filter) {
        super(filter);
    }

    public void setOption(Option option) {
        ArgumentChecker.throwIfNull((Object)option);
        this.option_ = option;
    }

    public Option getOption() {
        return this.option_;
    }

    @Override
    protected RootGameTree filterRootGameTree(RootGameTree rootGameTree) {
        rootGameTree.setOpenUtr(this.filter(rootGameTree.getOpenUtr()));
        rootGameTree.setCloseUtr(this.filter(rootGameTree.getCloseUtr()));
        return rootGameTree;
    }

    @Override
    protected GameTree filterGameTree(GameTree gameTree) {
        gameTree.setOpenUtr(this.filter(gameTree.getOpenUtr()));
        gameTree.setCloseUtr(this.filter(gameTree.getCloseUtr()));
        return gameTree;
    }

    @Override
    protected Node filterNode(Node node) {
        node.setOpenUtr(this.filter(node.getOpenUtr()));
        node.setCloseUtr(this.filter(node.getCloseUtr()));
        return node;
    }

    @Override
    protected Property filterProperty(Property property) {
        property.setOpenUtr(this.filter(property.getOpenUtr()));
        property.setCloseUtr(this.filter(property.getCloseUtr()));
        return property;
    }

    @Override
    protected Value filterValue(Value value, SgfId sgfId) {
        return new Value(value.getString(), this.filter(value.getOpenUtr()));
    }

    @Override
    private String filter(String string) {
        switch (this.option_) {
            case HOLDING: {
                break;
            }
            case REMOVE_TEXT: {
                StringBuilder stringBuilder = new StringBuilder(string.length());
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (!Character.isISOControl(c)) continue;
                    stringBuilder.append(c);
                }
                string = stringBuilder.toString();
                break;
            }
            case REMOVE_ALL: {
                string = "";
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        HOLDING,
        REMOVE_TEXT,
        REMOVE_ALL;


        public String toString() {
            return new MessageResource(((Object)((Object)this)).getClass(), this.name()).get();
        }
    }
}

