/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.events;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.Classes;
import org.unitarou.lang.Runtimes;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.ActionListener;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.HandlerSelector;
import org.unitarou.yukinoshita.events.StateHandler;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.view.cmd.Command4View;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.CommandDriverMonitor;
import org.unitarou.yukinoshita.view.monitor.ContextMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.LayoutMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeListMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;
import org.unitarou.yukinoshita.view.monitor.OutlineMonitor;
import org.unitarou.yukinoshita.view.monitor.ProblemStatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventBrokerImpl
implements EventBroker {
    private static final Log log_s_ = LogFactory.getLog(EventBrokerImpl.class);
    private static final Class[] viewAdapters_s_ = new Class[]{CollectionMonitor.class, GameMonitor.class, NodeListMonitor.class, NodeMonitor.class, GameInfoNodeMonitor.class, ContextMonitor.class, ControllerStatusMonitor.class, ProblemStatusMonitor.class, OutlineMonitor.class, LayoutMonitor.class, CommandDriverMonitor.class};
    private static final Class[] ctrlAdapters_s_ = new Class[]{ActionListener.class};
    private final Map<Class<?>, Set<Object>> adapterMap_ = new HashMap();
    private final HandlerSelector handlerSelector_ = new HandlerSelector();

    public EventBrokerImpl() {
        this.handlerSelector_.setEventBroker(this);
    }

    public void dispose() {
        for (Set<Object> set : this.adapterMap_.values()) {
            set.clear();
        }
        this.adapterMap_.clear();
        this.handlerSelector_.clear();
    }

    @Override
    public void addView(Adaptable adaptable) {
        ArgumentChecker.throwIfNull((Object)adaptable);
        for (int i = 0; i < viewAdapters_s_.length; ++i) {
            this.addAdapter(adaptable, viewAdapters_s_[i]);
        }
    }

    @Override
    public void removeView(Adaptable adaptable) {
        ArgumentChecker.throwIfNull((Object)adaptable);
        for (int i = 0; i < viewAdapters_s_.length; ++i) {
            this.removeAdapter(adaptable, viewAdapters_s_[i]);
        }
    }

    public void addController(Adaptable adaptable) {
        ArgumentChecker.throwIfNull((Object)adaptable);
        for (int i = 0; i < ctrlAdapters_s_.length; ++i) {
            this.addAdapter(adaptable, ctrlAdapters_s_[i]);
        }
    }

    public void removeController(Adaptable adaptable) {
        ArgumentChecker.throwIfNull((Object)adaptable);
        for (int i = 0; i < ctrlAdapters_s_.length; ++i) {
            this.removeAdapter(adaptable, ctrlAdapters_s_[i]);
        }
    }

    private void addAdapter(Adaptable adaptable, Class<?> clazz) {
        Object object = adaptable.getAdapter(clazz);
        if (object == null) {
            return;
        }
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException("Bad adapter: adaptable:" + adaptable + " class:" + clazz + ", but obj:" + object);
        }
        Set<Object> set = this.adapterMap_.get(clazz);
        if (set == null) {
            set = new HashSet<Object>();
            this.adapterMap_.put(clazz, set);
        }
        set.add(object);
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[ADD ADAPTER] " + Classes.simpleName(adaptable.getClass()) + " has " + Classes.simpleName(clazz) + "'s adapter: " + object);
        }
    }

    private void removeAdapter(Adaptable adaptable, Class<?> clazz) {
        Object object = adaptable.getAdapter(clazz);
        if (object == null) {
            return;
        }
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException("Bad adapter: adaptable:" + adaptable + " class:" + clazz + ", but obj:" + object);
        }
        Set<Object> set = this.adapterMap_.get(clazz);
        if (set != null) {
            set.remove(object);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[DEL ADAPTER] " + Classes.simpleName(adaptable.getClass()) + " has " + Classes.simpleName(clazz) + "'s adapter: " + object);
        }
    }

    @Override
    public <T> Set<T> getListeners(Class<T> clazz) {
        ArgumentChecker.throwIfNull(clazz);
        Set<Object> set = this.adapterMap_.get(clazz);
        if (set == null) {
            set = new HashSet<Object>();
            log_s_.warn("Unused or unregistered listener (May be BUG):" + clazz);
        }
        HashSet<Object> hashSet = new HashSet<Object>(set.size());
        for (Object object : set) {
            hashSet.add(object);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[CALL LISTENER] " + clazz.getName() + " is called. " + "Listener size is " + hashSet.size());
        }
        return hashSet;
    }

    @Override
    public void register(GameType gameType, boolean bl, StateHandler stateHandler) {
        this.handlerSelector_.put(gameType, bl, stateHandler);
        stateHandler.setEventBroker(this);
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[REGISTER] " + gameType + "(Edit mode:" + bl + "), state handler: " + stateHandler);
        }
    }

    @Override
    public void connect(GameType gameType, boolean bl) {
        this.handlerSelector_.connect(gameType, bl);
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[CONNECT] " + gameType + "/Edit mode:" + bl);
        }
    }

    @Override
    public void disconnect() {
        this.handlerSelector_.disconnect();
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[DISCONNECT] ");
        }
    }

    @Override
    public StateHandler getCurrentStateHander() {
        return this.handlerSelector_.getCurrent();
    }

    @Override
    public void executeCommand(Command4NodeList command4NodeList) {
        ArgumentChecker.throwIfNull((Object)command4NodeList);
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[START COMMAND] " + command4NodeList + " " + Runtimes.formatStackTrace(4));
        }
        for (ActionListener actionListener : this.getListeners(ActionListener.class)) {
            actionListener.executeCommand(command4NodeList);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[END COMMAND] " + command4NodeList);
        }
    }

    @Override
    public void executeCommand(Command4View command4View) {
        ArgumentChecker.throwIfNull((Object)command4View);
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[START COMMAND] " + command4View + " " + Runtimes.formatStackTrace(4));
        }
        for (ActionListener actionListener : this.getListeners(ActionListener.class)) {
            actionListener.executeCommand(command4View);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("[END COMMAND] " + command4View);
        }
    }
}

