/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.CollectionEvent;
import org.unitarou.sgf.CollectionListener;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.GameMediator;

public class CollectionEditor {
    private static final Log logger_s_ = LogFactory.getLog(CollectionEditor.class);
    private final Collection collection_;
    private final CollectionListener listener_;
    private final Map<Integer, GameMediator> gameMap_;
    private int activeGameIndex_;

    public CollectionEditor(Collection collection) {
        this(collection, false);
    }

    public CollectionEditor(Collection collection, boolean bl) {
        ArgumentChecker.throwIfNull((Object)collection);
        this.collection_ = collection;
        this.listener_ = new CollectionListenerImpl();
        collection.addListener(this.listener_);
        this.gameMap_ = new HashMap<Integer, GameMediator>(this.collection_.size());
        this.activeGameIndex_ = 0;
        if (bl) {
            for (int i = 0; i < this.collection_.size(); ++i) {
                this.initializeGame(i, true);
            }
        }
    }

    public void dispose() {
        this.gameMap_.clear();
        this.collection_.removeListener(this.listener_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.gameMap_.isEmpty()) {
                logger_s_.warn(this + " is not disposed.");
                this.dispose();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void setActiveGame(int n) {
        if (n < 0 || this.collection_.size() <= n) {
            throw new IllegalArgumentException("Parameter gameIndex is out of bounds. Game size is " + this.collection_.size() + ". Parameter gameIndex is " + n);
        }
        this.activeGameIndex_ = n;
    }

    public Collection getCollection() {
        return this.collection_;
    }

    public int getActiveGameIndex() {
        return this.activeGameIndex_;
    }

    public GameMediator getActiveGame() {
        return this.get(this.activeGameIndex_);
    }

    private GameMediator initializeGame(int n, boolean bl) {
        RootGameTree rootGameTree = this.collection_.get(n);
        GameMediator gameMediator = new GameMediator(rootGameTree, bl);
        this.gameMap_.put(new Integer(n), gameMediator);
        return gameMediator;
    }

    public boolean[] getChangedFlags() {
        boolean[] blArray = new boolean[this.collection_.size()];
        for (int i = 0; i < blArray.length; ++i) {
            GameMediator gameMediator = this.gameMap_.get(new Integer(i));
            blArray[i] = gameMediator != null && gameMediator.isChanged();
        }
        return blArray;
    }

    public void clearChangedFlags() {
        for (GameMediator gameMediator : this.gameMap_.values()) {
            gameMediator.clearChanged();
        }
    }

    public int size() {
        return this.collection_.size();
    }

    public GameMediator createGame(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        this.collection_.addLast(rootGameTree);
        GameMediator gameMediator = this.initializeGame(this.collection_.size() - 1, true);
        return gameMediator;
    }

    public boolean isDrill() {
        return this.get(0).getGameType().equals(GameType.DRILL);
    }

    private GameMediator get(int n) {
        if (n < 0 || this.collection_.size() <= n) {
            throw new IndexOutOfBoundsException("Bad index:" + n);
        }
        GameMediator gameMediator = this.gameMap_.get(new Integer(n));
        if (gameMediator == null) {
            gameMediator = this.initializeGame(n, false);
        }
        return gameMediator;
    }

    public void remove(int n) {
        if (n < 0 || this.collection_.size() <= n) {
            throw new IndexOutOfBoundsException("Bad index:" + n);
        }
        this.collection_.remove(this.collection_.get(n));
    }

    private class CollectionListenerImpl
    implements CollectionListener {
        private CollectionListenerImpl() {
        }

        public void rootGameTreeRemoved(CollectionEvent collectionEvent) {
            RootGameTree rootGameTree = collectionEvent.getRootGameTree();
            for (Map.Entry entry : CollectionEditor.this.gameMap_.entrySet()) {
                if (!((GameMediator)entry.getValue()).getRootGameTree().equals(rootGameTree)) continue;
                CollectionEditor.this.gameMap_.remove(entry.getKey());
                if (CollectionEditor.this.activeGameIndex_ == CollectionEditor.this.collection_.size()) {
                    CollectionEditor.this.activeGameIndex_ = CollectionEditor.this.collection_.size() - 1;
                }
                return;
            }
        }
    }
}

