/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.board;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unitarou.lang.NullArgumentException;
import org.unitarou.lang.UEnum;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.Label;
import org.unitarou.sgf.type.SgfLine;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.board.IgoBoard;
import org.unitarou.yukinoshita.model.board.InheritableMarker;
import org.unitarou.yukinoshita.model.board.OverblockMarker;
import org.unitarou.yukinoshita.view.jface.board.BlockPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockedBoardDesigner {
    private static final SgfId[] drawTypes_s_ = new SgfId[]{SgfId.MARK_WITH_X, SgfId.CIRCLE, SgfId.SQUARE, SgfId.TRIANGLE, SgfId.SELECTED, SgfId.TERRITORY_WHITE, SgfId.TERRITORY_BLACK, SgfId.DIM_POINTS};
    private final Map<SgfPoint, Set<SgfId>> markerMap_ = new TreeMap<SgfPoint, Set<SgfId>>();
    private final InheritableMarker inheritableMarker_ = new InheritableMarker();
    private final OverblockMarker overblockMarker_ = new OverblockMarker();
    private final List<BlockPainter> blockPainters_ = new ArrayList<BlockPainter>();
    private NodeView nodeView_ = null;
    private final Set<SgfPoint> durablePaintings_ = new TreeSet<SgfPoint>();
    private final Set<SgfPoint> transientPaintings_ = new TreeSet<SgfPoint>();
    private final Set<SgfPoint> lastTransientPaintings_ = new TreeSet<SgfPoint>();
    private final Set<SgfPoint> vwPoints_ = new HashSet<SgfPoint>(SgfSize.DEFAULT.height() * SgfSize.DEFAULT.width());

    public BlockedBoardDesigner(IgoBoard igoBoard) {
    }

    public void addBlockPainter(BlockPainter blockPainter) {
        ArgumentChecker.throwIfNull((Object)blockPainter);
        this.blockPainters_.add(blockPainter);
    }

    public void removeBlockPainter(BlockPainter blockPainter) {
        ArgumentChecker.throwIfNull((Object)blockPainter);
        this.blockPainters_.remove(blockPainter);
    }

    private void addMarker(SgfPoint sgfPoint, SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfPoint, (Object)sgfId);
        Set<SgfId> set = this.markerMap_.get(sgfPoint);
        if (set == null) {
            set = new TreeSet<SgfId>();
            this.markerMap_.put(sgfPoint, set);
        }
        set.add(sgfId);
    }

    public void addRedrawPoint(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        this.transientPaintings_.add(sgfPoint);
    }

    public SgfId[] getMarkers(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        Set<SgfId> set = this.markerMap_.get(sgfPoint);
        if (set == null) {
            return new SgfId[0];
        }
        return set.toArray(new SgfId[set.size()]);
    }

    public SgfPoint[] getMarkerPoints(SgfId sgfId) {
        if (sgfId == null) {
            throw new NullArgumentException("sgfType must not be null.");
        }
        ArrayList<SgfPoint> arrayList = new ArrayList<SgfPoint>(this.markerMap_.size());
        for (Map.Entry<SgfPoint, Set<SgfId>> entry : this.markerMap_.entrySet()) {
            Set<SgfId> set = entry.getValue();
            if (set == null || !set.contains(sgfId)) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList.toArray(new SgfPoint[arrayList.size()]);
    }

    public boolean hasOverblockMark() {
        return !this.overblockMarker_.isEmpty();
    }

    public void update(NodeView nodeView) {
        ArgumentChecker.throwIfNull((Object)nodeView);
        this.nodeView_ = nodeView;
        this.markerMap_.clear();
        this.durablePaintings_.clear();
        this.lastTransientPaintings_.clear();
        this.lastTransientPaintings_.addAll(this.transientPaintings_);
        this.transientPaintings_.clear();
        for (BlockPainter blockPainter : this.blockPainters_) {
            Set<SgfPoint> set = blockPainter.getDurablePaintings(this.nodeView_);
            if (set == null) continue;
            this.durablePaintings_.addAll(set);
            this.transientPaintings_.addAll(blockPainter.getTransientPaintings(this.nodeView_));
        }
        this.updateMarkers(this.nodeView_);
        this.updateInheritableMarkers(this.nodeView_.getInheritableDecoration());
        this.updateOverblockMarker(this.nodeView_);
    }

    private void updateMarkers(NodeView nodeView) {
        for (int i = 0; i < drawTypes_s_.length; ++i) {
            Property property = nodeView.getProperty(drawTypes_s_[i]);
            if (property == null || !property.sgfId().valueType().equals((Object)ValueType.POINT)) continue;
            String[] stringArray = property.getStrings();
            SgfPoint[] sgfPointArray = SgfPoint.parse(this.nodeView_.getSize(), stringArray);
            for (int j = 0; j < sgfPointArray.length; ++j) {
                this.addMarker(sgfPointArray[j], drawTypes_s_[i]);
            }
        }
    }

    private void updateInheritableMarkers(InheritableMarker inheritableMarker) {
        UEnum[] uEnumArray = UEnum.getAll(SgfId.class);
        for (int i = 0; i < uEnumArray.length; ++i) {
            SgfId sgfId = (SgfId)uEnumArray[i];
            if (!sgfId.propertyType().equals(PropertyType.INHERIT)) continue;
            if (SgfId.VIEW.equals(sgfId)) {
                this.updateInheritableMarkerImpl4VW(inheritableMarker);
                continue;
            }
            this.updateInheritableMarkerImpl(inheritableMarker, sgfId);
        }
        this.inheritableMarker_.set(inheritableMarker);
    }

    private void updateInheritableMarkerImpl(InheritableMarker inheritableMarker, SgfId sgfId) {
        int n;
        String[] stringArray = this.inheritableMarker_.get(sgfId);
        String[] stringArray2 = inheritableMarker.get(sgfId);
        SgfPoint[] sgfPointArray = this.getPoints(stringArray);
        SgfPoint[] sgfPointArray2 = this.getPoints(stringArray2);
        if (sgfPointArray != null) {
            for (n = 0; n < sgfPointArray.length; ++n) {
                this.addRedrawPoint(sgfPointArray[n]);
            }
        }
        if (sgfPointArray2 == null) {
            return;
        }
        for (n = 0; n < sgfPointArray2.length; ++n) {
            this.addMarker(sgfPointArray2[n], sgfId);
        }
    }

    private void updateInheritableMarkerImpl4VW(InheritableMarker inheritableMarker) {
        String[] stringArray = this.inheritableMarker_.get(SgfId.VIEW);
        String[] stringArray2 = inheritableMarker.get(SgfId.VIEW);
        SgfPoint[] sgfPointArray = this.getPoints(stringArray);
        SgfPoint[] sgfPointArray2 = this.getPoints(stringArray2);
        this.vwPoints_.clear();
        if (sgfPointArray == null && sgfPointArray2 == null) {
            this.vwPoints_.addAll(this.nodeView_.getSize().all());
            return;
        }
        if (sgfPointArray == null || sgfPointArray.length == 0) {
            Set<SgfPoint> set = this.nodeView_.getSize().all();
            sgfPointArray = set.toArray(new SgfPoint[set.size()]);
        }
        for (int i = 0; i < sgfPointArray.length; ++i) {
            this.addRedrawPoint(sgfPointArray[i]);
        }
        if (sgfPointArray2 == null || sgfPointArray2.length == 0) {
            this.vwPoints_.addAll(this.nodeView_.getSize().all());
            sgfPointArray2 = this.vwPoints_.toArray(new SgfPoint[this.vwPoints_.size()]);
        }
        for (SgfPoint sgfPoint : sgfPointArray2) {
            this.addMarker(sgfPoint, SgfId.VIEW);
            this.addRedrawPoint(sgfPoint);
            this.vwPoints_.add(sgfPoint);
        }
    }

    private SgfPoint[] getPoints(String[] stringArray) {
        return stringArray == null ? null : SgfPoint.parse(this.nodeView_.getSize(), stringArray);
    }

    private void updateOverblockMarker(NodeView nodeView) {
        OverblockMarker overblockMarker = nodeView.getOverblockMarker();
        boolean bl = this.overblockMarker_.isEmpty() && overblockMarker.isEmpty();
        this.overblockMarker_.set(overblockMarker);
        if (bl) {
            return;
        }
    }

    public SgfRectangle calcView() {
        SgfRectangle sgfRectangle = new SgfRectangle();
        SgfPoint[] sgfPointArray = this.vwPoints_.toArray(new SgfPoint[this.vwPoints_.size()]);
        for (int i = 0; i < sgfPointArray.length; ++i) {
            sgfRectangle.intersect(sgfPointArray[i]);
        }
        if (sgfPointArray.length == 0) {
            SgfSize sgfSize = this.nodeView_.getSize();
            sgfRectangle.set(SgfPoint.create(sgfSize, 1, 1), SgfPoint.create(sgfSize, sgfSize.width(), sgfSize.height()));
        }
        return sgfRectangle;
    }

    public boolean isDrawArea(SgfPoint sgfPoint) {
        return this.vwPoints_.contains(sgfPoint);
    }

    public Set<SgfPoint> getRedrawBlocks() {
        TreeSet<SgfPoint> treeSet = new TreeSet<SgfPoint>();
        treeSet.addAll(this.durablePaintings_);
        treeSet.addAll(this.transientPaintings_);
        treeSet.addAll(this.lastTransientPaintings_);
        return treeSet;
    }

    public Label[] getLabels() {
        return this.overblockMarker_.getLabels(this.nodeView_.getSize());
    }

    public SgfLine[] getLine(SgfId sgfId) {
        return this.overblockMarker_.getLine(sgfId, this.nodeView_.getSize());
    }
}

