/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.util.Stone;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartSolvingProblem
extends Command4NodeList {
    private static final MessageResource LB_NAME = new MessageResource(StartSolvingProblem.class, "lbName");
    private final GameMediator gameMediator_;

    public StartSolvingProblem(GameMediator gameMediator) {
        ArgumentChecker.throwIfNull((Object)gameMediator);
        this.gameMediator_ = gameMediator;
        this.setUndoneNodeIndex(this.gameMediator_.getCurrentNodeIndex());
        this.setDisplayName(LB_NAME.get());
    }

    @Override
    public void execute() {
        super.execute();
        NodeList nodeList = this.gameMediator_.getNodeList();
        for (int i = 0; i < this.gameMediator_.getNodeList().size(); ++i) {
            Stone stone = nodeList.getNodeView(i).getMove();
            if (stone.getColor() == null) continue;
            int n = i != 0 ? i - 1 : 0;
            this.setExecutedNodeIndex(n);
            this.gameMediator_.setNodeIndex(n);
            return;
        }
    }

    @Override
    public void undo() {
        super.undo();
        this.gameMediator_.setNodeIndex(this.getUndoneNodeIndex());
    }

    @Override
    public EnumSet<ModelInfluence> getInfluence() {
        return EnumSet.of(ModelInfluence.NODE_CURRENT);
    }
}

