/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.cmd.Command;
import org.unitarou.cmd.NullCommand;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.cmd.EditProperty;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.cmd.AddNode;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateProperty
extends Command4NodeList {
    private static final Log log_s_ = LogFactory.getLog(UpdateProperty.class);
    private static final MessageResource LB_ADD_NAME = new MessageResource(UpdateProperty.class, "lbAddName");
    private static final MessageResource LB_EDIT_NAME = new MessageResource(UpdateProperty.class, "lbEditName");
    private static final MessageResource LB_DELETE_NAME = new MessageResource(UpdateProperty.class, "lbDeleteName");
    private final Property[] excluded_;
    private final Property include_;
    private final PropertyType propertyType_;
    private NodeEntity target_;
    private EditProperty[] editProperties_;
    private boolean hasRgtInfluence_;
    private EnumSet<ModelInfluence> influences_;
    private Command addNode_;

    public UpdateProperty(Property[] propertyArray, Property property, PropertyType propertyType) {
        ArgumentChecker.throwIfNull((Object)propertyArray);
        this.editProperties_ = null;
        this.hasRgtInfluence_ = false;
        this.addNode_ = NullCommand.INSTANCE;
        this.excluded_ = new Property[propertyArray.length];
        System.arraycopy(propertyArray, 0, this.excluded_, 0, this.excluded_.length);
        this.include_ = property;
        this.propertyType_ = propertyType;
        this.influences_ = EnumSet.noneOf(ModelInfluence.class);
    }

    @Override
    protected boolean setup() {
        Object object;
        if (this.editProperties_ != null) {
            return true;
        }
        EditableNodeList editableNodeList = this.getEditableNodeList();
        if (editableNodeList == null) {
            return false;
        }
        this.target_ = editableNodeList.getPosition();
        if (this.propertyType_ == null) {
            this.influences_.add(ModelInfluence.NODE_CURRENT);
        } else {
            int n;
            for (n = editableNodeList.getPositionIndex(); 0 <= n; --n) {
                object = editableNodeList.get(n);
                if (!((NodeEntity)object).getNode().contains(this.propertyType_)) continue;
                this.target_ = editableNodeList.get(n);
                break;
            }
            if (this.propertyType_.equals(PropertyType.ROOT) && n != 0) assert (false) : "Bad strucuture.";
            switch (this.propertyType_) {
                case GAME_INFO: {
                    this.influences_.add(ModelInfluence.NODE_GAMEINFO);
                    break;
                }
                case ROOT: {
                    this.influences_.add(ModelInfluence.ROOT_GAME_TREE);
                    break;
                }
                default: {
                    int n2 = n - editableNodeList.getPositionIndex();
                    if (n2 == 0) {
                        this.influences_.add(ModelInfluence.NODE_CURRENT);
                        break;
                    }
                    log_s_.warn("Unsupported update type: index - curIndex:" + n2);
                }
            }
        }
        ArrayList<EditProperty> arrayList = new ArrayList<EditProperty>(this.excluded_.length + 1);
        if (this.include_ == null) {
            object = this.composeDeleteCommandName(this.target_, this.excluded_);
            if (!((String)object).equals("")) {
                this.setDisplayName(LB_DELETE_NAME.get(object));
            }
        } else {
            if (this.target_.getNode().contains(this.include_.sgfId())) {
                this.setDisplayName(LB_EDIT_NAME.get((Object)this.include_.sgfId().displayName()));
            } else {
                this.setDisplayName(LB_ADD_NAME.get((Object)this.include_.sgfId().displayName()));
            }
            arrayList.add(new EditProperty(this.target_.getNode(), this.include_, EditProperty.ADD_OR_REPLACE));
            if (editableNodeList.size() == 1 && this.include_.sgfId().equals(SgfId.GAME_TYPE) && this.include_.getStrings()[0].equals(GameType.DRILL.getString())) {
                object = new Node(SgfId.PROBLEM_PROPERTIES.makeProperty(new ProblemProperties(0)));
                AddNode addNode = new AddNode((Node)object);
                addNode.setEditableNodeList(editableNodeList);
                this.addNode_ = addNode;
            }
        }
        for (int i = 0; i < this.excluded_.length; ++i) {
            arrayList.add(new EditProperty(this.target_.getNode(), this.excluded_[i], EditProperty.DELETE));
        }
        this.editProperties_ = arrayList.toArray(new EditProperty[arrayList.size()]);
        this.setExecutedNodeIndex(editableNodeList.getPositionIndex());
        this.setUndoneNodeIndex(editableNodeList.getPositionIndex());
        return true;
    }

    private String composeDeleteCommandName(NodeEntity nodeEntity, Property[] propertyArray) {
        for (int i = 0; i < propertyArray.length; ++i) {
            Property property = nodeEntity.getNode().getProperty(propertyArray[i].sgfId());
            if (property == null || !property.sgfId().equals(propertyArray[i].sgfId())) continue;
            return propertyArray[i].sgfId().displayName();
        }
        return "";
    }

    @Override
    public void execute() {
        super.execute();
        HashSet<SgfId> hashSet = new HashSet<SgfId>(this.editProperties_.length);
        for (EditProperty editProperty : this.editProperties_) {
            editProperty.execute();
            hashSet.add(editProperty.getSgfId());
        }
        this.addNode_.execute();
        this.hasRgtInfluence_ = this.getEditableNodeList().refresh(hashSet);
        if (!this.hasRgtInfluence_) {
            this.target_.update();
        }
    }

    @Override
    public void undo() {
        super.undo();
        this.addNode_.undo();
        HashSet<SgfId> hashSet = new HashSet<SgfId>(this.editProperties_.length);
        for (EditProperty editProperty : this.editProperties_) {
            editProperty.undo();
            hashSet.add(editProperty.getSgfId());
        }
        this.hasRgtInfluence_ = this.getEditableNodeList().refresh(hashSet);
        if (!this.hasRgtInfluence_) {
            this.target_.update();
        }
    }

    @Override
    public EnumSet<ModelInfluence> getInfluence() {
        return this.influences_;
    }
}

