/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.util.EnumSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.unitarou.jface.UTitleAreaDialog;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.Application;
import org.unitarou.sgf.type.Handicap;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.RootGameTreeFactory;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.ChangeEditModeCommand;
import org.unitarou.yukinoshita.view.cmd.ChangeHandlerPhaseCommand;
import org.unitarou.yukinoshita.view.cmd.GameChangeCommand;
import org.unitarou.yukinoshita.view.jface.board.eh.ver1.HandlerPhaseVer1;
import org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;

public class NewGameFileAction
extends Action {
    private static final MessageResource NT_DLG_TITLE = new MessageResource(NewGameFileAction.class, "ntDlgTitle");
    private static final MessageResource MSG_INSTRACTION = new MessageResource(NewGameFileAction.class, "msgInstraction");
    private final SgfSize sgfSize_;
    private final Handicap handicap_;
    private WindowController controller_;

    public NewGameFileAction(SgfSize sgfSize, int n) {
        ArgumentChecker.throwIfNull((Object)sgfSize);
        ArgumentChecker.throwIfNegative(n);
        this.sgfSize_ = sgfSize;
        this.handicap_ = new Handicap(n);
        this.controller_ = null;
        this.setText(this.handicap_.displayName());
    }

    public NewGameFileAction setController(WindowController windowController) {
        ArgumentChecker.throwIfNull((Object)windowController);
        this.controller_ = windowController;
        return this;
    }

    public void run() {
        Object object;
        RootGameTree rootGameTree = RootGameTreeFactory.createGame(this.sgfSize_, this.handicap_);
        rootGameTree.setApplication(Application.create(Yukinoshita.instance().getName(), Yukinoshita.instance().getVersion()));
        GameFrameController gameFrameController = null;
        if (this.controller_.getGameFrameControllers().length != 0) {
            object = new SelectTargetFileDialog(Display.getCurrent().getActiveShell(), EnumSet.of(SelectTargetFileDialog.Type.PERMITS_NEW_FILE, SelectTargetFileDialog.Type.PERMITS_GAME));
            ((UTitleAreaDialog)object).setShellTitle(NT_DLG_TITLE.get());
            ((UTitleAreaDialog)object).setTitle(MSG_INSTRACTION.get());
            int n = ((Window)object).open();
            if (n == 1) {
                return;
            }
            gameFrameController = ((SelectTargetFileDialog)object).getTarget();
        }
        if (gameFrameController == null) {
            object = new Collection();
            ((Collection)object).addLast(rootGameTree);
            this.controller_.register((Collection)object, BasicMessages.LB_NEW_FILE.get(), false);
            EventBroker eventBroker = this.controller_.getActive().getEventBroker();
            eventBroker.executeCommand(new ChangeEditModeCommand(true));
            eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhaseVer1.MOVE));
            return;
        }
        object = gameFrameController.getCollectionEditor();
        ((CollectionEditor)object).createGame(rootGameTree);
        for (CollectionMonitor collectionMonitor : gameFrameController.getEventBroker().getListeners(CollectionMonitor.class)) {
            collectionMonitor.update((CollectionEditor)object);
        }
        EventBroker eventBroker = gameFrameController.getEventBroker();
        eventBroker.executeCommand(new GameChangeCommand(((CollectionEditor)object).size() - 1));
        eventBroker.executeCommand(new ChangeEditModeCommand(true));
        eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhaseVer1.MOVE));
    }
}

