/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.unitarou.lang.Objects;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfDouble;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.sgf.util.provider.plp.BasicPropertyLabelProvider;
import org.unitarou.sgf.util.provider.plp.PropertyLabelProvider;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.act.AbstractAction;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetPositionValueAction
extends AbstractAction
implements Adaptable {
    private static final Set<Property> exclusives_s_;
    private static final MessageResource LB_ADD;
    private static final MessageResource LB_REMOVE;
    private static final MessageResource CLB_NO_VALUE;
    private final Adapter adapter_ = new Adapter();
    private final Property property_;
    private PropertyLabelProvider provider_;
    private final Property[] exclusives_;
    private GameType gameType_;
    private boolean isAddMode_;
    private SgfColor playerColor_;

    public SetPositionValueAction(WindowController windowController, Property property) {
        super(windowController);
        this.property_ = property == null ? null : new Property(property);
        this.provider_ = new BasicPropertyLabelProvider();
        this.controller_.addListener(this.adapter_);
        this.gameType_ = GameType.GAME;
        HashSet<Property> hashSet = new HashSet<Property>(exclusives_s_);
        if (this.property_ == null) {
            this.isAddMode_ = false;
            this.setText(CLB_NO_VALUE.get());
            hashSet.add(SgfId.HOTSPOT.makeProperty(SgfDouble.EMPHASIZED));
            hashSet.add(SgfId.HOTSPOT.makeProperty(SgfDouble.NORMAL));
        } else {
            if (this.property_.sgfId().valueType() != ValueType.DOUBLE) {
                throw new IllegalArgumentException();
            }
            this.isAddMode_ = true;
            this.updateText();
            if (hashSet.remove(this.property_)) {
                hashSet.remove(this.property_.sgfId().makeProperty(SgfDouble.EMPHASIZED));
                hashSet.remove(this.property_.sgfId().makeProperty(SgfDouble.NORMAL));
            } else {
                hashSet.clear();
            }
        }
        this.exclusives_ = hashSet.toArray(new Property[hashSet.size()]);
        this.playerColor_ = null;
        this.setEnabled(false);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public void run() {
        UpdateProperty updateProperty = this.isAddMode_ || this.property_ == null ? new UpdateProperty(this.exclusives_, this.property_, null) : new UpdateProperty(new Property[]{this.property_}, null, null);
        this.controller_.getActive().getEventBroker().executeCommand(updateProperty);
    }

    private void updateText() {
        if (this.property_ == null) {
            this.setText(CLB_NO_VALUE.get());
            return;
        }
        this.setText(this.isAddMode_ ? LB_ADD.get(this.property_.toSgf(), this.provider_.getLabel(this.gameType_, this.property_)) : LB_REMOVE.get(this.property_.toSgf(), this.provider_.getLabel(this.gameType_, this.property_)));
    }

    static {
        ArrayList<Property> arrayList = new ArrayList<Property>(8);
        arrayList.add(SgfId.GOOD_FOR_BLACK.makeProperty(SgfDouble.EMPHASIZED));
        arrayList.add(SgfId.GOOD_FOR_BLACK.makeProperty(SgfDouble.NORMAL));
        arrayList.add(SgfId.GOOD_FOR_WHITE.makeProperty(SgfDouble.EMPHASIZED));
        arrayList.add(SgfId.GOOD_FOR_WHITE.makeProperty(SgfDouble.NORMAL));
        arrayList.add(SgfId.EVEN_POSITION.makeProperty(SgfDouble.EMPHASIZED));
        arrayList.add(SgfId.EVEN_POSITION.makeProperty(SgfDouble.NORMAL));
        arrayList.add(SgfId.UNCLEAR_POS.makeProperty(SgfDouble.EMPHASIZED));
        arrayList.add(SgfId.UNCLEAR_POS.makeProperty(SgfDouble.NORMAL));
        exclusives_s_ = Collections.unmodifiableSet(new HashSet(arrayList));
        LB_ADD = new MessageResource(SetPositionValueAction.class, "lbAdd");
        LB_REMOVE = new MessageResource(SetPositionValueAction.class, "lbRemove");
        CLB_NO_VALUE = new MessageResource(SetPositionValueAction.class, "clbNoValue");
    }

    private class Adapter
    implements GameMonitor,
    NodeMonitor,
    ControllerStatusMonitor,
    WindowControllerListener {
        private Reference<GameFrameController> refGfc_ = new WeakReference<Object>(null);

        private Adapter() {
        }

        public void changeActive(GameFrameController gameFrameController) {
            GameFrameController gameFrameController2 = this.refGfc_.get();
            if (gameFrameController2 != null) {
                gameFrameController2.getEventBroker().removeView(SetPositionValueAction.this);
            }
            this.refGfc_ = new WeakReference<GameFrameController>(gameFrameController);
            if (gameFrameController != null) {
                gameFrameController.getEventBroker().addView(SetPositionValueAction.this);
                SetPositionValueAction.this.gameType_ = gameFrameController.getCollectionEditor().getActiveGame().getGameType();
            }
            this.update();
        }

        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            SetPositionValueAction.this.gameType_ = gameMediator.getGameType();
            this.currentChanged(gameMediator.getCurrentNodeView());
        }

        public void currentChanged(NodeView nodeView) {
            ArgumentChecker.throwIfNull((Object)nodeView);
            if (SetPositionValueAction.this.property_ == null) {
                SetPositionValueAction.this.isAddMode_ = false;
                SetPositionValueAction.this.setEnabled(false);
                for (Property property : SetPositionValueAction.this.exclusives_) {
                    if (null == nodeView.getProperty(property.sgfId())) continue;
                    SetPositionValueAction.this.setEnabled(true);
                }
                return;
            }
            Property property = nodeView.getProperty(SetPositionValueAction.this.property_.sgfId());
            SetPositionValueAction.this.isAddMode_ = property == null || !property.getString().equals(SetPositionValueAction.this.property_.getString());
            if (!GameType.PROBLEM.equals(SetPositionValueAction.this.gameType_)) {
                SetPositionValueAction.this.playerColor_ = null;
                this.update();
                return;
            }
            GameFrameController gameFrameController = this.refGfc_.get();
            RootGameTree rootGameTree = gameFrameController.getCollectionEditor().getActiveGame().getRootGameTree();
            SetPositionValueAction.this.playerColor_ = BasicFinder.firstMove(rootGameTree);
            if (SetPositionValueAction.this.playerColor_ != null) {
                this.update();
                return;
            }
            Property property2 = nodeView.findProperty(SgfId.PLAYER_TO_PLAY);
            if (property2 != null) {
                SetPositionValueAction.this.playerColor_ = SgfColor.parseQuietly(property2.getString());
            }
            this.update();
        }

        private void update() {
            EnumSet<GameType> enumSet = SetPositionValueAction.this.property_ == null ? EnumSet.of(SetPositionValueAction.this.gameType_) : SetPositionValueAction.this.property_.sgfId().gameTypes();
            GameFrameController gameFrameController = this.refGfc_.get();
            SetPositionValueAction.this.setEnabled(gameFrameController != null && gameFrameController.isEditMode() && enumSet.contains(SetPositionValueAction.this.gameType_));
            if (!enumSet.contains(SetPositionValueAction.this.gameType_)) {
                SetPositionValueAction.this.setText(BasicMessages.LB_NOT_IN_SERVICE.get());
                return;
            }
            if (SetPositionValueAction.this.property_ == null || !GameType.PROBLEM.equals(SetPositionValueAction.this.gameType_)) {
                SetPositionValueAction.this.updateText();
                return;
            }
            SgfColor sgfColor = SgfColor.getColor(SetPositionValueAction.this.property_.sgfId());
            if (!Objects.equalsIncludeNull(SetPositionValueAction.this.playerColor_, sgfColor)) {
                SetPositionValueAction.this.setText(BasicMessages.LB_NOT_IN_SERVICE.get());
                SetPositionValueAction.this.setEnabled(false);
            } else {
                SetPositionValueAction.this.updateText();
            }
        }

        public void setEditMode(boolean bl) {
            GameFrameController gameFrameController = this.refGfc_.get();
            this.currentChanged(gameFrameController.getCollectionEditor().getActiveGame().getNodeList().getCurrentNodeView());
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }
    }
}

