/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ann;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.USpinner;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.yukinoshita.view.jface.ann.Editor;

class RealEditor
extends Editor {
    private StackLayout stackLayout_;
    private USpinner spinner_;
    private Text text_;
    private final SgfId sgfId_;
    private final int min_;
    private final int max_;
    private final int digits_;
    private final int inc_;
    private final int page_;

    RealEditor(SgfId sgfId, int n, int n2, int n3, int n4, int n5) {
        this.sgfId_ = sgfId;
        this.min_ = n;
        this.max_ = n2;
        this.digits_ = n3;
        this.inc_ = n4;
        this.page_ = n5;
    }

    public Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.stackLayout_ = new StackLayout();
        composite2.setLayout(this.stackLayout_);
        this.createSpinnerEditor(composite2);
        this.createTextEditor(composite2);
        this.stackLayout_.topControl = this.spinner_;
        return composite2;
    }

    private Control createSpinnerEditor(Composite composite) {
        this.spinner_ = new USpinner(composite, 2048);
        this.spinner_.setMinimum(this.min_);
        this.spinner_.setMaximum(this.max_);
        this.spinner_.setDigits(this.digits_);
        this.spinner_.setIncrement(this.inc_);
        this.spinner_.setPageIncrement(this.page_);
        this.spinner_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                RealEditor.this.fireModifyText(RealEditor.this.spinner_, RealEditor.this);
            }
        });
        return this.spinner_;
    }

    private Control createTextEditor(Composite composite) {
        this.text_ = new Text(composite, 2052);
        this.text_.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                RealEditor.this.fireModifyText(RealEditor.this.text_, RealEditor.this);
            }
        });
        return this.text_;
    }

    public void dispose() {
    }

    void setProperty(Property property) {
        String string;
        if (property == null) {
            this.stackLayout_.topControl = this.spinner_;
            return;
        }
        String string2 = property.getString();
        String string3 = string = this.stackLayout_.topControl == this.text_ ? this.text_.getText() : this.spinner_.getText();
        if (string2.equals(string)) {
            return;
        }
        try {
            double d = Double.parseDouble(string2);
            this.spinner_.setSelection((int)(d * Math.pow(10.0, this.spinner_.getDigits())));
            this.stackLayout_.topControl = this.spinner_;
        }
        catch (NumberFormatException numberFormatException) {
            this.text_.setText(string2);
            this.stackLayout_.topControl = this.text_;
        }
        this.stackLayout_.topControl.getParent().layout();
    }

    void setEditable(boolean bl) {
        this.spinner_.setEnabled(bl);
        this.text_.setEditable(bl);
    }

    SgfId getSgfId() {
        return this.sgfId_;
    }

    String getDatum() {
        String string;
        if (this.stackLayout_.topControl == this.text_) {
            return this.text_.getText();
        }
        if (this.spinner_.getDigits() == 0) {
            string = String.valueOf(this.spinner_.getSelection());
        } else {
            double d = (double)this.spinner_.getSelection() / Math.pow(10.0, this.spinner_.getDigits());
            string = String.valueOf(d);
        }
        return string;
    }
}

