/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.sp;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.unitarou.jface.ColorResource;
import org.unitarou.jface.FontResource;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.swt.Rectangles;
import org.unitarou.swt.Swts;
import org.unitarou.yukinoshita.view.jface.board.sp.AbstractStonePainter;

public class SolidStoneVer1Painter
extends AbstractStonePainter {
    private static final MessageResource LB_DISPLAY_NAME = new MessageResource(SolidStoneVer1Painter.class, "lbDisplayName");
    private static final ColorResource COLOR_WHITE_BODY = new ColorResource(255, 255, 255);
    private static final ColorResource COLOR_BLACK_BODY = new ColorResource(0, 0, 0);
    private static final ColorResource COLOR_WHITE_LABEL = new ColorResource(0, 0, 0);
    private static final ColorResource COLOR_BLACK_LABEL = new ColorResource(255, 255, 255);
    private static final ColorResource COLOR_LAST_LABEL = new ColorResource(255, 0, 0);
    private static final ColorResource COLOR_LAST = new ColorResource(204, 0, 0);
    private static final FontResource FONT_MOVE_NUMBER = new FontResource("Helvetica", 10, 1);

    public String displayName() {
        return LB_DISPLAY_NAME.get();
    }

    protected ImageData createWhiteStone(Point point) {
        return this.createStoneImage(point, COLOR_WHITE_BODY.get(), 190);
    }

    protected ImageData createBlackStone(Point point) {
        return this.createStoneImage(point, COLOR_BLACK_BODY.get(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageData createStoneImage(Point point, Color color, int n) {
        ImageData imageData;
        Image image = null;
        GC gC = null;
        try {
            image = new Image(null, point.x, point.y);
            gC = new GC(image);
            gC.setBackground(COLOR_TRANSPARENT.get());
            gC.fillRectangle(image.getBounds());
            gC.setBackground(color);
            gC.fillOval(0, 0, point.x, point.y);
            int n2 = -1;
            int n3 = point.x;
            int n4 = n3 / 2;
            for (double d = (double)n4; d >= 1.0; d -= 1.0) {
                int n5 = (int)((double)n4 - d);
                int n6 = (int)((double)n5 / (double)n3 * 160.0 + (double)n);
                if (255 < n6) {
                    n6 = 255;
                }
                if (n2 == -1) {
                    n2 = n6;
                }
                Color color2 = new Color(Display.getCurrent(), n6, n6, n6);
                gC.setForeground(color2);
                gC.setBackground(color2);
                double d2 = (int)((double)n5 * 0.75);
                double d3 = (double)n3 - (double)(n5 * 4) / 3.0;
                int n7 = (int)d2;
                int n8 = (int)(d3 - d2);
                gC.fillOval(n7, n7, n8, n8);
                color2.dispose();
            }
            gC.setLineWidth(1);
            gC.setLineStyle(1);
            Color color3 = new Color(Display.getCurrent(), n2, n2, n2);
            gC.setForeground(color3);
            gC.drawOval(0, 0, point.x - 1, point.y - 1);
            color3.dispose();
            ImageData imageData2 = image.getImageData();
            imageData2.transparentPixel = imageData2.getPixel(0, 0);
            imageData = imageData2;
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(gC);
            Swts.disposeQuietly(image);
            throw throwable;
        }
        Swts.disposeQuietly(gC);
        Swts.disposeQuietly(image);
        return imageData;
    }

    protected void paintLabel(GC gC, Rectangle rectangle, String string, SgfColor sgfColor, boolean bl) {
        gC.setFont(FONT_MOVE_NUMBER.getInCircle(gC, string, rectangle.width));
        Point point = gC.textExtent(string);
        Color color = bl ? COLOR_LAST_LABEL.get() : (SgfColor.BLACK.equals(sgfColor) ? COLOR_BLACK_LABEL.get() : COLOR_WHITE_LABEL.get());
        gC.setForeground(color);
        gC.drawText(string, rectangle.x + rectangle.width / 2 - point.x / 2, rectangle.y + rectangle.height / 2 - point.y / 2, true);
    }

    protected void paintLastMoveMark(GC gC, Rectangle rectangle, SgfColor sgfColor) {
        gC.setLineWidth(2);
        gC.setLineStyle(1);
        gC.setBackground(COLOR_LAST.get());
        Rectangle rectangle2 = Rectangles.createScaled(rectangle, 0.4);
        gC.fillOval(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }
}

