/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.io.Ios;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.FileContextValue;
import org.unitarou.yukinoshita.view.jface.dlg.ExplorerLikeFileChooser;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser;
import org.unitarou.yukinoshita.view.jface.dlg.NamedFileFilter;
import org.unitarou.yukinoshita.view.jface.dlg.SwtFileChooser;
import org.unitarou.yukinoshita.view.provider.rgtlp.GreedyRgtLabelProvider;

public class IgoFileDialog {
    private static final MessageResource NT_FILE_OPEN = new MessageResource(IgoFileDialog.class, "ntFileOpen");
    private static final MessageResource NT_FILE_OPEN_MULTI = new MessageResource(IgoFileDialog.class, "ntFileOpenMulti");
    private static final MessageResource NT_FILE_SAVE = new MessageResource(IgoFileDialog.class, "ntFileSave");
    private static final MessageResource NT_CONFIRM_OVERWRITE = new MessageResource(IgoFileDialog.class, "ntConfirmOverwrite");
    private static final MessageResource MSG_FILE_IS_EXISTS_OVERWRITE = new MessageResource(IgoFileDialog.class, "msgFileIsExistsOverwrite");
    private static final MessageResource CLB_OVERWRITE = new MessageResource(IgoFileDialog.class, "clbOverwrite");
    private static final MessageResource CLB_SAVE_ANOTHER_NAME = new MessageResource(IgoFileDialog.class, "clbSaveAnotherName");
    private static final MessageResource NT_BAD_ASSIGN = new MessageResource(IgoFileDialog.class, "ntBadAssign");
    private static final MessageResource MSG_ASSIGN_NO_DIRECTORY = new MessageResource(IgoFileDialog.class, "msgAssignNoDirectory");
    private static final MessageResource MSG_ASSIGN_WRITABLE = new MessageResource(IgoFileDialog.class, "msgAssignWritable");
    private static final MessageResource NT_FILTER_SGF = new MessageResource(IgoFileDialog.class, "ntFilterSgf");
    private static final MessageResource NT_FILTER_ALL = new MessageResource(IgoFileDialog.class, "ntFilterAll");
    private static final String FILE_FILTER_SGF = "*.sgf";
    private static final String FILE_FILTER_ALL = "*.*";
    private static final FileContextValue CURRENT_FOLDER = new FileContextValue(IgoFileDialog.class, "currentFolder", Ios.getCurrentDirectory());
    private IgoFileChooser fileDialog_;
    private final Shell parent_;
    private final IgoFileChooser.Style style_;
    private final CurrentContext context_;
    private String filename_;
    private File currentDirectory_;

    public static File askSaveFile(Collection collection) {
        File file;
        Object object;
        ArgumentChecker.throwIfNull((Object)collection);
        File file2 = collection.getFile();
        if (file2 == null) {
            file2 = Ios.getCurrentDirectory();
            object = new GreedyRgtLabelProvider().getLabel(collection.get(0));
            file2 = new File(file2, (String)object + '.' + "sgf");
        }
        while (true) {
            object = new IgoFileDialog(Display.getCurrent().getActiveShell(), IgoFileChooser.Style.SAVE_FILE);
            ((IgoFileDialog)object).setFolder(file2);
            if (!((IgoFileDialog)object).open()) {
                return null;
            }
            file = ((IgoFileDialog)object).getFile();
            if (!Ios.isTemporaryFile(file)) break;
            Yukinoshita.application().openMessageDialog(Application.MessageLevel.WARNING, BasicMessages.NT_FILE_SAVE_FAILURE.get(), Ios.MSG_CANT_WRITE_TO_TMP_FILE.get((Object)file.getAbsolutePath()));
        }
        return file;
    }

    public IgoFileDialog(Shell shell) {
        this(shell, IgoFileChooser.Style.OPEN_FILE);
    }

    public IgoFileDialog(Shell shell, IgoFileChooser.Style style) {
        ArgumentChecker.throwIfNull((Object)shell, (Object)style);
        this.fileDialog_ = null;
        this.parent_ = shell;
        this.style_ = style;
        this.context_ = Yukinoshita.context().getCurrent(null);
        this.filename_ = "";
        this.currentDirectory_ = this.context_.getFile(CURRENT_FOLDER);
    }

    public boolean open() {
        boolean bl;
        if (this.style_.equals((Object)IgoFileChooser.Style.SAVE_FILE)) {
            bl = this.openAsSave();
        } else {
            this.createFileDialog();
            bl = this.fileDialog_.chooseFile();
        }
        if (bl) {
            this.context_.setFile(CURRENT_FOLDER.id(), this.fileDialog_.getFolder());
        }
        return bl;
    }

    private boolean openAsSave() {
        while (true) {
            this.createFileDialog();
            boolean bl = this.fileDialog_.chooseFile();
            if (!bl) {
                return bl;
            }
            this.context_.setFile(CURRENT_FOLDER.id(), this.fileDialog_.getFolder());
            File file = this.fileDialog_.getFile();
            file = this.checkExtension(file);
            this.fileDialog_.setFile(file);
            if (!file.exists()) {
                return true;
            }
            if (file.isDirectory()) {
                MessageDialog.openInformation(this.fileDialog_.getParent(), NT_BAD_ASSIGN.get(), MSG_ASSIGN_NO_DIRECTORY.get((Object)this.fileDialog_.getFile().getAbsolutePath()));
                continue;
            }
            if (!file.canWrite()) {
                MessageDialog.openInformation(this.fileDialog_.getParent(), NT_BAD_ASSIGN.get(), MSG_ASSIGN_WRITABLE.get((Object)this.fileDialog_.getFile().getAbsolutePath()));
                continue;
            }
            MessageDialog messageDialog = new MessageDialog(this.fileDialog_.getParent(), NT_CONFIRM_OVERWRITE.get(), null, MSG_FILE_IS_EXISTS_OVERWRITE.get((Object)this.fileDialog_.getFile().getAbsolutePath()), 3, new String[]{CLB_OVERWRITE.get(), CLB_SAVE_ANOTHER_NAME.get()}, 1);
            if (messageDialog.open() == 0) break;
        }
        return true;
    }

    private File checkExtension(File file) {
        String string;
        if (Yukinoshita.context().getCurrent(null).getBoolean(Context.APPEND_SGF_EXTENSION_IN_SAVE) && !(string = FilenameUtils.getExtension(file.getName())).equalsIgnoreCase("sgf")) {
            file = new File(file.getAbsolutePath() + "." + "sgf");
        }
        return file;
    }

    private void createFileDialog() {
        Context.FileDialogStyle fileDialogStyle = (Context.FileDialogStyle)((Object)Yukinoshita.context().getAttribute(Context.FILE_DIALOG_STYLE.id(), null));
        switch (fileDialogStyle) {
            case OS: {
                this.fileDialog_ = new SwtFileChooser(this.parent_, this.style_);
                break;
            }
            case ORIGINAL: {
                this.fileDialog_ = new ExplorerLikeFileChooser(this.parent_, this.style_);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.fileDialog_.setFileName(this.filename_);
        this.fileDialog_.setFolder(this.currentDirectory_);
        NamedFileFilter[] namedFileFilterArray = new NamedFileFilter[]{new NamedFileFilter(FILE_FILTER_SGF, NT_FILTER_SGF.get()), new NamedFileFilter(FILE_FILTER_ALL, NT_FILTER_ALL.get())};
        this.fileDialog_.setFilter(namedFileFilterArray);
        switch (this.style_) {
            case OPEN_FILE: {
                this.fileDialog_.setText(NT_FILE_OPEN.get());
                break;
            }
            case OPEN_FILES: {
                this.fileDialog_.setText(NT_FILE_OPEN_MULTI.get());
                break;
            }
            case SAVE_FILE: {
                this.fileDialog_.setText(NT_FILE_SAVE.get());
                break;
            }
            default: {
                throw new RuntimeException("Bad style:" + (Object)((Object)this.style_));
            }
        }
    }

    public File getFile() {
        return this.fileDialog_.getFile();
    }

    public File[] getFiles() {
        return this.fileDialog_.getFiles();
    }

    public void setFolder(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        while (!file.isDirectory()) {
            this.filename_ = file.getName();
            if ((file = file.getParentFile()) != null) continue;
            return;
        }
        this.currentDirectory_ = file;
    }
}

