/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.jface.UTitleAreaDialog;
import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.provider.clp.ForFileNameCollectionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectTargetFileDialog
extends UTitleAreaDialog {
    private static final MessageResource LB_NEW_FILE = new MessageResource(SelectTargetFileDialog.class, "lbNewFile");
    private static final MessageResource LB_UNSAVED = new MessageResource(SelectTargetFileDialog.class, "lbUnsaved");
    private static final MessageResource LB_EDIT_MODE_ONLY = new MessageResource(SelectTargetFileDialog.class, "lbEditModeOnly");
    private static final MessageResource NT_YOU_CAN_SELECT_THESE_FILES = new MessageResource(SelectTargetFileDialog.class, "ntYouCanSelectTheseFiles");
    private static final String TYPE_SEPARATOR = "/";
    private EnumSet<Type> typeSet_;
    private GameFrameController target_;
    private String targetCategoryCaption_;

    public SelectTargetFileDialog(Shell shell) {
        this(shell, EnumSet.of(Type.PERMITS_NEW_FILE));
    }

    public SelectTargetFileDialog(Shell shell, EnumSet<Type> enumSet) {
        super(shell);
        ArgumentChecker.throwIfNull(enumSet);
        this.setShellStyle(32816);
        this.typeSet_ = EnumSet.copyOf(enumSet);
        this.target_ = null;
        this.targetCategoryCaption_ = "";
    }

    @Override
    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.setMessage(this.composeMessage());
        return control;
    }

    private String composeMessage() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = string = this.typeSet_.contains((Object)Type.PERMITS_NO_EDIT_MODE) ? "" : LB_EDIT_MODE_ONLY.get();
        if (this.typeSet_.contains((Object)Type.PERMITS_NEW_FILE)) {
            stringBuilder.append(LB_NEW_FILE.get()).append(TYPE_SEPARATOR);
        }
        if (this.typeSet_.contains((Object)Type.PERMITS_GAME)) {
            stringBuilder.append(GameType.GAME.displayName()).append(string).append(TYPE_SEPARATOR);
        }
        if (this.typeSet_.contains((Object)Type.PERMITS_PROBLEM)) {
            stringBuilder.append(GameType.PROBLEM.displayName()).append(string).append(TYPE_SEPARATOR);
        }
        if (this.typeSet_.contains((Object)Type.PERMITS_DRILL)) {
            stringBuilder.append(GameType.DRILL.displayName()).append(string).append(TYPE_SEPARATOR);
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.delete(stringBuilder.length() - TYPE_SEPARATOR.length(), stringBuilder.length());
            stringBuilder.insert(0, Strings.LINE_SEPARATOR).insert(0, NT_YOU_CAN_SELECT_THESE_FILES.get());
        }
        return stringBuilder.toString();
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Group group = new Group(composite2, 16);
        group.setLayout(new RowLayout(512));
        group.setText(this.targetCategoryCaption_);
        ButtonSelected buttonSelected = new ButtonSelected();
        if (this.typeSet_.contains((Object)Type.PERMITS_NEW_FILE)) {
            Button button = new Button(group, 16);
            button.setText(LB_NEW_FILE.get());
            button.setData(null);
            button.addSelectionListener(buttonSelected);
        }
        boolean bl = this.typeSet_.contains((Object)Type.PERMITS_NO_EDIT_MODE);
        ForFileNameCollectionProvider forFileNameCollectionProvider = new ForFileNameCollectionProvider();
        for (GameFrameController gameFrameController : this.findTargets()) {
            Button button = new Button(group, 16);
            button.setData(gameFrameController);
            button.setEnabled(bl || gameFrameController.isEditMode());
            button.addSelectionListener(buttonSelected);
            File file = gameFrameController.getCollection().getFile();
            if (file == null) {
                button.setText(LB_UNSAVED.get((Object)forFileNameCollectionProvider.getLabel(gameFrameController.getCollection())));
                continue;
            }
            button.setText(file.getName());
        }
        return composite2;
    }

    private GameFrameController[] findTargets() {
        ArrayList<GameFrameController> arrayList = new ArrayList<GameFrameController>();
        for (WindowController windowController : Yukinoshita.application().getAllController()) {
            GameFrameController[] gameFrameControllerArray;
            block1: for (GameFrameController gameFrameController : gameFrameControllerArray = windowController.getGameFrameControllers()) {
                Collection collection = gameFrameController.getCollection();
                if (collection.size() == 0) continue;
                GameType gameType = collection.get(0).getGameType();
                if (GameType.DRILL.equals(gameType)) {
                    if (!this.typeSet_.contains((Object)Type.PERMITS_DRILL)) continue;
                    arrayList.add(gameFrameController);
                    continue;
                }
                for (RootGameTree rootGameTree : collection) {
                    if (GameType.GAME.equals(rootGameTree.getGameType()) && this.typeSet_.contains((Object)Type.PERMITS_GAME)) {
                        arrayList.add(gameFrameController);
                        continue block1;
                    }
                    if (!GameType.PROBLEM.equals(rootGameTree.getGameType()) || !this.typeSet_.contains((Object)Type.PERMITS_PROBLEM)) continue;
                    arrayList.add(gameFrameController);
                    continue block1;
                }
            }
        }
        return arrayList.toArray(new GameFrameController[arrayList.size()]);
    }

    public void setTargetCategoryCaption(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        this.targetCategoryCaption_ = string;
    }

    public GameFrameController getTarget() {
        return this.target_;
    }

    private class ButtonSelected
    extends SelectionAdapter {
        private ButtonSelected() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            SelectTargetFileDialog.this.target_ = (GameFrameController)selectionEvent.widget.getData();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PERMITS_NO_EDIT_MODE,
        PERMITS_NEW_FILE,
        PERMITS_GAME,
        PERMITS_PROBLEM,
        PERMITS_DRILL;

    }
}

