/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gm;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.swt.Layouts;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.cmd.ChangeEditModeCommand;
import org.unitarou.yukinoshita.view.cmd.GameChangeCommand;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameChooserPanel
implements Adaptable,
WidgetContainer {
    private static final MessageResource LB_GAME = new MessageResource(GameChooserPanel.class, "lbGame");
    private static final MessageResource LB_EDIT = new MessageResource(GameChooserPanel.class, "lbEdit");
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private CollectionEditor collectionEditor_ = null;
    private Combo gameCombo_ = null;
    private Label label_ = null;
    private Button checkButton_ = null;
    private final Adapter adapter_ = new Adapter();

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new FillLayout(512));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout(Layouts.createForm(0, 0, 0));
        this.createLabel(composite3);
        this.gameCombo_ = this.createCombo(composite3, this.label_);
        this.createEditCheckButton(composite2);
        return composite2;
    }

    private void createLabel(Composite composite) {
        this.label_ = new Label(composite, 0x1000000);
        FormData formData = Layouts.createSpreadFormData(0);
        formData.top = null;
        formData.right = null;
        this.label_.setLayoutData(formData);
    }

    private Combo createCombo(Composite composite, Control control) {
        Combo combo = new Combo(composite, 12);
        combo.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GameChooserPanel.this.fireGameChangeEvent();
            }
        });
        combo.setVisibleItemCount(10);
        FormData formData = Layouts.createSpreadFormData(0);
        formData.left = new FormAttachment(control);
        combo.setLayoutData(formData);
        return combo;
    }

    private void createEditCheckButton(Composite composite) {
        this.checkButton_ = new Button(composite, 0x800020);
        this.checkButton_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GameChooserPanel.this.fireEditModeChageEvent(GameChooserPanel.this.checkButton_.getSelection());
            }
        });
    }

    @Override
    public void dispose() {
        this.eventBroker_ = EventBroker.NULL_BROKER;
        this.gameCombo_.dispose();
        this.checkButton_.dispose();
    }

    public void setEventBroker(EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)eventBroker);
        this.eventBroker_ = eventBroker;
        this.eventBroker_.addView(this);
    }

    private void fireGameChangeEvent() {
        GameChangeCommand gameChangeCommand = new GameChangeCommand(this.gameCombo_.getSelectionIndex());
        this.eventBroker_.executeCommand(gameChangeCommand);
    }

    private void fireEditModeChageEvent(boolean bl) {
        this.eventBroker_.executeCommand(new ChangeEditModeCommand(bl));
    }

    private class Adapter
    implements ModelEventNotifier,
    ControllerStatusMonitor,
    CollectionMonitor,
    GameMonitor,
    GameInfoNodeMonitor {
        private Adapter() {
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            GameChooserPanel.this.eventBroker_.removeView(GameChooserPanel.this);
            GameChooserPanel.this.eventBroker_ = eventBroker;
            GameChooserPanel.this.eventBroker_.addView(GameChooserPanel.this);
        }

        public void setEditMode(boolean bl) {
            GameChooserPanel.this.checkButton_.setSelection(bl);
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }

        public void update(CollectionEditor collectionEditor) {
            ArgumentChecker.throwIfNull((Object)collectionEditor);
            GameChooserPanel.this.collectionEditor_ = collectionEditor;
            RootGameTreeLabelProvider rootGameTreeLabelProvider = this.getLabelProvider();
            Collection collection = GameChooserPanel.this.collectionEditor_.getCollection();
            String[] stringArray = new String[collection.size()];
            if (collection.get(0).getGameType().equals(GameType.DRILL)) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = rootGameTreeLabelProvider.getLabel(collection.get(0));
                }
                GameChooserPanel.this.gameCombo_.setEnabled(false);
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = this.makeRgtLabel(rootGameTreeLabelProvider, i, collection.get(i));
                }
                GameChooserPanel.this.gameCombo_.setEnabled(true);
            }
            GameChooserPanel.this.gameCombo_.setItems(stringArray);
            if (0 < stringArray.length) {
                GameChooserPanel.this.gameCombo_.select(GameChooserPanel.this.collectionEditor_.getActiveGameIndex());
            }
        }

        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            String string = gameMediator.getGameType().displayName();
            GameChooserPanel.this.checkButton_.setText(LB_EDIT.get((Object)string));
            GameChooserPanel.this.label_.setText(LB_GAME.get((Object)string));
            int n = GameChooserPanel.this.collectionEditor_.getActiveGameIndex();
            RootGameTree rootGameTree = gameMediator.getRootGameTree();
            RootGameTreeLabelProvider rootGameTreeLabelProvider = this.getLabelProvider();
            GameChooserPanel.this.gameCombo_.setItem(n, this.makeRgtLabel(rootGameTreeLabelProvider, n, rootGameTree));
            GameChooserPanel.this.gameCombo_.select(n);
            GameChooserPanel.this.label_.getParent().layout(true, true);
        }

        public void gameInfoChanged(NodeView nodeView) {
            RootGameTreeLabelProvider rootGameTreeLabelProvider = this.getLabelProvider();
            Collection collection = GameChooserPanel.this.collectionEditor_.getCollection();
            String[] stringArray = new String[collection.size()];
            if (collection.get(0).getGameType().equals(GameType.DRILL)) {
                if (GameChooserPanel.this.collectionEditor_.getActiveGameIndex() != 0) {
                    return;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = rootGameTreeLabelProvider.getLabel(collection.get(0));
                }
                GameChooserPanel.this.gameCombo_.setEnabled(false);
            } else {
                GameChooserPanel.this.gameCombo_.setItem(GameChooserPanel.this.collectionEditor_.getActiveGameIndex(), this.makeRgtLabel(rootGameTreeLabelProvider, GameChooserPanel.this.collectionEditor_.getActiveGameIndex(), GameChooserPanel.this.collectionEditor_.getActiveGame().getRootGameTree()));
            }
            if (0 < stringArray.length) {
                GameChooserPanel.this.gameCombo_.select(GameChooserPanel.this.collectionEditor_.getActiveGameIndex());
            }
        }

        private String makeRgtLabel(RootGameTreeLabelProvider rootGameTreeLabelProvider, int n, RootGameTree rootGameTree) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(n + 1).append(':');
            stringBuilder.append(rootGameTreeLabelProvider.getLabel(rootGameTree));
            return stringBuilder.toString();
        }

        private RootGameTreeLabelProvider getLabelProvider() {
            Collection collection = GameChooserPanel.this.collectionEditor_.getCollection();
            return Yukinoshita.context().getProvider(RootGameTreeLabelProvider.class, collection);
        }
    }
}

