/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gm;

import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.CommandFactory;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoteMemoPanel
implements Adaptable,
WidgetContainer {
    private static final MessageResource LB_NOTE = new MessageResource(NoteMemoPanel.class, "lbNote");
    private final boolean showNote_;
    private Composite frame_ = null;
    private NodeView nodeView_ = null;
    private Text nodeName_;
    private Text comment_;
    private EventBroker eventBroker_;
    private final Adapter adapter_;
    private boolean isModelUpdateMode_;

    public NoteMemoPanel() {
        this(true);
    }

    public NoteMemoPanel(boolean bl) {
        this.showNote_ = bl;
        this.eventBroker_ = EventBroker.NULL_BROKER;
        this.adapter_ = new Adapter();
        this.isModelUpdateMode_ = false;
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite composite) {
        this.frame_ = new Composite(composite, 0);
        this.frame_.setLayout(new FormLayout());
        this.createNote(this.frame_);
        this.createComment(this.frame_);
        return this.frame_;
    }

    private void createNote(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(LB_NOTE.get());
        label.setVisible(this.showNote_);
        this.nodeName_ = new Text(composite, 2048);
        this.nodeName_.setEditable(false);
        this.nodeName_.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                NoteMemoPanel.this.update(NoteMemoPanel.this.nodeName_.getText(), SgfId.NODENAME);
            }
        });
        this.nodeName_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NoteMemoPanel.this.checkAndUpdate(NoteMemoPanel.this.nodeName_.getText(), SgfId.NODENAME);
            }
        });
        this.nodeName_.setVisible(this.showNote_);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 2);
        formData.top = new FormAttachment(0, 2);
        label.setLayoutData(formData);
        FormData formData2 = new FormData();
        formData2.left = new FormAttachment(label, 2);
        formData2.top = new FormAttachment(0, 2);
        formData2.right = new FormAttachment(100, 2);
        this.nodeName_.setLayoutData(formData2);
    }

    private void createComment(Composite composite) {
        this.comment_ = new Text(composite, 2626);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(this.nodeName_, 2);
        formData.right = new FormAttachment(100, 2);
        formData.bottom = new FormAttachment(100, 2);
        this.comment_.setLayoutData(formData);
        this.comment_.setEditable(false);
        this.comment_.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                NoteMemoPanel.this.update(NoteMemoPanel.this.comment_.getText(), SgfId.COMMENT);
            }
        });
        this.comment_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NoteMemoPanel.this.checkAndUpdate(NoteMemoPanel.this.comment_.getText(), SgfId.COMMENT);
            }
        });
    }

    private void checkAndUpdate(String string, SgfId sgfId) {
        Property property = this.nodeView_.getProperty(sgfId);
        String string2 = property != null ? property.getString() : "";
        int n = Yukinoshita.context().getCurrent(null).getInteger(Context.CHAR_LENGTH_PER_UPDATE);
        if (n <= Strings.calcDiffSize(string2, string)) {
            this.update(string, sgfId);
        }
    }

    private void update(String string, SgfId sgfId) {
        if (this.isModelUpdateMode_) {
            return;
        }
        UpdateProperty updateProperty = CommandFactory.createUpdateProperty(string, sgfId, this.nodeView_, false);
        if (updateProperty != null) {
            this.eventBroker_.executeCommand(updateProperty);
        }
    }

    public Control getControl() {
        return this.frame_;
    }

    @Override
    public void dispose() {
        this.nodeName_.dispose();
        this.comment_.dispose();
        this.eventBroker_ = EventBroker.NULL_BROKER;
    }

    public void changeHandlerPhase(HandlerPhase handlerPhase) {
    }

    private class Adapter
    implements ModelEventNotifier,
    NodeMonitor,
    ControllerStatusMonitor {
        private Adapter() {
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            NoteMemoPanel.this.eventBroker_.removeView(NoteMemoPanel.this);
            NoteMemoPanel.this.eventBroker_ = eventBroker;
            NoteMemoPanel.this.eventBroker_.addView(NoteMemoPanel.this);
        }

        public void currentChanged(NodeView nodeView) {
            String string;
            ArgumentChecker.throwIfNull((Object)nodeView);
            NoteMemoPanel.this.isModelUpdateMode_ = true;
            NoteMemoPanel.this.nodeView_ = nodeView;
            Property property = NoteMemoPanel.this.nodeView_.getProperty(SgfId.COMMENT);
            String string2 = string = property == null ? "" : property.getString();
            if (!string.equals(NoteMemoPanel.this.comment_.getText())) {
                NoteMemoPanel.this.comment_.setText(string);
            }
            String string3 = string = (property = NoteMemoPanel.this.nodeView_.getProperty(SgfId.NODENAME)) == null ? "" : property.getString();
            if (!string.equals(NoteMemoPanel.this.nodeName_.getText())) {
                NoteMemoPanel.this.nodeName_.setText(string);
            }
            NoteMemoPanel.this.isModelUpdateMode_ = false;
        }

        public void setEditMode(boolean bl) {
            NoteMemoPanel.this.nodeName_.setEditable(bl);
            NoteMemoPanel.this.comment_.setEditable(bl);
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }
    }
}

