/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ns;

import java.util.EnumSet;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.unitarou.jface.ColorResource;
import org.unitarou.jface.ImageResource;
import org.unitarou.lang.Strings;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.swt.Swts;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.jface.resource.NodeImage;
import org.unitarou.yukinoshita.view.provider.nlp.NodeViewLabelProvider;

class NodeListLabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private static final ImageRegistry imageRegistry_s_ = JFaceResources.getImageRegistry();
    private static final ColorResource BACKGROUND = new ColorResource(25);
    private static final ColorResource MAIN_FONT = new ColorResource(24);
    private static final ColorResource[] VARIATIONS;
    private CoordinatesLabelProvider coordinatesLabelProvider_ = Yukinoshita.context().getProvider(CoordinatesLabelProvider.class, null);

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getColumnImage(Object object, int n) {
        Object object2;
        Object object32;
        if (!(object instanceof NodeView) || n != 1) {
            return null;
        }
        NodeView nodeView = (NodeView)object;
        EnumSet<NodeStatus> enumSet = EnumSet.noneOf(NodeStatus.class);
        if (nodeView.getProperty(SgfId.WHITE) != null) {
            enumSet.add(NodeStatus.WHITE_MOVE);
        } else if (nodeView.getProperty(SgfId.BLACK) != null) {
            enumSet.add(NodeStatus.BLACK_MOVE);
        }
        if (nodeView.variationSize() != 0) {
            enumSet.add(NodeStatus.HAS_VARIATION);
        }
        if (!nodeView.getInvalid().isEmpty()) {
            enumSet.add(NodeStatus.WARNING);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().toString()).append('/');
        for (Object object32 : enumSet) {
            stringBuilder.append(object32.name()).append(':');
        }
        String string = stringBuilder.toString();
        object32 = imageRegistry_s_.get(string);
        if (object32 != null) {
            return object32;
        }
        GC gC = null;
        try {
            object32 = new Image(null, 16, 16);
            gC = new GC((Drawable)object32);
            for (NodeStatus nodeStatus : enumSet) {
                gC.drawImage(nodeStatus.imageResource_.get(), 0, 0);
            }
            imageRegistry_s_.put(string, (Image)object32);
            object2 = object32;
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(gC);
            throw throwable;
        }
        Swts.disposeQuietly(gC);
        return object2;
    }

    public String getColumnText(Object object, int n) {
        if (!(object instanceof NodeView)) {
            return null;
        }
        NodeView nodeView = (NodeView)object;
        switch (n) {
            case 1: {
                return this.getMoveNumber(nodeView);
            }
            case 2: {
                return this.getMoveText(nodeView);
            }
            case 3: {
                return this.getTreeText(nodeView);
            }
        }
        return "";
    }

    private String getMoveNumber(NodeView nodeView) {
        Double d;
        StringBuilder stringBuilder = new StringBuilder();
        Integer n = nodeView.getMove().getNumber();
        if (n != null) {
            stringBuilder.append(n);
        }
        if ((d = nodeView.getMove().getTimeLapsed()) != null) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append('[').append(Strings.formatDuration(d.intValue())).append(']');
        }
        return stringBuilder.toString();
    }

    private String getMoveText(NodeView nodeView) {
        try {
            Property property = nodeView.getProperty(SgfId.WHITE);
            if (property != null) {
                SgfPoint sgfPoint = SgfPoint.parseMove(nodeView.getSize(), property.getString());
                return this.coordinatesLabelProvider_.getMoveLabel(sgfPoint);
            }
            property = nodeView.getProperty(SgfId.BLACK);
            if (property != null) {
                SgfPoint sgfPoint = SgfPoint.parseMove(nodeView.getSize(), property.getString());
                return this.coordinatesLabelProvider_.getMoveLabel(sgfPoint);
            }
        }
        catch (TypeParseException typeParseException) {
            typeParseException.printStackTrace();
        }
        return "";
    }

    private String getTreeText(NodeView nodeView) {
        return NodeViewLabelProvider.CONTEXT.defaultProvider().getLabel(nodeView);
    }

    public CoordinatesLabelProvider getProvider() {
        return this.coordinatesLabelProvider_;
    }

    public Color getForeground(Object object, int n) {
        return MAIN_FONT.get();
    }

    public Color getBackground(Object object, int n) {
        if (n == 0 || !(object instanceof NodeView)) {
            return BACKGROUND.get();
        }
        NodeView nodeView = (NodeView)object;
        int n2 = nodeView.getVariationHash();
        if (-1 == n2) {
            return BACKGROUND.get();
        }
        return VARIATIONS[n2 % VARIATIONS.length].get();
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }

    public boolean isLabelProperty(Object object, String string) {
        return false;
    }

    public void setProvider(CoordinatesLabelProvider coordinatesLabelProvider) {
        ArgumentChecker.throwIfNull((Object)coordinatesLabelProvider);
        this.coordinatesLabelProvider_ = coordinatesLabelProvider;
    }

    static {
        int[] nArray = new int[]{238, 221};
        int[] nArray2 = new int[]{238, 221};
        int[] nArray3 = new int[]{238, 221};
        VARIATIONS = new ColorResource[nArray.length * nArray2.length * nArray3.length - nArray.length];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray3.length; ++j) {
                for (int k = 0; k < nArray2.length; ++k) {
                    if (i == j && j == k) continue;
                    NodeListLabelProvider.VARIATIONS[n] = new ColorResource(nArray[i], nArray2[k], nArray3[j]);
                    ++n;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NodeStatus {
        WHITE_MOVE(NodeImage.WHITE),
        BLACK_MOVE(NodeImage.BLACK),
        HAS_VARIATION(NodeImage.VNONE),
        WARNING(NodeImage.WARNING);

        private final ImageResource imageResource_;

        private NodeStatus(ImageResource imageResource) {
            this.imageResource_ = imageResource;
        }
    }
}

