/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ns;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.cmd.NodeSelectionCommand;
import org.unitarou.yukinoshita.view.jface.ns.NodeListContentProvider;
import org.unitarou.yukinoshita.view.jface.ns.NodeListLabelProvider;
import org.unitarou.yukinoshita.view.monitor.ContextMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeListMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeListPanel
implements Adaptable,
WidgetContainer {
    private static final Log log_s_ = LogFactory.getLog(NodeListPanel.class);
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private NodeList nodeList_ = null;
    private TableViewer tableViewer_ = null;
    private final Adapter adapter_ = new Adapter();
    private boolean inRefresh_ = false;

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite composite) {
        this.tableViewer_ = new TableViewer(composite, 68356);
        this.tableViewer_.setContentProvider(new NodeListContentProvider());
        this.tableViewer_.setLabelProvider(new NodeListLabelProvider());
        Table table = this.tableViewer_.getTable();
        table.setHeaderVisible(false);
        new TableColumn(table, 0x1000000);
        new TableColumn(table, 131072);
        new TableColumn(table, 16384);
        new TableColumn(table, 16384);
        this.tableViewer_.setInput(null);
        this.tableViewer_.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                NodeListPanel.this.fireNodeSelected();
            }
        });
        MouseOnGroupListener mouseOnGroupListener = new MouseOnGroupListener();
        table.addListener(37, mouseOnGroupListener);
        table.addMouseTrackListener(mouseOnGroupListener);
        return table;
    }

    @Override
    public void dispose() {
    }

    private void packColumns() {
        TableColumn[] tableColumnArray = this.tableViewer_.getTable().getColumns();
        for (int i = 0; i < tableColumnArray.length; ++i) {
            tableColumnArray[i].pack();
        }
    }

    private void fireNodeSelected() {
        if (this.inRefresh_) {
            return;
        }
        int n = this.tableViewer_.getTable().getSelectionIndex();
        if (n == -1) {
            return;
        }
        NodeSelectionCommand nodeSelectionCommand = new NodeSelectionCommand(n);
        this.eventBroker_.executeCommand(nodeSelectionCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.inRefresh_ = true;
        this.tableViewer_.getTable().setRedraw(false);
        try {
            int n = this.tableViewer_.getTable().getSelectionIndex();
            for (int i = 0; i < this.nodeList_.size(); ++i) {
                this.tableViewer_.update(this.nodeList_.getNodeView(i), null);
            }
            this.packColumns();
            this.tableViewer_.getTable().setSelection(n);
        }
        finally {
            this.tableViewer_.getTable().setRedraw(true);
            this.inRefresh_ = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Adapter
    implements GameMonitor,
    NodeListMonitor,
    NodeMonitor,
    ModelEventNotifier,
    ContextMonitor {
        private CurrentContext context_ = CurrentContext.nullContext;

        private Adapter() {
        }

        @Override
        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            this.context_ = gameMediator.getContext();
            NodeList nodeList = gameMediator.getNodeList();
            if (nodeList != NodeListPanel.this.nodeList_) {
                NodeListPanel.this.nodeList_ = nodeList;
            } else {
                for (int i = 0; i < NodeListPanel.this.nodeList_.size(); ++i) {
                    NodeListPanel.this.tableViewer_.update(NodeListPanel.this.nodeList_.getNodeView(i), null);
                }
            }
            if (log_s_.isTraceEnabled()) {
                log_s_.trace("update(GameMediator gameMediator)" + gameMediator.toString());
            }
        }

        @Override
        public void update(NodeView[] nodeViewArray) {
            ArgumentChecker.throwIfNull((Object)nodeViewArray);
            for (NodeView nodeView : nodeViewArray) {
                this.currentChanged(nodeView);
            }
            if (log_s_.isTraceEnabled()) {
                log_s_.trace("update(NodeView[] nodeViews)" + nodeViewArray.toString());
            }
        }

        @Override
        public void currentChanged(NodeView nodeView) {
            int n;
            int n2;
            ArgumentChecker.throwIfNull((Object)nodeView);
            if (NodeListPanel.this.nodeList_ == null) {
                throw new IllegalStateException("Method must be called after #update(GameMediator) called,");
            }
            boolean bl = false;
            int n3 = NodeListPanel.this.tableViewer_.getTable().getSelectionIndex();
            int n4 = NodeListPanel.this.tableViewer_.getTable().getItemCount();
            int n5 = Math.min(NodeListPanel.this.nodeList_.size(), n4);
            for (n2 = 0; n2 < n5; ++n2) {
                if (NodeListPanel.this.nodeList_.getNodeView(n2).equals(NodeListPanel.this.tableViewer_.getElementAt(n2))) continue;
                if (log_s_.isTraceEnabled()) {
                    log_s_.trace("Replace [" + n2 + ',' + n5 + ')');
                }
                for (n = n2; n < n5; ++n) {
                    NodeListPanel.this.tableViewer_.replace(NodeListPanel.this.nodeList_.getNodeView(n), n);
                }
                if (log_s_.isTraceEnabled()) {
                    log_s_.trace("Remove A [" + n5 + ',' + n4 + ')');
                }
                NodeListPanel.this.tableViewer_.remove(this.partOfViewItem(n5, n4));
                n4 = NodeListPanel.this.tableViewer_.getTable().getItemCount();
                bl = true;
                break;
            }
            if (n4 < NodeListPanel.this.nodeList_.size()) {
                if (log_s_.isTraceEnabled()) {
                    log_s_.trace("Add [" + n4 + ',' + NodeListPanel.this.nodeList_.size() + ')');
                }
                NodeListPanel.this.tableViewer_.add(this.partOfModelItem(n4, NodeListPanel.this.nodeList_.size()));
                bl = true;
            } else if (NodeListPanel.this.nodeList_.size() < n4) {
                if (log_s_.isTraceEnabled()) {
                    log_s_.trace("Remove B [" + NodeListPanel.this.nodeList_.size() + ',' + n4 + ')');
                }
                NodeListPanel.this.tableViewer_.remove(this.partOfViewItem(NodeListPanel.this.nodeList_.size(), n4));
                bl = true;
            }
            if (bl) {
                NodeListPanel.this.packColumns();
            }
            n4 = NodeListPanel.this.tableViewer_.getTable().getItemCount();
            n2 = -1;
            for (n = 0; n < n4; ++n) {
                if (!nodeView.isSameNodeEntity((NodeView)NodeListPanel.this.tableViewer_.getElementAt(n))) continue;
                n2 = n;
                break;
            }
            if (n2 == -1) {
                n2 = Math.min(n3, NodeListPanel.this.nodeList_.size() - 1);
            }
            NodeListPanel.this.tableViewer_.update(nodeView, null);
            NodeListPanel.this.tableViewer_.getTable().setSelection(n2);
            if (log_s_.isTraceEnabled()) {
                log_s_.trace("currentChanged(NodeView nodeView): Update [" + n2 + ']' + nodeView);
            }
        }

        private Object[] partOfViewItem(int n, int n2) {
            Object[] objectArray = new Object[n2 - n];
            int n3 = 0;
            for (int i = n; i < n2; ++i) {
                objectArray[n3] = NodeListPanel.this.tableViewer_.getElementAt(i);
                ++n3;
            }
            return objectArray;
        }

        private Object[] partOfModelItem(int n, int n2) {
            Object[] objectArray = new Object[n2 - n];
            int n3 = 0;
            for (int i = n; i < n2; ++i) {
                objectArray[n3] = NodeListPanel.this.nodeList_.getNodeView(i);
                ++n3;
            }
            return objectArray;
        }

        @Override
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            NodeListPanel.this.eventBroker_.removeView(NodeListPanel.this);
            NodeListPanel.this.eventBroker_ = eventBroker;
            NodeListPanel.this.eventBroker_.addView(NodeListPanel.this);
            if (log_s_.isTraceEnabled()) {
                log_s_.trace("setEventBroker(EventBroker eventBroker)" + NodeListPanel.this.eventBroker_);
            }
        }

        @Override
        public void attributeChanged(Set<String> set) {
            ArgumentChecker.throwIfNull(set);
            boolean bl = false;
            if (set.contains(CoordinatesLabelProvider.class.getName())) {
                NodeListLabelProvider nodeListLabelProvider = (NodeListLabelProvider)NodeListPanel.this.tableViewer_.getLabelProvider();
                CoordinatesLabelProvider coordinatesLabelProvider = this.context_.getProvider(CoordinatesLabelProvider.class);
                CoordinatesLabelProvider coordinatesLabelProvider2 = nodeListLabelProvider.getProvider();
                if (!coordinatesLabelProvider2.equals(coordinatesLabelProvider)) {
                    nodeListLabelProvider.setProvider(coordinatesLabelProvider);
                    bl = true;
                }
            }
            if (bl) {
                NodeListPanel.this.refresh();
            }
            if (log_s_.isTraceEnabled()) {
                log_s_.trace("attributeChanged(Set<String> keySet)" + set);
            }
        }
    }

    private class MouseOnGroupListener
    extends MouseTrackAdapter
    implements Listener {
        private MouseOnGroupListener() {
        }

        public void handleEvent(Event event) {
            Table table = NodeListPanel.this.tableViewer_.getTable();
            table.getVerticalBar().setThumb(1);
            int n = table.getSelectionIndex();
            if (n < 0) {
                return;
            }
            if (0 < event.count) {
                if ((n -= event.count / 3) < 0) {
                    n = 0;
                }
            } else if (event.count < 0 && table.getItemCount() <= (n -= event.count / 3)) {
                n = table.getItemCount() - 1;
            }
            if (table.getSelectionIndex() != n) {
                table.setSelection(n);
                NodeListPanel.this.fireNodeSelected();
            }
        }

        public void mouseEnter(MouseEvent mouseEvent) {
            if (NodeListPanel.this.tableViewer_.getTable().getShell() == Display.getCurrent().getActiveShell()) {
                NodeListPanel.this.tableViewer_.getTable().forceFocus();
            }
        }
    }
}

